/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.AuthFastLeaderElection;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderElection;
import org.apache.zookeeper.server.quorum.LeaderElectionBean;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.LocalPeerBean;
import org.apache.zookeeper.server.quorum.Observer;
import org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumBean;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.server.quorum.QuorumStats;
import org.apache.zookeeper.server.quorum.RemotePeerBean;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuorumPeer
extends Thread
implements QuorumStats.Provider {
    private static final Logger LOG = Logger.getLogger(QuorumPeer.class);
    QuorumBean jmxQuorumBean;
    LocalPeerBean jmxLocalPeerBean;
    LeaderElectionBean jmxLeaderElectionBean;
    QuorumCnxManager qcm;
    private ZKDatabase zkDb;
    static final long OBSERVER_ID = Long.MAX_VALUE;
    private LearnerType learnerType = LearnerType.PARTICIPANT;
    protected Map<Long, QuorumServer> quorumPeers;
    private QuorumVerifier quorumConfig;
    private long myid;
    private volatile Vote currentVote;
    volatile boolean running = true;
    protected int tickTime;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected int initLimit;
    protected int syncLimit;
    protected int tick;
    private ServerState state = ServerState.LOOKING;
    DatagramSocket udpSocket;
    private InetSocketAddress myQuorumAddr;
    private int electionType;
    Election electionAlg;
    NIOServerCnxn.Factory cnxnFactory;
    private FileTxnSnapLog logFactory = null;
    private final QuorumStats quorumStats = new QuorumStats(this);
    ResponderThread responder;
    public Follower follower;
    public Leader leader;
    public Observer observer;

    public LearnerType getLearnerType() {
        return this.learnerType;
    }

    public void setLearnerType(LearnerType p) {
        this.learnerType = p;
        if (this.quorumPeers.containsKey(this.myid)) {
            this.quorumPeers.get((Object)Long.valueOf((long)this.myid)).type = p;
        } else {
            LOG.error("Setting LearnerType to " + (Object)((Object)p) + " but " + this.myid + " not in QuorumPeers. ");
        }
    }

    public int getQuorumSize() {
        return this.getVotingView().size();
    }

    @Override
    public long getId() {
        return this.myid;
    }

    public synchronized Vote getCurrentVote() {
        return this.currentVote;
    }

    public synchronized void setCurrentVote(Vote v) {
        this.currentVote = v;
    }

    public synchronized void setPeerState(ServerState newState) {
        this.state = newState;
    }

    public synchronized ServerState getPeerState() {
        return this.state;
    }

    public InetSocketAddress getQuorumAddress() {
        return this.myQuorumAddr;
    }

    public QuorumPeer() {
        super("QuorumPeer");
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File dataDir, File dataLogDir, int electionType, long myid, int tickTime, int initLimit, int syncLimit, NIOServerCnxn.Factory cnxnFactory) throws IOException {
        this(quorumPeers, dataDir, dataLogDir, electionType, myid, tickTime, initLimit, syncLimit, cnxnFactory, (QuorumVerifier)new QuorumMaj(QuorumPeer.countParticipants(quorumPeers)));
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File dataDir, File dataLogDir, int electionType, long myid, int tickTime, int initLimit, int syncLimit, NIOServerCnxn.Factory cnxnFactory, QuorumVerifier quorumConfig) throws IOException {
        this();
        this.cnxnFactory = cnxnFactory;
        this.quorumPeers = quorumPeers;
        this.electionType = electionType;
        this.myid = myid;
        this.tickTime = tickTime;
        this.initLimit = initLimit;
        this.syncLimit = syncLimit;
        this.logFactory = new FileTxnSnapLog(dataLogDir, dataDir);
        this.zkDb = new ZKDatabase(this.logFactory);
        this.quorumConfig = quorumConfig == null ? new QuorumMaj(QuorumPeer.countParticipants(quorumPeers)) : quorumConfig;
    }

    QuorumStats quorumStats() {
        return this.quorumStats;
    }

    @Override
    public synchronized void start() {
        try {
            this.zkDb.loadDataBase();
        }
        catch (IOException ie) {
            LOG.fatal("Unable to load database on disk", ie);
            throw new RuntimeException("Unable to run quorum server ", ie);
        }
        this.cnxnFactory.start();
        this.startLeaderElection();
        super.start();
    }

    public synchronized void stopLeaderElection() {
        this.responder.running = false;
        this.responder.interrupt();
    }

    public synchronized void startLeaderElection() {
        this.currentVote = new Vote(this.myid, this.getLastLoggedZxid());
        for (QuorumServer p : this.getView().values()) {
            if (p.id != this.myid) continue;
            this.myQuorumAddr = p.addr;
            break;
        }
        if (this.myQuorumAddr == null) {
            throw new RuntimeException("My id " + this.myid + " not in the peer list");
        }
        if (this.electionType == 0) {
            try {
                this.udpSocket = new DatagramSocket(this.myQuorumAddr.getPort());
                this.responder = new ResponderThread();
                this.responder.start();
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
        }
        this.electionAlg = this.createElectionAlgorithm(this.electionType);
    }

    protected static int countParticipants(Map<Long, QuorumServer> peers) {
        int count2 = 0;
        for (QuorumServer q : peers.values()) {
            if (q.type != LearnerType.PARTICIPANT) continue;
            ++count2;
        }
        return count2;
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File snapDir, File logDir, int clientPort, int electionAlg, long myid, int tickTime, int initLimit, int syncLimit) throws IOException {
        this(quorumPeers, snapDir, logDir, electionAlg, myid, tickTime, initLimit, syncLimit, new NIOServerCnxn.Factory(new InetSocketAddress(clientPort)), (QuorumVerifier)new QuorumMaj(QuorumPeer.countParticipants(quorumPeers)));
    }

    public QuorumPeer(Map<Long, QuorumServer> quorumPeers, File snapDir, File logDir, int clientPort, int electionAlg, long myid, int tickTime, int initLimit, int syncLimit, QuorumVerifier quorumConfig) throws IOException {
        this(quorumPeers, snapDir, logDir, electionAlg, myid, tickTime, initLimit, syncLimit, new NIOServerCnxn.Factory(new InetSocketAddress(clientPort)), quorumConfig);
    }

    public long getLastLoggedZxid() {
        long lastLogged = -1L;
        try {
            if (!this.zkDb.isInitialized()) {
                this.zkDb.loadDataBase();
            }
            lastLogged = this.zkDb.getDataTreeLastProcessedZxid();
        }
        catch (IOException ie) {
            LOG.warn("Unable to load database ", ie);
        }
        return lastLogged;
    }

    protected Follower makeFollower(FileTxnSnapLog logFactory) throws IOException {
        return new Follower(this, new FollowerZooKeeperServer(logFactory, this, new ZooKeeperServer.BasicDataTreeBuilder(), this.zkDb));
    }

    protected Leader makeLeader(FileTxnSnapLog logFactory) throws IOException {
        return new Leader(this, new LeaderZooKeeperServer(logFactory, this, new ZooKeeperServer.BasicDataTreeBuilder(), this.zkDb));
    }

    protected Observer makeObserver(FileTxnSnapLog logFactory) throws IOException {
        return new Observer(this, new ObserverZooKeeperServer(logFactory, this, new ZooKeeperServer.BasicDataTreeBuilder(), this.zkDb));
    }

    protected Election createElectionAlgorithm(int electionAlgorithm) {
        Election le = null;
        switch (electionAlgorithm) {
            case 0: {
                le = new LeaderElection(this);
                break;
            }
            case 1: {
                le = new AuthFastLeaderElection(this);
                break;
            }
            case 2: {
                le = new AuthFastLeaderElection(this, true);
                break;
            }
            case 3: {
                this.qcm = new QuorumCnxManager(this);
                QuorumCnxManager.Listener listener = this.qcm.listener;
                if (listener != null) {
                    listener.start();
                    le = new FastLeaderElection(this, this.qcm);
                    break;
                }
                LOG.error("Null listener when initializing cnx manager");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return le;
    }

    protected Election makeLEStrategy() {
        LOG.debug("Initializing leader election protocol...");
        if (this.getElectionType() == 0) {
            this.electionAlg = new LeaderElection(this);
        }
        return this.electionAlg;
    }

    protected synchronized void setLeader(Leader newLeader) {
        this.leader = newLeader;
    }

    protected synchronized void setFollower(Follower newFollower) {
        this.follower = newFollower;
    }

    protected synchronized void setObserver(Observer newObserver) {
        this.observer = newObserver;
    }

    public synchronized ZooKeeperServer getActiveServer() {
        if (this.leader != null) {
            return this.leader.zk;
        }
        if (this.follower != null) {
            return this.follower.zk;
        }
        if (this.observer != null) {
            return this.observer.zk;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("QuorumPeer:" + this.cnxnFactory.getLocalAddress());
        LOG.debug("Starting quorum peer");
        try {
            this.jmxQuorumBean = new QuorumBean(this);
            MBeanRegistry.getInstance().register(this.jmxQuorumBean, null);
            for (QuorumServer s2 : this.getView().values()) {
                ZKMBeanInfo p;
                if (this.getId() == s2.id) {
                    this.jmxLocalPeerBean = new LocalPeerBean(this);
                    p = this.jmxLocalPeerBean;
                    try {
                        MBeanRegistry.getInstance().register(p, this.jmxQuorumBean);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to register with JMX", e);
                        this.jmxLocalPeerBean = null;
                    }
                    continue;
                }
                p = new RemotePeerBean(s2);
                try {
                    MBeanRegistry.getInstance().register(p, this.jmxQuorumBean);
                }
                catch (Exception e) {
                    LOG.warn("Failed to register with JMX", e);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxQuorumBean = null;
        }
        try {
            block37: while (this.running) {
                switch (this.getPeerState()) {
                    case LOOKING: {
                        try {
                            LOG.info("LOOKING");
                            this.setCurrentVote(this.makeLEStrategy().lookForLeader());
                        }
                        catch (Exception e) {
                            LOG.warn("Unexpected exception", e);
                            this.setPeerState(ServerState.LOOKING);
                        }
                        break;
                    }
                    case OBSERVING: {
                        try {
                            LOG.info("OBSERVING");
                            this.setObserver(this.makeObserver(this.logFactory));
                            this.observer.observeLeader();
                            continue block37;
                        }
                        catch (Exception e) {
                            LOG.warn("Unexpected exception", e);
                            continue block37;
                        }
                        finally {
                            this.observer.shutdown();
                            this.setObserver(null);
                            this.setPeerState(ServerState.LOOKING);
                            continue block37;
                        }
                    }
                    case FOLLOWING: {
                        try {
                            LOG.info("FOLLOWING");
                            this.setFollower(this.makeFollower(this.logFactory));
                            this.follower.followLeader();
                            continue block37;
                        }
                        catch (Exception e) {
                            LOG.warn("Unexpected exception", e);
                            continue block37;
                        }
                        finally {
                            this.follower.shutdown();
                            this.setFollower(null);
                            this.setPeerState(ServerState.LOOKING);
                            continue block37;
                        }
                    }
                    case LEADING: {
                        LOG.info("LEADING");
                        try {
                            this.setLeader(this.makeLeader(this.logFactory));
                            this.leader.lead();
                            this.setLeader(null);
                            continue block37;
                        }
                        catch (Exception e) {
                            LOG.warn("Unexpected exception", e);
                            continue block37;
                        }
                        finally {
                            if (this.leader != null) {
                                this.leader.shutdown("Forcing shutdown");
                                this.setLeader(null);
                            }
                            this.setPeerState(ServerState.LOOKING);
                            continue block37;
                        }
                    }
                }
            }
        }
        finally {
            LOG.warn("QuorumPeer main thread exited");
            try {
                MBeanRegistry.getInstance().unregisterAll();
            }
            catch (Exception e) {
                LOG.warn("Failed to unregister with JMX", e);
            }
            this.jmxQuorumBean = null;
            this.jmxLocalPeerBean = null;
        }
    }

    public void shutdown() {
        this.running = false;
        if (this.leader != null) {
            this.leader.shutdown("quorum Peer shutdown");
        }
        if (this.follower != null) {
            this.follower.shutdown();
        }
        this.cnxnFactory.shutdown();
        if (this.udpSocket != null) {
            this.udpSocket.close();
        }
        if (this.getElectionAlg() != null) {
            this.getElectionAlg().shutdown();
        }
        try {
            this.zkDb.close();
        }
        catch (IOException ie) {
            LOG.warn("Error closing logs ", ie);
        }
    }

    public Map<Long, QuorumServer> getView() {
        return Collections.unmodifiableMap(this.quorumPeers);
    }

    public Map<Long, QuorumServer> getVotingView() {
        HashMap<Long, QuorumServer> ret = new HashMap<Long, QuorumServer>();
        Map<Long, QuorumServer> view = this.getView();
        for (QuorumServer server : view.values()) {
            if (server.type != LearnerType.PARTICIPANT) continue;
            ret.put(server.id, server);
        }
        return ret;
    }

    public Map<Long, QuorumServer> getObservingView() {
        HashMap<Long, QuorumServer> ret = new HashMap<Long, QuorumServer>();
        Map<Long, QuorumServer> view = this.getView();
        for (QuorumServer server : view.values()) {
            if (server.type != LearnerType.OBSERVER) continue;
            ret.put(server.id, server);
        }
        return ret;
    }

    public boolean viewContains(Long sid) {
        return this.quorumPeers.containsKey(sid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getQuorumPeers() {
        ArrayList<String> l = new ArrayList<String>();
        QuorumPeer quorumPeer = this;
        synchronized (quorumPeer) {
            if (this.leader != null) {
                HashSet<LearnerHandler> hashSet = this.leader.learners;
                synchronized (hashSet) {
                    for (LearnerHandler fh : this.leader.learners) {
                        if (fh.getSocket() == null) continue;
                        String s2 = fh.getSocket().getRemoteSocketAddress().toString();
                        if (this.leader.isLearnerSynced(fh)) {
                            s2 = s2 + "*";
                        }
                        l.add(s2);
                    }
                }
            } else if (this.follower != null) {
                l.add(this.follower.sock.getRemoteSocketAddress().toString());
            }
        }
        return l.toArray(new String[0]);
    }

    @Override
    public String getServerState() {
        switch (this.getPeerState()) {
            case LOOKING: {
                return "leaderelection";
            }
            case LEADING: {
                return "leading";
            }
            case FOLLOWING: {
                return "following";
            }
            case OBSERVING: {
                return "observing";
            }
        }
        return "unknown";
    }

    public long getMyid() {
        return this.myid;
    }

    public void setMyid(long myid) {
        this.myid = myid;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public void setTickTime(int tickTime) {
        LOG.info("tickTime set to " + tickTime);
        this.tickTime = tickTime;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout == -1 ? this.tickTime * 2 : this.minSessionTimeout;
    }

    public void setMinSessionTimeout(int min2) {
        LOG.info("minSessionTimeout set to " + min2);
        this.minSessionTimeout = min2;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout == -1 ? this.tickTime * 20 : this.maxSessionTimeout;
    }

    public void setMaxSessionTimeout(int max2) {
        LOG.info("maxSessionTimeout set to " + max2);
        this.maxSessionTimeout = max2;
    }

    public int getInitLimit() {
        return this.initLimit;
    }

    public void setInitLimit(int initLimit) {
        LOG.info("initLimit set to " + initLimit);
        this.initLimit = initLimit;
    }

    public int getTick() {
        return this.tick;
    }

    public QuorumVerifier getQuorumVerifier() {
        return this.quorumConfig;
    }

    public void setQuorumVerifier(QuorumVerifier quorumConfig) {
        this.quorumConfig = quorumConfig;
    }

    public Election getElectionAlg() {
        return this.electionAlg;
    }

    public int getSyncLimit() {
        return this.syncLimit;
    }

    public void setSyncLimit(int syncLimit) {
        this.syncLimit = syncLimit;
    }

    public int getElectionType() {
        return this.electionType;
    }

    public void setElectionType(int electionType) {
        this.electionType = electionType;
    }

    public NIOServerCnxn.Factory getCnxnFactory() {
        return this.cnxnFactory;
    }

    public void setCnxnFactory(NIOServerCnxn.Factory cnxnFactory) {
        this.cnxnFactory = cnxnFactory;
    }

    public void setQuorumPeers(Map<Long, QuorumServer> quorumPeers) {
        this.quorumPeers = quorumPeers;
    }

    public int getClientPort() {
        return this.cnxnFactory.getLocalPort();
    }

    public void setClientPortAddress(InetSocketAddress addr) {
    }

    public void setTxnFactory(FileTxnSnapLog factory) {
        this.logFactory = factory;
    }

    public FileTxnSnapLog getTxnFactory() {
        return this.logFactory;
    }

    public void setZKDatabase(ZKDatabase database) {
        this.zkDb = database;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isRunning() {
        return this.running;
    }

    public QuorumCnxManager getQuorumCnxManager() {
        return this.qcm;
    }

    class ResponderThread
    extends Thread {
        volatile boolean running;

        ResponderThread() {
            super("ResponderThread");
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                byte[] b = new byte[36];
                ByteBuffer responseBuffer = ByteBuffer.wrap(b);
                DatagramPacket packet = new DatagramPacket(b, b.length);
                while (this.running) {
                    QuorumPeer.this.udpSocket.receive(packet);
                    if (packet.getLength() != 4) {
                        LOG.warn("Got more than just an xid! Len = " + packet.getLength());
                    } else {
                        responseBuffer.clear();
                        responseBuffer.getInt();
                        responseBuffer.putLong(QuorumPeer.this.myid);
                        Vote current = QuorumPeer.this.getCurrentVote();
                        switch (QuorumPeer.this.getPeerState()) {
                            case LOOKING: {
                                responseBuffer.putLong(current.id);
                                responseBuffer.putLong(current.zxid);
                                break;
                            }
                            case LEADING: {
                                responseBuffer.putLong(QuorumPeer.this.myid);
                                try {
                                    long proposed;
                                    Leader leader = QuorumPeer.this.leader;
                                    synchronized (leader) {
                                        proposed = QuorumPeer.this.leader.lastProposed;
                                    }
                                    responseBuffer.putLong(proposed);
                                }
                                catch (NullPointerException npe) {}
                                break;
                            }
                            case FOLLOWING: {
                                responseBuffer.putLong(current.id);
                                try {
                                    responseBuffer.putLong(QuorumPeer.this.follower.getZxid());
                                }
                                catch (NullPointerException npe) {}
                                break;
                            }
                        }
                        packet.setData(b);
                        QuorumPeer.this.udpSocket.send(packet);
                    }
                    packet.setLength(b.length);
                }
            }
            catch (Exception e) {
                LOG.warn("Unexpected exception in ResponderThread", e);
            }
            finally {
                LOG.warn("QuorumPeer responder thread exited");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LearnerType {
        PARTICIPANT,
        OBSERVER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerState {
        LOOKING,
        FOLLOWING,
        LEADING,
        OBSERVING;

    }

    public static class QuorumServer {
        public InetSocketAddress addr;
        public InetSocketAddress electionAddr;
        public long id;
        public LearnerType type = LearnerType.PARTICIPANT;

        public QuorumServer(long id, InetSocketAddress addr, InetSocketAddress electionAddr) {
            this.id = id;
            this.addr = addr;
            this.electionAddr = electionAddr;
        }

        public QuorumServer(long id, InetSocketAddress addr) {
            this.id = id;
            this.addr = addr;
            this.electionAddr = null;
        }

        public QuorumServer(long id, InetSocketAddress addr, InetSocketAddress electionAddr, LearnerType type) {
            this.id = id;
            this.addr = addr;
            this.electionAddr = electionAddr;
            this.type = type;
        }
    }

    public static interface Factory {
        public QuorumPeer create(NIOServerCnxn.Factory var1) throws IOException;

        public NIOServerCnxn.Factory createConnectionFactory() throws IOException;
    }
}

