/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.LeaderElectionBean;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthFastLeaderElection
implements Election {
    private static final Logger LOG = Logger.getLogger(AuthFastLeaderElection.class);
    static int sequencer = 0;
    static int maxTag = 0;
    static int finalizeWait = 100;
    static int challengeCounter = 0;
    private boolean authEnabled = false;
    LinkedBlockingQueue<ToSend> sendqueue;
    LinkedBlockingQueue<Notification> recvqueue;
    QuorumPeer self;
    int port;
    volatile long logicalclock;
    DatagramSocket mySocket;
    long proposedLeader;
    long proposedZxid;

    public AuthFastLeaderElection(QuorumPeer self, boolean auth) {
        this.authEnabled = auth;
        this.starter(self);
    }

    public AuthFastLeaderElection(QuorumPeer self) {
        this.starter(self);
    }

    private void starter(QuorumPeer self) {
        this.self = self;
        this.port = self.getVotingView().get((Object)Long.valueOf((long)self.getId())).electionAddr.getPort();
        this.proposedLeader = -1L;
        this.proposedZxid = -1L;
        try {
            this.mySocket = new DatagramSocket(this.port);
        }
        catch (SocketException e1) {
            e1.printStackTrace();
            throw new RuntimeException();
        }
        this.sendqueue = new LinkedBlockingQueue(2 * self.getVotingView().size());
        this.recvqueue = new LinkedBlockingQueue(2 * self.getVotingView().size());
        new Messenger(self.getVotingView().size() * 2, this.mySocket);
    }

    private void leaveInstance() {
        ++this.logicalclock;
    }

    private void sendNotifications() {
        for (QuorumPeer.QuorumServer server : this.self.getView().values()) {
            ToSend notmsg = new ToSend(ToSend.mType.notification, sequencer++, this.proposedLeader, this.proposedZxid, this.logicalclock, QuorumPeer.ServerState.LOOKING, this.self.getView().get((Object)Long.valueOf((long)server.id)).electionAddr);
            this.sendqueue.offer(notmsg);
        }
    }

    private boolean totalOrderPredicate(long id, long zxid) {
        return zxid > this.proposedZxid || zxid == this.proposedZxid && id > this.proposedLeader;
    }

    private boolean termPredicate(HashMap<InetSocketAddress, Vote> votes, long l, long zxid) {
        Collection<Vote> votesCast = votes.values();
        int count2 = 0;
        for (Vote v : votesCast) {
            if (v.id != l || v.zxid != zxid) continue;
            ++count2;
        }
        return count2 > this.self.getVotingView().size() / 2;
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vote lookForLeader() throws InterruptedException {
        try {
            this.self.jmxLeaderElectionBean = new LeaderElectionBean();
            MBeanRegistry.getInstance().register(this.self.jmxLeaderElectionBean, this.self.jmxLocalPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            HashMap<InetSocketAddress, Vote> recvset = new HashMap<InetSocketAddress, Vote>();
            HashMap<InetSocketAddress, Vote> outofelection = new HashMap<InetSocketAddress, Vote>();
            ++this.logicalclock;
            this.proposedLeader = this.self.getId();
            this.proposedZxid = this.self.getLastLoggedZxid();
            LOG.info("Election tally");
            this.sendNotifications();
            while (this.self.getPeerState() == QuorumPeer.ServerState.LOOKING) {
                Notification n = this.recvqueue.poll(2 * finalizeWait, TimeUnit.MILLISECONDS);
                if (n == null) {
                    if (!outofelection.isEmpty() || recvset.size() > 1) {
                        this.sendNotifications();
                    }
                    continue;
                }
                switch (n.state) {
                    case LOOKING: {
                        if (n.epoch > this.logicalclock) {
                            this.logicalclock = n.epoch;
                            recvset.clear();
                            if (this.totalOrderPredicate(n.leader, n.zxid)) {
                                this.proposedLeader = n.leader;
                                this.proposedZxid = n.zxid;
                            }
                            this.sendNotifications();
                        } else {
                            if (n.epoch < this.logicalclock) break;
                            if (this.totalOrderPredicate(n.leader, n.zxid)) {
                                this.proposedLeader = n.leader;
                                this.proposedZxid = n.zxid;
                                this.sendNotifications();
                            }
                        }
                        recvset.put(n.addr, new Vote(n.leader, n.zxid));
                        if (this.self.getVotingView().size() == recvset.size()) {
                            this.self.setPeerState(this.proposedLeader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                            this.leaveInstance();
                            Vote vote = new Vote(this.proposedLeader, this.proposedZxid);
                            return vote;
                        }
                        if (!this.termPredicate(recvset, this.proposedLeader, this.proposedZxid)) break;
                        LOG.info("Passed predicate");
                        Thread.sleep(finalizeWait);
                        while (!this.recvqueue.isEmpty() && !this.totalOrderPredicate(this.recvqueue.peek().leader, this.recvqueue.peek().zxid)) {
                            this.recvqueue.poll();
                        }
                        if (!this.recvqueue.isEmpty()) break;
                        this.self.setPeerState(this.proposedLeader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                        this.leaveInstance();
                        Vote vote = new Vote(this.proposedLeader, this.proposedZxid);
                        return vote;
                    }
                    case LEADING: {
                        outofelection.put(n.addr, new Vote(n.leader, n.zxid));
                        if (!this.termPredicate(outofelection, n.leader, n.zxid)) break;
                        this.self.setPeerState(n.leader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                        this.leaveInstance();
                        Vote vote = new Vote(n.leader, n.zxid);
                        return vote;
                    }
                    case FOLLOWING: {
                        outofelection.put(n.addr, new Vote(n.leader, n.zxid));
                        if (!this.termPredicate(outofelection, n.leader, n.zxid)) break;
                        this.self.setPeerState(n.leader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                        this.leaveInstance();
                        Vote vote = new Vote(n.leader, n.zxid);
                        return vote;
                    }
                }
            }
            Vote vote = null;
            return vote;
        }
        finally {
            try {
                if (this.self.jmxLeaderElectionBean != null) {
                    MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to unregister with JMX", e);
            }
            this.self.jmxLeaderElectionBean = null;
        }
    }

    private class Messenger {
        final DatagramSocket mySocket;
        long lastProposedLeader;
        long lastProposedZxid;
        long lastEpoch;
        final LinkedBlockingQueue<Long> acksqueue;
        final HashMap<Long, Long> challengeMap;
        final HashMap<Long, Semaphore> challengeMutex;
        final HashMap<Long, Semaphore> ackMutex;
        final HashMap<InetSocketAddress, HashMap<Long, Long>> addrChallengeMap;

        public boolean queueEmpty() {
            return AuthFastLeaderElection.this.sendqueue.isEmpty() || this.acksqueue.isEmpty() || AuthFastLeaderElection.this.recvqueue.isEmpty();
        }

        Messenger(int threads, DatagramSocket s2) {
            this.mySocket = s2;
            this.acksqueue = new LinkedBlockingQueue();
            this.challengeMap = new HashMap();
            this.challengeMutex = new HashMap();
            this.ackMutex = new HashMap();
            this.addrChallengeMap = new HashMap();
            this.lastProposedLeader = 0L;
            this.lastProposedZxid = 0L;
            this.lastEpoch = 0L;
            for (int i = 0; i < threads; ++i) {
                Thread t = new Thread((Runnable)new WorkerSender(3), "WorkerSender Thread: " + (i + 1));
                t.setDaemon(true);
                t.start();
            }
            for (QuorumPeer.QuorumServer server : AuthFastLeaderElection.this.self.getVotingView().values()) {
                InetSocketAddress saddr = new InetSocketAddress(server.addr.getAddress(), AuthFastLeaderElection.this.port);
                this.addrChallengeMap.put(saddr, new HashMap());
            }
            Thread t = new Thread((Runnable)new WorkerReceiver(s2, this), "WorkerReceiver Thread");
            t.start();
        }

        class WorkerSender
        implements Runnable {
            Random rand;
            int maxAttempts;
            int ackWait = finalizeWait;

            WorkerSender(int attempts) {
                this.maxAttempts = attempts;
                this.rand = new Random(Thread.currentThread().getId() + System.currentTimeMillis());
            }

            long genChallenge() {
                byte[] buf = new byte[8];
                buf[0] = (byte)((challengeCounter & 0xFF000000) >>> 24);
                buf[1] = (byte)((challengeCounter & 0xFF0000) >>> 16);
                buf[2] = (byte)((challengeCounter & 0xFF00) >>> 8);
                buf[3] = (byte)(challengeCounter & 0xFF);
                ++challengeCounter;
                int secret = this.rand.nextInt(Integer.MAX_VALUE);
                buf[4] = (byte)((secret & 0xFF000000) >>> 24);
                buf[5] = (byte)((secret & 0xFF0000) >>> 16);
                buf[6] = (byte)((secret & 0xFF00) >>> 8);
                buf[7] = (byte)(secret & 0xFF);
                return ((long)(buf[0] & 0xFF) << 56) + ((long)(buf[1] & 0xFF) << 48) + ((long)(buf[2] & 0xFF) << 40) + ((long)(buf[3] & 0xFF) << 32) + ((long)(buf[4] & 0xFF) << 24) + ((long)(buf[5] & 0xFF) << 16) + ((long)(buf[6] & 0xFF) << 8) + (long)(buf[7] & 0xFF);
            }

            public void run() {
                try {
                    while (true) {
                        ToSend m = AuthFastLeaderElection.this.sendqueue.take();
                        this.process(m);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void process(ToSend m) {
                int attempts = 0;
                byte[] requestBytes = new byte[48];
                DatagramPacket requestPacket = new DatagramPacket(requestBytes, requestBytes.length);
                ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
                switch (m.type) {
                    case 0: {
                        requestBuffer.clear();
                        requestBuffer.putInt(ToSend.mType.crequest.ordinal());
                        requestBuffer.putLong(m.tag);
                        requestBuffer.putInt(m.state.ordinal());
                        byte[] zeroes = new byte[32];
                        requestBuffer.put(zeroes);
                        requestPacket.setLength(48);
                        try {
                            requestPacket.setSocketAddress(m.addr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + m.addr, e);
                        }
                        try {
                            if (Messenger.this.challengeMap.get(m.tag) != null) break;
                            Messenger.this.mySocket.send(requestPacket);
                        }
                        catch (IOException e) {
                            LOG.warn("Exception while sending challenge: ", e);
                        }
                        break;
                    }
                    case 1: {
                        long newChallenge = Messenger.this.addrChallengeMap.get(m.addr).containsKey(m.tag) ? Messenger.this.addrChallengeMap.get(m.addr).get(m.tag).longValue() : this.genChallenge();
                        Messenger.this.addrChallengeMap.get(m.addr).put(m.tag, newChallenge);
                        requestBuffer.clear();
                        requestBuffer.putInt(ToSend.mType.challenge.ordinal());
                        requestBuffer.putLong(m.tag);
                        requestBuffer.putInt(m.state.ordinal());
                        requestBuffer.putLong(newChallenge);
                        byte[] zeroes = new byte[24];
                        requestBuffer.put(zeroes);
                        requestPacket.setLength(48);
                        try {
                            requestPacket.setSocketAddress(m.addr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + m.addr, e);
                        }
                        try {
                            Messenger.this.mySocket.send(requestPacket);
                        }
                        catch (IOException e) {
                            LOG.warn("Exception while sending challenge: ", e);
                        }
                        break;
                    }
                    case 2: {
                        requestBuffer.clear();
                        requestBuffer.putInt(m.type);
                        requestBuffer.putLong(m.tag);
                        requestBuffer.putInt(m.state.ordinal());
                        requestBuffer.putLong(m.leader);
                        requestBuffer.putLong(m.zxid);
                        requestBuffer.putLong(m.epoch);
                        byte[] zeroes = new byte[8];
                        requestBuffer.put(zeroes);
                        requestPacket.setLength(48);
                        try {
                            requestPacket.setSocketAddress(m.addr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + m.addr, e);
                        }
                        boolean myChallenge = false;
                        boolean myAck = false;
                        while (attempts < this.maxAttempts) {
                            try {
                                if (!myChallenge && AuthFastLeaderElection.this.authEnabled) {
                                    ToSend crequest = new ToSend(ToSend.mType.crequest, m.tag, m.leader, m.zxid, m.epoch, QuorumPeer.ServerState.LOOKING, m.addr);
                                    AuthFastLeaderElection.this.sendqueue.offer(crequest);
                                    try {
                                        Semaphore s2;
                                        double timeout = (double)this.ackWait * Math.pow(2.0, attempts);
                                        Semaphore semaphore = s2 = new Semaphore(0);
                                        synchronized (semaphore) {
                                            Messenger.this.challengeMutex.put(m.tag, s2);
                                            s2.tryAcquire((long)timeout, TimeUnit.MILLISECONDS);
                                            myChallenge = Messenger.this.challengeMap.containsKey(m.tag);
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        LOG.warn("Challenge request exception: ", e);
                                    }
                                }
                                if (AuthFastLeaderElection.this.authEnabled && !myChallenge) {
                                    ++attempts;
                                    continue;
                                }
                                if (AuthFastLeaderElection.this.authEnabled) {
                                    requestBuffer.position(40);
                                    requestBuffer.putLong(Messenger.this.challengeMap.get(m.tag));
                                }
                                Messenger.this.mySocket.send(requestPacket);
                                try {
                                    Semaphore s3 = new Semaphore(0);
                                    double timeout = (double)this.ackWait * Math.pow(10.0, attempts);
                                    Messenger.this.ackMutex.put(m.tag, s3);
                                    s3.tryAcquire((int)timeout, TimeUnit.MILLISECONDS);
                                }
                                catch (InterruptedException e) {
                                    LOG.warn("Ack exception: ", e);
                                }
                                LinkedBlockingQueue<Long> e = Messenger.this.acksqueue;
                                synchronized (e) {
                                    for (int i = 0; i < Messenger.this.acksqueue.size(); ++i) {
                                        Long newack = Messenger.this.acksqueue.poll();
                                        if (newack == m.tag) {
                                            myAck = true;
                                            continue;
                                        }
                                        Messenger.this.acksqueue.offer(newack);
                                    }
                                }
                            }
                            catch (IOException e) {
                                LOG.warn("Sending exception: ", e);
                            }
                            if (myAck) {
                                if (Messenger.this.challengeMap.get(m.tag) != null) {
                                    Messenger.this.challengeMap.remove(m.tag);
                                }
                                return;
                            }
                            ++attempts;
                        }
                        if (m.epoch != AuthFastLeaderElection.this.logicalclock) break;
                        Messenger.this.challengeMap.remove(m.tag);
                        AuthFastLeaderElection.this.sendqueue.offer(m);
                        break;
                    }
                    case 3: {
                        requestBuffer.clear();
                        requestBuffer.putInt(m.type);
                        requestBuffer.putLong(m.tag);
                        requestBuffer.putInt(m.state.ordinal());
                        requestBuffer.putLong(m.leader);
                        requestBuffer.putLong(m.zxid);
                        requestBuffer.putLong(m.epoch);
                        requestPacket.setLength(48);
                        try {
                            requestPacket.setSocketAddress(m.addr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + m.addr, e);
                        }
                        try {
                            Messenger.this.mySocket.send(requestPacket);
                            break;
                        }
                        catch (IOException e) {
                            LOG.warn("Exception while sending ack: ", e);
                        }
                    }
                }
            }
        }

        class WorkerReceiver
        implements Runnable {
            DatagramSocket mySocket;
            Messenger myMsg;

            WorkerReceiver(DatagramSocket s2, Messenger msg) {
                this.mySocket = s2;
                this.myMsg = msg;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean saveChallenge(long tag, long challenge) {
                Semaphore s2 = Messenger.this.challengeMutex.get(tag);
                if (s2 != null) {
                    HashMap<Long, Long> hashMap = Messenger.this.challengeMap;
                    synchronized (hashMap) {
                        Messenger.this.challengeMap.put(tag, challenge);
                        Messenger.this.challengeMutex.remove(tag);
                    }
                    s2.release();
                } else {
                    LOG.error("No challenge mutex object");
                }
                return true;
            }

            public void run() {
                byte[] responseBytes = new byte[48];
                ByteBuffer responseBuffer = ByteBuffer.wrap(responseBytes);
                DatagramPacket responsePacket = new DatagramPacket(responseBytes, responseBytes.length);
                block13: while (true) {
                    try {
                        responseBuffer.clear();
                        this.mySocket.receive(responsePacket);
                    }
                    catch (IOException e) {
                        LOG.warn("Ignoring exception receiving", e);
                    }
                    if (responsePacket.getLength() != responseBytes.length) {
                        LOG.warn("Got a short response: " + responsePacket.getLength() + " " + responsePacket.toString());
                        continue;
                    }
                    responseBuffer.clear();
                    int type = responseBuffer.getInt();
                    if (type > 3 || type < 0) {
                        LOG.warn("Got bad Msg type: " + type);
                        continue;
                    }
                    long tag = responseBuffer.getLong();
                    QuorumPeer.ServerState ackstate = QuorumPeer.ServerState.LOOKING;
                    switch (responseBuffer.getInt()) {
                        case 0: {
                            ackstate = QuorumPeer.ServerState.LOOKING;
                            break;
                        }
                        case 1: {
                            ackstate = QuorumPeer.ServerState.LEADING;
                            break;
                        }
                        case 2: {
                            ackstate = QuorumPeer.ServerState.FOLLOWING;
                        }
                    }
                    Vote current = AuthFastLeaderElection.this.self.getCurrentVote();
                    switch (type) {
                        case 0: {
                            ToSend c = new ToSend(ToSend.mType.challenge, tag, current.id, current.zxid, AuthFastLeaderElection.this.logicalclock, AuthFastLeaderElection.this.self.getPeerState(), (InetSocketAddress)responsePacket.getSocketAddress());
                            AuthFastLeaderElection.this.sendqueue.offer(c);
                            continue block13;
                        }
                        case 1: {
                            long challenge = responseBuffer.getLong();
                            this.saveChallenge(tag, challenge);
                            continue block13;
                        }
                        case 2: {
                            ToSend a;
                            Notification n = new Notification();
                            n.leader = responseBuffer.getLong();
                            n.zxid = responseBuffer.getLong();
                            n.epoch = responseBuffer.getLong();
                            n.state = ackstate;
                            n.addr = (InetSocketAddress)responsePacket.getSocketAddress();
                            if (this.myMsg.lastEpoch <= n.epoch && (n.zxid > this.myMsg.lastProposedZxid || n.zxid == this.myMsg.lastProposedZxid && n.leader > this.myMsg.lastProposedLeader)) {
                                this.myMsg.lastProposedZxid = n.zxid;
                                this.myMsg.lastProposedLeader = n.leader;
                                this.myMsg.lastEpoch = n.epoch;
                            }
                            InetSocketAddress addr = (InetSocketAddress)responsePacket.getSocketAddress();
                            if (AuthFastLeaderElection.this.authEnabled) {
                                if (Messenger.this.addrChallengeMap.get(addr).get(tag) != null) {
                                    long recChallenge = responseBuffer.getLong();
                                    if (Messenger.this.addrChallengeMap.get(addr).get(tag) == recChallenge) {
                                        AuthFastLeaderElection.this.recvqueue.offer(n);
                                        a = new ToSend(ToSend.mType.ack, tag, current.id, current.zxid, AuthFastLeaderElection.this.logicalclock, AuthFastLeaderElection.this.self.getPeerState(), addr);
                                        AuthFastLeaderElection.this.sendqueue.offer(a);
                                        continue block13;
                                    }
                                    LOG.warn("Incorrect challenge: " + recChallenge + ", " + Messenger.this.addrChallengeMap.toString());
                                    continue block13;
                                }
                                LOG.warn("No challenge for host: " + addr + " " + tag);
                                continue block13;
                            }
                            AuthFastLeaderElection.this.recvqueue.offer(n);
                            a = new ToSend(ToSend.mType.ack, tag, current.id, current.zxid, AuthFastLeaderElection.this.logicalclock, AuthFastLeaderElection.this.self.getPeerState(), (InetSocketAddress)responsePacket.getSocketAddress());
                            AuthFastLeaderElection.this.sendqueue.offer(a);
                            continue block13;
                        }
                        case 3: {
                            Semaphore s2 = Messenger.this.ackMutex.get(tag);
                            if (s2 != null) {
                                s2.release();
                            } else {
                                LOG.error("Empty ack semaphore");
                            }
                            Messenger.this.acksqueue.offer(tag);
                            if (AuthFastLeaderElection.this.authEnabled) {
                                Messenger.this.addrChallengeMap.get(responsePacket.getSocketAddress()).remove(tag);
                            }
                            if (ackstate == QuorumPeer.ServerState.LOOKING) continue block13;
                            Notification outofsync = new Notification();
                            outofsync.leader = responseBuffer.getLong();
                            outofsync.zxid = responseBuffer.getLong();
                            outofsync.epoch = responseBuffer.getLong();
                            outofsync.state = ackstate;
                            outofsync.addr = (InetSocketAddress)responsePacket.getSocketAddress();
                            AuthFastLeaderElection.this.recvqueue.offer(outofsync);
                            continue block13;
                        }
                    }
                    LOG.warn("Received message of incorrect type " + type);
                }
            }
        }
    }

    public static class ToSend {
        int type;
        long leader;
        long zxid;
        long epoch;
        QuorumPeer.ServerState state;
        long tag;
        InetSocketAddress addr;

        ToSend(mType type, long tag, long leader, long zxid, long epoch, QuorumPeer.ServerState state, InetSocketAddress addr) {
            switch (type) {
                case crequest: {
                    this.type = 0;
                    this.tag = tag;
                    this.leader = leader;
                    this.zxid = zxid;
                    this.epoch = epoch;
                    this.state = state;
                    this.addr = addr;
                    break;
                }
                case challenge: {
                    this.type = 1;
                    this.tag = tag;
                    this.leader = leader;
                    this.zxid = zxid;
                    this.epoch = epoch;
                    this.state = state;
                    this.addr = addr;
                    break;
                }
                case notification: {
                    this.type = 2;
                    this.leader = leader;
                    this.zxid = zxid;
                    this.epoch = epoch;
                    this.state = QuorumPeer.ServerState.LOOKING;
                    this.tag = tag;
                    this.addr = addr;
                    break;
                }
                case ack: {
                    this.type = 3;
                    this.tag = tag;
                    this.leader = leader;
                    this.zxid = zxid;
                    this.epoch = epoch;
                    this.state = state;
                    this.addr = addr;
                    break;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum mType {
            crequest,
            challenge,
            notification,
            ack;

        }
    }

    public static class Notification {
        long leader;
        long zxid;
        long epoch;
        QuorumPeer.ServerState state;
        InetSocketAddress addr;
    }
}

