/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.Mutable;

public class MutableLong
extends Number
implements Comparable<MutableLong>,
Mutable<Number> {
    private static final long serialVersionUID = 62986528375L;
    private long value;

    public MutableLong() {
    }

    public MutableLong(long value2) {
        this.value = value2;
    }

    public MutableLong(Number value2) {
        this.value = value2.longValue();
    }

    public MutableLong(String value2) throws NumberFormatException {
        this.value = Long.parseLong(value2);
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public void setValue(long value2) {
        this.value = value2;
    }

    @Override
    public void setValue(Number value2) {
        this.value = value2.longValue();
    }

    public void increment() {
        ++this.value;
    }

    public long getAndIncrement() {
        long last2 = this.value++;
        return last2;
    }

    public long incrementAndGet() {
        ++this.value;
        return this.value;
    }

    public void decrement() {
        --this.value;
    }

    public long getAndDecrement() {
        long last2 = this.value--;
        return last2;
    }

    public long decrementAndGet() {
        --this.value;
        return this.value;
    }

    public void add(long operand) {
        this.value += operand;
    }

    public void add(Number operand) {
        this.value += operand.longValue();
    }

    public void subtract(long operand) {
        this.value -= operand;
    }

    public void subtract(Number operand) {
        this.value -= operand.longValue();
    }

    public long addAndGet(long operand) {
        this.value += operand;
        return this.value;
    }

    public long addAndGet(Number operand) {
        this.value += operand.longValue();
        return this.value;
    }

    public long getAndAdd(long operand) {
        long last2 = this.value;
        this.value += operand;
        return last2;
    }

    public long getAndAdd(Number operand) {
        long last2 = this.value;
        this.value += operand.longValue();
        return last2;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public Long toLong() {
        return this.longValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableLong) {
            return this.value == ((MutableLong)obj).longValue();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public int compareTo(MutableLong other) {
        return NumberUtils.compare(this.value, other.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

