/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.common.BrokerNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsumerOffsetChecker$
implements Logging {
    public static final ConsumerOffsetChecker$ MODULE$;
    private final scala.collection.mutable.Map<Object, Option<SimpleConsumer>> consumerMap;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ConsumerOffsetChecker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ConsumerOffsetChecker$ consumerOffsetChecker$ = this;
        synchronized (consumerOffsetChecker$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private scala.collection.mutable.Map<Object, Option<SimpleConsumer>> consumerMap() {
        return this.consumerMap;
    }

    public Option<SimpleConsumer> kafka$tools$ConsumerOffsetChecker$$getConsumer(ZkClient zkClient, int bid) {
        Option option;
        try {
            Some<SimpleConsumer> some;
            Option<Object> option2;
            Option<String> option3 = ZkUtils$.MODULE$.readDataMaybeNull(zkClient, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(bid)).toString())._1();
            if (option3 instanceof Some) {
                Some some2 = (Some)option3;
                String brokerInfoString = (String)some2.x();
                option2 = Json$.MODULE$.parseFull(brokerInfoString);
                if (!(option2 instanceof Some)) {
                    None$ none$ = None$.MODULE$;
                    Option<Object> option4 = option2;
                    if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
                        throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %d does not exist")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(bid)})));
                    }
                    throw new MatchError(option2);
                }
            } else {
                None$ none$ = None$.MODULE$;
                Option<String> option5 = option3;
                if (!(none$ != null ? !none$.equals(option5) : option5 != null)) {
                    throw new BrokerNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Broker id %d does not exist")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(bid)})));
                }
                throw new MatchError(option3);
            }
            Some some3 = (Some)option2;
            Object m = some3.x();
            Map brokerInfo = (Map)m;
            String host = (String)brokerInfo.get("host").get();
            int port = BoxesRunTime.unboxToInt(brokerInfo.get("port").get());
            Some<SimpleConsumer> some4 = some = new Some<SimpleConsumer>(new SimpleConsumer(host, port, 10000, 100000, "ConsumerOffsetChecker"));
            option = some4;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Could not parse broker info";
                }
            }), (Function0<Throwable>)((Object)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            }));
            option = None$.MODULE$;
        }
        return option;
    }

    public void kafka$tools$ConsumerOffsetChecker$$processPartition(ZkClient zkClient, String group, String topic, int pid) {
        Option<Object> option;
        block10: {
            block9: {
                block2: {
                    Option<SimpleConsumer> option2;
                    block8: {
                        block7: {
                            block3: {
                                Option<String> option3;
                                block6: {
                                    String string2;
                                    Object[] objectArray;
                                    StringOps stringOps;
                                    block5: {
                                        block4: {
                                            String ownerStr;
                                            long offset = new StringOps(Predef$.MODULE$.augmentString(ZkUtils$.MODULE$.readData(zkClient, new StringOps(Predef$.MODULE$.augmentString("/consumers/%s/offsets/%s/%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{group, topic, BoxesRunTime.boxToInteger(pid)})))._1())).toLong();
                                            Option<String> owner = ZkUtils$.MODULE$.readDataMaybeNull(zkClient, new StringOps(Predef$.MODULE$.augmentString("/consumers/%s/owners/%s/%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{group, topic, BoxesRunTime.boxToInteger(pid)})))._1();
                                            option = ZkUtils$.MODULE$.getLeaderForPartition(zkClient, topic, pid);
                                            if (!(option instanceof Some)) break block2;
                                            Some some = (Some)option;
                                            int bid = BoxesRunTime.unboxToInt(some.x());
                                            Option<SimpleConsumer> consumerOpt = this.consumerMap().getOrElseUpdate(BoxesRunTime.boxToInteger(bid), (Function0<Option<SimpleConsumer>>)((Object)new Serializable(zkClient, bid){
                                                public static final long serialVersionUID = 0L;
                                                private final ZkClient zkClient$1;
                                                private final int bid$1;

                                                public final Option<SimpleConsumer> apply() {
                                                    return ConsumerOffsetChecker$.MODULE$.kafka$tools$ConsumerOffsetChecker$$getConsumer(this.zkClient$1, this.bid$1);
                                                }
                                                {
                                                    this.zkClient$1 = zkClient$1;
                                                    this.bid$1 = bid$1;
                                                }
                                            }));
                                            option2 = consumerOpt;
                                            if (!(option2 instanceof Some)) break block3;
                                            Some some2 = (Some)option2;
                                            SimpleConsumer consumer = (SimpleConsumer)some2.x();
                                            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, pid);
                                            OffsetRequest request = new OffsetRequest((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(topicAndPartition), new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 1))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                                            long logSize = BoxesRunTime.unboxToLong(((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply(topicAndPartition)).offsets().head());
                                            long lag = logSize - offset;
                                            stringOps = new StringOps(Predef$.MODULE$.augmentString("%-15s %-30s %-3s %-15s %-15s %-15s %s"));
                                            objectArray = new Object[7];
                                            objectArray[0] = group;
                                            objectArray[1] = topic;
                                            objectArray[2] = BoxesRunTime.boxToInteger(pid);
                                            objectArray[3] = BoxesRunTime.boxToLong(offset);
                                            objectArray[4] = BoxesRunTime.boxToLong(logSize);
                                            objectArray[5] = BoxesRunTime.boxToLong(lag);
                                            option3 = owner;
                                            if (!(option3 instanceof Some)) break block4;
                                            Some some3 = (Some)option3;
                                            string2 = ownerStr = (String)some3.x();
                                            break block5;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option<String> option4 = option3;
                                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                                        string2 = "none";
                                    }
                                    objectArray[6] = string2;
                                    Predef$.MODULE$.println(stringOps.format(Predef$.MODULE$.genericWrapArray(objectArray)));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block7;
                                }
                                throw new MatchError(option3);
                            }
                            None$ none$ = None$.MODULE$;
                            Option<SimpleConsumer> option5 = option2;
                            if (none$ != null ? !none$.equals(option5) : option5 != null) break block8;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block9;
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option6 = option;
                if (none$ != null ? !none$.equals(option6) : option6 != null) break block10;
                this.error((Function0<String>)((Object)new Serializable(topic, pid){
                    public static final long serialVersionUID = 0L;
                    private final String topic$1;
                    private final int pid$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("No broker for partition %s - %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, BoxesRunTime.boxToInteger(this.pid$1)}));
                    }
                    {
                        this.topic$1 = topic$1;
                        this.pid$1 = pid$1;
                    }
                }));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void kafka$tools$ConsumerOffsetChecker$$processTopic(ZkClient zkClient, String group, String topic) {
        Option option;
        block4: {
            block3: {
                block2: {
                    scala.collection.mutable.Map<String, Seq<Object>> pidMap = ZkUtils$.MODULE$.getPartitionsForTopics(zkClient, (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
                    option = pidMap.get(topic);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Seq pids = (Seq)some.x();
                    ((IterableLike)pids.sorted(Ordering$Int$.MODULE$)).foreach(new Serializable(zkClient, group, topic){
                        public static final long serialVersionUID = 0L;
                        private final ZkClient zkClient$2;
                        private final String group$1;
                        private final String topic$2;

                        public final void apply(int pid) {
                            this.apply$mcVI$sp(pid);
                        }

                        public void apply$mcVI$sp(int pid) {
                            ConsumerOffsetChecker$.MODULE$.kafka$tools$ConsumerOffsetChecker$$processPartition(this.zkClient$2, this.group$1, this.topic$2, pid);
                        }
                        {
                            this.zkClient$2 = zkClient$2;
                            this.group$1 = group$1;
                            this.topic$2 = topic$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    private void printBrokerInfo() {
        Predef$.MODULE$.println("BROKER INFO");
        this.consumerMap().withFilter((Function1<Object, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Option<SimpleConsumer>> check$ifrefutable$1) {
                Tuple2<Object, Option<SimpleConsumer>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        })).foreach(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Option<SimpleConsumer>> x$1) {
                Tuple2<Object, Option<SimpleConsumer>> tuple2;
                block2: {
                    Option<SimpleConsumer> option;
                    block5: {
                        block4: {
                            block3: {
                                tuple2 = x$1;
                                if (tuple2 == null) break block2;
                                int bid = tuple2._1$mcI$sp();
                                Option<SimpleConsumer> consumerOpt = tuple2._2();
                                option = consumerOpt;
                                if (!(option instanceof Some)) break block3;
                                Some some = (Some)option;
                                SimpleConsumer consumer = (SimpleConsumer)some.x();
                                Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%s -> %s:%d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(bid), consumer.host(), BoxesRunTime.boxToInteger(consumer.port())})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<SimpleConsumer> option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(option);
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public void main(String[] args) {
        Option option;
        block9: {
            OptionParser parser = new OptionParser();
            ArgumentAcceptingOptionSpec<String> zkConnectOpt = parser.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo("localhost:2181", (String[])((Object[])new String[0])).ofType(String.class);
            ArgumentAcceptingOptionSpec<String> topicsOpt = parser.accepts("topic", "Comma-separated list of consumer topics (all topics if absent).").withRequiredArg().ofType(String.class);
            ArgumentAcceptingOptionSpec<String> groupOpt = parser.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
            parser.accepts("broker-info", "Print broker info");
            parser.accepts("help", "Print this message.");
            OptionSet options = parser.parse(args);
            if (options.has("help")) {
                parser.printHelpOn(System.out);
                System.exit(0);
            }
            ((List)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{groupOpt}))).foreach(new Serializable(parser, options){
                public static final long serialVersionUID = 0L;
                private final OptionParser parser$1;
                private final OptionSet options$1;

                public final void apply(ArgumentAcceptingOptionSpec<String> opt2) {
                    if (!this.options$1.has(opt2)) {
                        System.err.println(new StringOps(Predef$.MODULE$.augmentString("Missing required argument: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{opt2})));
                        this.parser$1.printHelpOn(System.err);
                        System.exit(1);
                    }
                }
                {
                    this.parser$1 = parser$1;
                    this.options$1 = options$1;
                }
            });
            String zkConnect = options.valueOf(zkConnectOpt);
            String group = options.valueOf(groupOpt);
            Option topics = options.has(topicsOpt) ? new Some<String>(options.valueOf(topicsOpt)) : None$.MODULE$;
            ObjectRef<Object> zkClient = new ObjectRef<Object>(null);
            try {
                List list2;
                zkClient.elem = new ZkClient(zkConnect, 30000, 30000, ZKStringSerializer$.MODULE$);
                option = topics;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String x = (String)some.x();
                    list2 = Predef$.MODULE$.refArrayOps((Object[])x.split(",")).view().toList();
                } else {
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                    list2 = ZkUtils$.MODULE$.getChildren((ZkClient)zkClient.elem, new StringOps(Predef$.MODULE$.augmentString("/consumers/%s/offsets")).format(Predef$.MODULE$.genericWrapArray(new Object[]{group}))).toList();
                }
                List topicList = list2;
                this.debug((Function0<String>)((Object)new Serializable(zkConnect, group, topicList){
                    public static final long serialVersionUID = 0L;
                    private final String zkConnect$1;
                    private final String group$2;
                    private final List topicList$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("zkConnect = %s; topics = %s; group = %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.zkConnect$1, this.topicList$1.toString(), this.group$2}));
                    }
                    {
                        this.zkConnect$1 = zkConnect$1;
                        this.group$2 = group$2;
                        this.topicList$1 = topicList$1;
                    }
                }));
                Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%-15s %-30s %-3s %-15s %-15s %-15s %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{"Group", "Topic", "Pid", "Offset", "logSize", "Lag", "Owner"})));
                ((List)topicList.sorted(Ordering$String$.MODULE$)).foreach(new Serializable(group, zkClient){
                    public static final long serialVersionUID = 0L;
                    private final String group$2;
                    private final ObjectRef zkClient$3;

                    public final void apply(String topic) {
                        ConsumerOffsetChecker$.MODULE$.kafka$tools$ConsumerOffsetChecker$$processTopic((ZkClient)this.zkClient$3.elem, this.group$2, topic);
                    }
                    {
                        this.group$2 = group$2;
                        this.zkClient$3 = zkClient$3;
                    }
                });
                if (options.has("broker-info")) {
                    this.printBrokerInfo();
                }
                this.consumerMap().withFilter((Function1<Object, Object>)((Object)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Option<SimpleConsumer>> check$ifrefutable$2) {
                        Tuple2<Object, Option<SimpleConsumer>> tuple2 = check$ifrefutable$2;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                })).foreach(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<Object, Option<SimpleConsumer>> x$2) {
                        Tuple2<Object, Option<SimpleConsumer>> tuple2;
                        block2: {
                            Option<SimpleConsumer> option;
                            block5: {
                                block4: {
                                    block3: {
                                        tuple2 = x$2;
                                        if (tuple2 == null) break block2;
                                        Option<SimpleConsumer> consumerOpt = tuple2._2();
                                        option = consumerOpt;
                                        if (!(option instanceof Some)) break block3;
                                        Some some = (Some)option;
                                        SimpleConsumer consumer = (SimpleConsumer)some.x();
                                        consumer.close();
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<SimpleConsumer> option2 = option;
                                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(option);
                        }
                        throw new MatchError(tuple2);
                    }
                });
            }
            catch (Throwable throwable) {
                this.consumerMap().values().foreach(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Option<SimpleConsumer> consumerOpt) {
                        Option<SimpleConsumer> option;
                        block4: {
                            block3: {
                                block2: {
                                    option = consumerOpt;
                                    if (!(option instanceof Some)) break block2;
                                    Some some = (Some)option;
                                    SimpleConsumer consumer = (SimpleConsumer)some.x();
                                    consumer.close();
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                None$ none$ = None$.MODULE$;
                                Option<SimpleConsumer> option2 = option;
                                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw new MatchError(option);
                    }
                });
                if ((ZkClient)zkClient.elem != null) {
                    ((ZkClient)zkClient.elem).close();
                }
                throw throwable;
            }
            this.consumerMap().values().foreach(new /* invalid duplicate definition of identical inner class */);
            if ((ZkClient)zkClient.elem != null) {
                ((ZkClient)zkClient.elem).close();
            }
            return;
        }
        throw new MatchError(option);
    }

    private ConsumerOffsetChecker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.consumerMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
    }
}

