/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleaner$CleanerThread$;
import kafka.log.LogCleanerManager;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001\"\u0006\u0001\u0003\u0006\u0004%\tAF\u0001\u0007G>tg-[4\u0016\u0003]\u0001\"\u0001G\r\u000e\u0003\tI!A\u0007\u0002\u0003\u001b\rcW-\u00198fe\u000e{gNZ5h\u0011!a\u0002A!A!\u0002\u00139\u0012aB2p]\u001aLw\r\t\u0005\t=\u0001\u0011)\u0019!C\u0001?\u00059An\\4ESJ\u001cX#\u0001\u0011\u0011\u0007%\t3%\u0003\u0002#\u0015\t)\u0011I\u001d:bsB\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0003S>T\u0011\u0001K\u0001\u0005U\u00064\u0018-\u0003\u0002+K\t!a)\u001b7f\u0011!a\u0003A!A!\u0002\u0013\u0001\u0013\u0001\u00037pO\u0012K'o\u001d\u0011\t\u00119\u0002!Q1A\u0005\u0002=\nA\u0001\\8hgV\t\u0001\u0007\u0005\u0003\u0010cMJ\u0014B\u0001\u001a\u0011\u0005\u0011\u0001vn\u001c7\u0011\u0005Q:T\"A\u001b\u000b\u0005Y\"\u0011AB2p[6|g.\u0003\u00029k\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\u0011\u0005aQ\u0014BA\u001e\u0003\u0005\raun\u001a\u0005\t{\u0001\u0011\t\u0011)A\u0005a\u0005)An\\4tA!Aq\b\u0001B\u0001B\u0003%\u0001)\u0001\u0003uS6,\u0007CA\bB\u0013\t\u0011\u0005C\u0001\u0003US6,\u0007\"\u0002#\u0001\t\u0003)\u0015A\u0002\u001fj]&$h\bF\u0003G\u000f\"K%\n\u0005\u0002\u0019\u0001!)Qc\u0011a\u0001/!)ad\u0011a\u0001A!)af\u0011a\u0001a!9qh\u0011I\u0001\u0002\u0004\u0001\u0005b\u0002'\u0001\u0005\u0004%I!T\u0001\u000fG2,\u0017M\\3s\u001b\u0006t\u0017mZ3s+\u0005q\u0005C\u0001\rP\u0013\t\u0001&AA\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJDaA\u0015\u0001!\u0002\u0013q\u0015aD2mK\u0006tWM]'b]\u0006<WM\u001d\u0011\t\u000fQ\u0003!\u0019!C\u0005+\u0006IA\u000f\u001b:piRdWM]\u000b\u0002-B\u0011qbV\u0005\u00031B\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\ri\u0003\u0001\u0015!\u0003W\u0003)!\bN]8ui2,'\u000f\t\u0005\b9\u0002\u0011\r\u0011\"\u0003^\u0003!\u0019G.Z1oKJ\u001cX#\u00010\u0011\u0007}#g-D\u0001a\u0015\t\t'-A\u0005j[6,H/\u00192mK*\u00111MC\u0001\u000bG>dG.Z2uS>t\u0017BA3a\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0003O\"l\u0011\u0001\u0001\u0004\u0005S\u0002!!NA\u0007DY\u0016\fg.\u001a:UQJ,\u0017\rZ\n\u0003Q.\u0004\"a\u00047\n\u00055\u0004\"AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012D\u0001b\u001c5\u0003\u0002\u0003\u0006I\u0001]\u0001\ti\"\u0014X-\u00193JIB\u0011\u0011\"]\u0005\u0003e*\u00111!\u00138u\u0011\u0015!\u0005\u000e\"\u0001u)\t1W\u000fC\u0003pg\u0002\u0007\u0001\u000fC\u0004xQ\n\u0007I\u0011\t=\u0002\u00151|wmZ3s\u001d\u0006lW-F\u0001z!\tQX0D\u0001|\u0015\tax%\u0001\u0003mC:<\u0017B\u0001@|\u0005\u0019\u0019FO]5oO\"9\u0011\u0011\u00015!\u0002\u0013I\u0018a\u00037pO\u001e,'OT1nK\u0002B\u0011\"!\u0002i\u0005\u0004%\t!a\u0002\u0002\u000f\rdW-\u00198feV\u0011\u0011\u0011\u0002\t\u00041\u0005-\u0011bAA\u0007\u0005\t91\t\\3b]\u0016\u0014\b\u0002CA\tQ\u0002\u0006I!!\u0003\u0002\u0011\rdW-\u00198fe\u0002Bq!!\u0006i\t\u0013\t9\"A\u0005dQ\u0016\u001c7\u000eR8oKR!\u0011\u0011DA\u0010!\rI\u00111D\u0005\u0004\u0003;Q!\u0001B+oSRDq!!\t\u0002\u0014\u0001\u00071'A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:Dq!!\ni\t\u0003\n9#\u0001\u0004e_^{'o\u001b\u000b\u0003\u00033Aq!a\u000bi\t\u0013\t9#\u0001\u0007dY\u0016\fgn\u0014:TY\u0016,\u0007\u000fC\u0004\u00020!$\t!!\r\u0002\u00111|wm\u0015;biN$B\"!\u0007\u00024\u0005]\u0012qIA)\u0003+Bq!!\u000e\u0002.\u0001\u0007\u0001/\u0001\u0002jI\"A\u0011\u0011HA\u0017\u0001\u0004\tY$\u0001\u0003oC6,\u0007\u0003BA\u001f\u0003\u0007r1!CA \u0013\r\t\tEC\u0001\u0007!J,G-\u001a4\n\u0007y\f)EC\u0002\u0002B)A\u0001\"!\u0013\u0002.\u0001\u0007\u00111J\u0001\u0005MJ|W\u000eE\u0002\n\u0003\u001bJ1!a\u0014\u000b\u0005\u0011auN\\4\t\u0011\u0005M\u0013Q\u0006a\u0001\u0003\u0017\n!\u0001^8\t\u0011\u0005]\u0013Q\u0006a\u0001\u00033\nQa\u001d;biN\u00042\u0001GA.\u0013\r\tiF\u0001\u0002\r\u00072,\u0017M\\3s'R\fGo\u001d\u0005\b\u0003C\u0002\u0001\u0015!\u0003_\u0003%\u0019G.Z1oKJ\u001c\b\u0005C\u0004\u0002f\u0001!\t!a\n\u0002\u000fM$\u0018M\u001d;va\"9\u0011\u0011\u000e\u0001\u0005\u0002\u0005\u001d\u0012\u0001C:ikR$wn\u001e8\t\u000f\u00055\u0004\u0001\"\u0001\u0002p\u0005i\u0011MY8si\u000ecW-\u00198j]\u001e$B!!\u0007\u0002r!9\u0011\u0011EA6\u0001\u0004\u0019\u0004bBA;\u0001\u0011\u0005\u0011qO\u0001\u0016C\n|'\u000f^!oIB\u000bWo]3DY\u0016\fg.\u001b8h)\u0011\tI\"!\u001f\t\u000f\u0005\u0005\u00121\u000fa\u0001g!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0014A\u0004:fgVlWm\u00117fC:Lgn\u001a\u000b\u0005\u00033\t\t\tC\u0004\u0002\"\u0005m\u0004\u0019A\u001a\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\u0006a\u0011m^1ji\u000ecW-\u00198fIRQ\u0011\u0011DAE\u0003\u001b\u000b\t*!&\t\u0011\u0005-\u00151\u0011a\u0001\u0003w\tQ\u0001^8qS\u000eDq!a$\u0002\u0004\u0002\u0007\u0001/\u0001\u0003qCJ$\b\u0002CAJ\u0003\u0007\u0003\r!a\u0013\u0002\r=4gm]3u\u0011)\t9*a!\u0011\u0002\u0003\u0007\u00111J\u0001\bi&lWm\\;u\u0011%\tY\nAI\u0001\n\u0003\ti*\u0001\fbo\u0006LGo\u00117fC:,G\r\n3fM\u0006,H\u000e\u001e\u00135+\t\tyJ\u000b\u0003\u0002L\u0005\u00056FAAR!\u0011\t)+a,\u000e\u0005\u0005\u001d&\u0002BAU\u0003W\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055&\"\u0001\u0006b]:|G/\u0019;j_:LA!!-\u0002(\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u0013\u0005U&!!A\t\u0002\u0005]\u0016A\u0003'pO\u000ecW-\u00198feB\u0019\u0001$!/\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003w\u001b2!!/\t\u0011\u001d!\u0015\u0011\u0018C\u0001\u0003\u007f#\"!a.\t\u0015\u0005\r\u0017\u0011XI\u0001\n\u0003\t)-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u000fT3\u0001QAQ\u0001")
public class LogCleaner
implements Logging {
    private final CleanerConfig config;
    private final File[] logDirs;
    private final Pool<TopicAndPartition, Log> logs;
    public final Time kafka$log$LogCleaner$$time;
    private final LogCleanerManager kafka$log$LogCleaner$$cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final IndexedSeq<CleanerThread> cleaners;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$4() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public CleanerConfig config() {
        return this.config;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicAndPartition, Log> logs() {
        return this.logs;
    }

    public LogCleanerManager kafka$log$LogCleaner$$cleanerManager() {
        return this.kafka$log$LogCleaner$$cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    private IndexedSeq<CleanerThread> cleaners() {
        return this.cleaners;
    }

    public void startup() {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting the log cleaner";
            }
        }));
        this.cleaners().foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CleanerThread x$2) {
                x$2.start();
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down the log cleaner.";
            }
        }));
        this.cleaners().foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CleanerThread x$3) {
                x$3.shutdown();
            }
        });
    }

    public void abortCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().abortCleaning(topicAndPartition);
    }

    public void abortAndPauseCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().abortAndPauseCleaning(topicAndPartition);
    }

    public void resumeCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().resumeCleaning(topicAndPartition);
    }

    public void awaitCleaned(String topic, int part, long offset, long timeout) {
        while (!this.kafka$log$LogCleaner$$cleanerManager().allCleanerCheckpoints().contains(new TopicAndPartition(topic, part))) {
            Thread.sleep(10L);
        }
        return;
    }

    public long awaitCleaned$default$4() {
        return 30000L;
    }

    public LogCleaner(CleanerConfig config, File[] logDirs, Pool<TopicAndPartition, Log> logs, Time time) {
        this.config = config;
        this.logDirs = logDirs;
        this.logs = logs;
        this.kafka$log$LogCleaner$$time = time;
        Logging$class.$init$(this);
        this.kafka$log$LogCleaner$$cleanerManager = new LogCleanerManager(logDirs, logs);
        this.kafka$log$LogCleaner$$throttler = new Throttler(config.maxIoBytesPerSecond(), 300L, true, time);
        this.cleaners = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.numThreads()).map(new $anonfun$1(this), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final String loggerName;
        private final Cleaner cleaner;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public void kafka$log$LogCleaner$CleanerThread$$checkDone(TopicAndPartition topicAndPartition) {
            if (this.isRunning().get()) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().checkCleaningAborted(topicAndPartition);
                return;
            }
            throw new ThreadShutdownException();
        }

        @Override
        public void doWork() {
            this.cleanOrSleep();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanOrSleep() {
            BoxedUnit boxedUnit;
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().grabFilthiestLog();
            None$ none$ = None$.MODULE$;
            Option<LogToClean> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time.sleep(this.kafka$log$LogCleaner$CleanerThread$$$outer().config().backOffMs());
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            LogToClean cleanable = (LogToClean)some.x();
            long endOffset = cleanable.firstDirtyOffset();
            try {
                endOffset = this.cleaner().clean(cleanable);
                this.logStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, this.cleaner().stats());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (LogCleaningAbortedException logCleaningAbortedException) {
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }

        public void logStats(int id, String name, long from2, long to2, CleanerStats stats) {
            String message = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id), name, BoxesRunTime.boxToLong(from2), BoxesRunTime.boxToLong(to2)}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble(stats.elapsedSecs()), BoxesRunTime.boxToDouble(this.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble(stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble(this.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble(stats.elapsedSecs() - stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble(this.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong(stats.messagesRead())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong(stats.messagesWritten())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead())), BoxesRunTime.boxToDouble(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead()))}))).toString();
            this.info((Function0<String>)((Object)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            }));
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        private final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw new NullPointerException();
            }
            super(new StringBuilder().append((Object)"kafka-log-cleaner-thread-").append(BoxesRunTime.boxToInteger(threadId)).toString(), false);
            this.loggerName = LogCleaner.class.getName();
            if (LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...";
                    }
                }));
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads(), (long)Integer.MAX_VALUE), LogCleaner.this.config().hashAlgorithm()), LogCleaner.this.config().ioBufferSize() / LogCleaner.this.config().numThreads() / 2, LogCleaner.this.config().maxMessageSize(), LogCleaner.this.config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, new CleanerThread$$anonfun$3(this));
        }
    }
}

