/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.FileMessageSet;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetMap;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ef!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004\bCA\u0010!\u001b\u0005\u0011\u0011BA\u0011\u0003\u0005%yeMZ:fi6\u000b\u0007\u000f\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003\u0018\u00031IwNQ;gM\u0016\u00148+\u001b>f\u0011!)\u0003A!A!\u0002\u00139\u0012aD7bq&{')\u001e4gKJ\u001c\u0016N_3\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\n1\u0003Z;q\u0005V4g-\u001a:M_\u0006$g)Y2u_J\u0004\"\u0001C\u0015\n\u0005)J!A\u0002#pk\ndW\r\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0003%!\bN]8ui2,'\u000f\u0005\u0002\u000f]%\u0011qf\u0004\u0002\n)\"\u0014x\u000e\u001e;mKJD\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAM\u0001\u0005i&lW\r\u0005\u0002\u000fg%\u0011Ag\u0004\u0002\u0005)&lW\r\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0003%\u0019\u0007.Z2l\t>tW\r\u0005\u0003\tqi\u0002\u0015BA\u001d\n\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002<}5\tAH\u0003\u0002>\t\u000511m\\7n_:L!a\u0010\u001f\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\t\u0003&\u0011!)\u0003\u0002\u0005+:LG\u000fC\u0003E\u0001\u0011\u0005Q)\u0001\u0004=S:LGO\u0010\u000b\n\r\u001eC\u0015JS&M\u001b:\u0003\"a\b\u0001\t\u000bQ\u0019\u0005\u0019A\f\t\u000bu\u0019\u0005\u0019\u0001\u0010\t\u000b\r\u001a\u0005\u0019A\f\t\u000b\u0015\u001a\u0005\u0019A\f\t\u000b\u001d\u001a\u0005\u0019\u0001\u0015\t\u000b1\u001a\u0005\u0019A\u0017\t\u000bE\u001a\u0005\u0019\u0001\u001a\t\u000bY\u001a\u0005\u0019A\u001c\t\u000fA\u0003!\u0019!C!#\u0006QAn\\4hKJt\u0015-\\3\u0016\u0003I\u0003\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\t1\fgn\u001a\u0006\u0002/\u0006!!.\u0019<b\u0013\tIFK\u0001\u0004TiJLgn\u001a\u0005\u00077\u0002\u0001\u000b\u0011\u0002*\u0002\u00171|wmZ3s\u001d\u0006lW\r\t\u0005\b;\u0002\u0011\r\u0011\"\u0001_\u0003\u0015\u0019H/\u0019;t+\u0005y\u0006CA\u0010a\u0013\t\t'A\u0001\u0007DY\u0016\fg.\u001a:Ti\u0006$8\u000f\u0003\u0004d\u0001\u0001\u0006IaX\u0001\u0007gR\fGo\u001d\u0011\t\u000f\u0015\u0004\u0001\u0019!C\u0005M\u0006Q!/Z1e\u0005V4g-\u001a:\u0016\u0003\u001d\u0004\"\u0001[6\u000e\u0003%T!A\u001b,\u0002\u00079Lw.\u0003\u0002mS\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000f9\u0004\u0001\u0019!C\u0005_\u0006q!/Z1e\u0005V4g-\u001a:`I\u0015\fHC\u0001!q\u0011\u001d\tX.!AA\u0002\u001d\f1\u0001\u001f\u00132\u0011\u0019\u0019\b\u0001)Q\u0005O\u0006Y!/Z1e\u0005V4g-\u001a:!\u0011\u001d)\b\u00011A\u0005\n\u0019\f1b\u001e:ji\u0016\u0014UO\u001a4fe\"9q\u000f\u0001a\u0001\n\u0013A\u0018aD<sSR,')\u001e4gKJ|F%Z9\u0015\u0005\u0001K\bbB9w\u0003\u0003\u0005\ra\u001a\u0005\u0007w\u0002\u0001\u000b\u0015B4\u0002\u0019]\u0014\u0018\u000e^3Ck\u001a4WM\u001d\u0011\t\ru\u0004A\u0011\u0001\u0002\u007f\u0003\u0015\u0019G.Z1o)\ry\u0018Q\u0001\t\u0004\u0011\u0005\u0005\u0011bAA\u0002\u0013\t!Aj\u001c8h\u0011\u001d\t9\u0001 a\u0001\u0003\u0013\t\u0011b\u00197fC:\f'\r\\3\u0011\u0007}\tY!C\u0002\u0002\u000e\t\u0011!\u0002T8h)>\u001cE.Z1o\u0011!\t\t\u0002\u0001C\u0001\u0005\u0005M\u0011!D2mK\u0006t7+Z4nK:$8\u000fF\u0005A\u0003+\ti\"a\r\u00028!91!a\u0004A\u0002\u0005]\u0001cA\u0010\u0002\u001a%\u0019\u00111\u0004\u0002\u0003\u00071{w\r\u0003\u0005\u0002 \u0005=\u0001\u0019AA\u0011\u0003!\u0019XmZ7f]R\u001c\bCBA\u0012\u0003S\ti#\u0004\u0002\u0002&)\u0019\u0011qE\u0005\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002,\u0005\u0015\"aA*fcB\u0019q$a\f\n\u0007\u0005E\"A\u0001\u0006M_\u001e\u001cVmZ7f]RDq!!\u000e\u0002\u0010\u0001\u0007a$A\u0002nCBDq!!\u000f\u0002\u0010\u0001\u0007q0A\beK2,G/\u001a%pe&TxN\\'t\u0011!\ti\u0004\u0001C\u0001\u0005\u0005}\u0012!C2mK\u0006t\u0017J\u001c;p)-\u0001\u0015\u0011IA#\u0003\u0013\ni%a\u0014\t\u000f\u0005\r\u00131\ba\u0001u\u0005\tBo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\u0005\u001d\u00131\ba\u0001\u0003[\taa]8ve\u000e,\u0007\u0002CA&\u0003w\u0001\r!!\f\u0002\t\u0011,7\u000f\u001e\u0005\b\u0003k\tY\u00041\u0001\u001f\u0011!\t\t&a\u000fA\u0002\u0005M\u0013!\u0004:fi\u0006Lg\u000eR3mKR,7\u000fE\u0002\t\u0003+J1!a\u0016\n\u0005\u001d\u0011un\u001c7fC:Dq!a\u0017\u0001\t\u0003\ti&A\u0006he><()\u001e4gKJ\u001cH#\u0001!\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002^\u0005q!/Z:u_J,')\u001e4gKJ\u001c\b\u0002CA3\u0001\u0011\u0005!!a\u001a\u0002'\u001d\u0014x.\u001e9TK\u001elWM\u001c;t\u0005f\u001c\u0016N_3\u0015\u0011\u0005%\u0014\u0011QAE\u0003\u001b\u0003b!a\u001b\u0002|\u0005\u0005b\u0002BA7\u0003orA!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0004\u0003g*\u0012A\u0002\u001fs_>$h(C\u0001\u000b\u0013\r\tI(C\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti(a \u0003\t1K7\u000f\u001e\u0006\u0004\u0003sJ\u0001\u0002CA\u0010\u0003G\u0002\r!a!\u0011\r\u0005\r\u0012QQA\u0017\u0013\u0011\t9)!\n\u0003\u0011%#XM]1cY\u0016Dq!a#\u0002d\u0001\u0007q#A\u0004nCb\u001c\u0016N_3\t\u000f\u0005=\u00151\ra\u0001/\u0005aQ.\u0019=J]\u0012,\u0007pU5{K\"A\u00111\u0013\u0001\u0005\u0002\t\t)*\u0001\bck&dGm\u00144gg\u0016$X*\u00199\u0015\u0013}\f9*!'\u0002\u001e\u0006\u0005\u0006bB\u0002\u0002\u0012\u0002\u0007\u0011q\u0003\u0005\b\u00037\u000b\t\n1\u0001\u0000\u0003\u0015\u0019H/\u0019:u\u0011\u001d\ty*!%A\u0002}\f1!\u001a8e\u0011\u001d\t)$!%A\u0002yAq!!*\u0001\t\u0013\t9+\u0001\rck&dGm\u00144gg\u0016$X*\u00199G_J\u001cVmZ7f]R$ra`AU\u0003W\u000by\u000bC\u0004\u0002D\u0005\r\u0006\u0019\u0001\u001e\t\u0011\u00055\u00161\u0015a\u0001\u0003[\tqa]3h[\u0016tG\u000fC\u0004\u00026\u0005\r\u0006\u0019\u0001\u0010")
public class Cleaner
implements Logging {
    private final int id;
    public final OffsetMap kafka$log$Cleaner$$offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    public final double kafka$log$Cleaner$$dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    public final Function1<TopicAndPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private final String loggerName;
    private final CleanerStats stats;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer kafka$log$Cleaner$$writeBuffer;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public CleanerStats stats() {
        return this.stats;
    }

    public ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$readBuffer = x$1;
    }

    public ByteBuffer kafka$log$Cleaner$$writeBuffer() {
        return this.kafka$log$Cleaner$$writeBuffer;
    }

    private void kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$writeBuffer = x$1;
    }

    public long clean(LogToClean cleanable) {
        Option option;
        block4: {
            long l;
            long endOffset;
            Log log2;
            block3: {
                block2: {
                    this.stats().clear();
                    this.info((Function0<String>)((Object)new Serializable(this, cleanable){
                        public static final long serialVersionUID = 0L;
                        private final LogToClean cleanable$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = cleanable$1;
                        }
                    }));
                    log2 = cleanable.log();
                    this.info((Function0<String>)((Object)new Serializable(this, cleanable){
                        public static final long serialVersionUID = 0L;
                        private final LogToClean cleanable$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = cleanable$1;
                        }
                    }));
                    long upperBoundOffset = log2.activeSegment().baseOffset();
                    endOffset = this.buildOffsetMap(log2, cleanable.firstDirtyOffset(), upperBoundOffset, this.kafka$log$Cleaner$$offsetMap) + 1L;
                    this.stats().indexDone();
                    option = log2.logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogSegment seg = (LogSegment)some.x();
                l = seg.lastModified() - log2.config().deleteRetentionMs();
            }
            long deleteHorizonMs = l;
            this.info((Function0<String>)((Object)new Serializable(this, log2, deleteHorizonMs){
                public static final long serialVersionUID = 0L;
                private final Log log$1;
                private final long deleteHorizonMs$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (discarding tombstones prior to %s)...")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$1.name(), new Date(this.deleteHorizonMs$1)}));
                }
                {
                    this.log$1 = log$1;
                    this.deleteHorizonMs$1 = deleteHorizonMs$1;
                }
            }));
            this.groupSegmentsBySize(log2.logSegments(0L, endOffset), log2.config().segmentSize(), log2.config().maxIndexSize()).foreach(new Serializable(this, log2, deleteHorizonMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                private final Log log$1;
                private final long deleteHorizonMs$1;

                public final void apply(Seq<LogSegment> group) {
                    this.$outer.cleanSegments(this.log$1, group, this.$outer.kafka$log$Cleaner$$offsetMap, this.deleteHorizonMs$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.log$1 = log$1;
                    this.deleteHorizonMs$1 = deleteHorizonMs$1;
                }
            });
            this.stats().allDone();
            return endOffset;
        }
        throw new MatchError(option);
    }

    public void cleanSegments(Log log2, Seq<LogSegment> segments, OffsetMap map2, long deleteHorizonMs) {
        File logFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).log().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        logFile.delete();
        File indexFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).index().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        indexFile.delete();
        FileMessageSet messages = new FileMessageSet(logFile);
        OffsetIndex index2 = new OffsetIndex(indexFile, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).index().maxIndexSize());
        LogSegment cleaned = new LogSegment(messages, index2, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).indexIntervalBytes(), this.time);
        try {
            segments.foreach(new Serializable(this, log2, map2, deleteHorizonMs, cleaned){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                public final Log log$3;
                private final OffsetMap map$2;
                private final long deleteHorizonMs$2;
                public final LogSegment cleaned$1;

                public final void apply(LogSegment old) {
                    boolean retainDeletes = old.lastModified() > this.deleteHorizonMs$2;
                    this.$outer.info((Function0<String>)((Object)new Serializable(this, old, retainDeletes){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$cleanSegments$1 $outer;
                        private final LogSegment old$1;
                        private final boolean retainDeletes$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Cleaning segment %s in log %s (last modified %s) into %s, %s deletes.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.old$1.baseOffset()), this.$outer.log$3.name(), new Date(this.old$1.lastModified()), BoxesRunTime.boxToLong(this.$outer.cleaned$1.baseOffset()), this.retainDeletes$1 ? "retaining" : "discarding"}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.old$1 = old$1;
                            this.retainDeletes$1 = retainDeletes$1;
                        }
                    }));
                    this.$outer.cleanInto(this.log$3.topicAndPartition(), old, this.cleaned$1, this.map$2, retainDeletes);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.log$3 = log$3;
                    this.map$2 = map$2;
                    this.deleteHorizonMs$2 = deleteHorizonMs$2;
                    this.cleaned$1 = cleaned$1;
                }
            });
            index2.trimToValidSize();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)((Object)new Serializable(this, log2, segments, cleaned){
                public static final long serialVersionUID = 0L;
                private final Log log$3;
                private final Seq segments$1;
                private final LogSegment cleaned$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Swapping in cleaned segment %d for segment(s) %s in log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.cleaned$1.baseOffset()), ((TraversableOnce)this.segments$1.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(LogSegment x$4) {
                            return x$4.baseOffset();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(","), this.log$3.name()}));
                }
                {
                    this.log$3 = log$3;
                    this.segments$1 = segments$1;
                    this.cleaned$1 = cleaned$1;
                }
            }));
            log2.replaceSegments(cleaned, segments);
            return;
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            cleaned.delete();
            throw logCleaningAbortedException;
        }
    }

    public void cleanInto(TopicAndPartition topicAndPartition, LogSegment source, LogSegment dest, OffsetMap map2, boolean retainDeletes) {
        IntRef position = new IntRef(0);
        while (position.elem < source.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply(topicAndPartition);
            ((Buffer)this.kafka$log$Cleaner$$readBuffer()).clear();
            ((Buffer)this.kafka$log$Cleaner$$writeBuffer()).clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(source.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position.elem));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            IntRef messagesRead = new IntRef(0);
            messages.foreach(new Serializable(this, source, map2, retainDeletes, position, messagesRead){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                public final LogSegment source$1;
                private final OffsetMap map$3;
                private final boolean retainDeletes$2;
                private final IntRef position$1;
                private final IntRef messagesRead$1;

                public final void apply(MessageAndOffset entry2) {
                    boolean obsoleteDelete;
                    ++this.messagesRead$1.elem;
                    int size2 = MessageSet$.MODULE$.entrySize(entry2.message());
                    this.position$1.elem += size2;
                    this.$outer.stats().readMessage(size2);
                    ByteBuffer key = entry2.message().key();
                    Predef$.MODULE$.require(key != null, (Function0<Object>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$cleanInto$1 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Found null key in log segment %s which is marked as dedupe.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.source$1.log().file().getAbsolutePath()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                    long foundOffset = this.map$3.get(key);
                    boolean redundant = foundOffset >= 0L && entry2.offset() < foundOffset;
                    boolean bl = obsoleteDelete = !this.retainDeletes$2 && entry2.message().isNull();
                    if (!redundant && !obsoleteDelete) {
                        ByteBufferMessageSet$.MODULE$.writeMessage(this.$outer.kafka$log$Cleaner$$writeBuffer(), entry2.message(), entry2.offset());
                        this.$outer.stats().recopyMessage(size2);
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.source$1 = source$1;
                    this.map$3 = map$3;
                    this.retainDeletes$2 = retainDeletes$2;
                    this.position$1 = position$1;
                    this.messagesRead$1 = messagesRead$1;
                }
            });
            if (this.kafka$log$Cleaner$$writeBuffer().position() > 0) {
                ((Buffer)this.kafka$log$Cleaner$$writeBuffer()).flip();
                ByteBufferMessageSet retained = new ByteBufferMessageSet(this.kafka$log$Cleaner$$writeBuffer());
                dest.append(((MessageAndOffset)retained.head()).offset(), retained);
                this.throttler.maybeThrottle(this.kafka$log$Cleaner$$writeBuffer().limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || messagesRead.elem != 0) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
    }

    public void growBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= this.maxIoBufferSize || this.kafka$log$Cleaner$$writeBuffer().capacity() >= this.maxIoBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.maxIoBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, this.maxIoBufferSize);
        this.info((Function0<String>)((Object)new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final int newSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Growing cleaner I/O buffers from ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$Cleaner$$readBuffer().capacity())).append((Object)"bytes to ").append(BoxesRunTime.boxToInteger(this.newSize$1)).append((Object)" bytes.").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        }));
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.kafka$log$Cleaner$$writeBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize) {
        Nil$ grouped2 = Nil$.MODULE$;
        List segs = segments.toList();
        while (!segs.isEmpty()) {
            List<Object> list2;
            List list3;
            List<LogSegment> group = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)list3.head()}));
            long logSize = ((LogSegment)list3.head()).size();
            int indexSize = ((LogSegment)list3.head()).index().sizeInBytes();
            list3 = (List)list3.tail();
            while (!list3.isEmpty() && logSize + ((LogSegment)list3.head()).size() < (long)maxSize && indexSize + ((LogSegment)list3.head()).index().sizeInBytes() < maxIndexSize) {
                LogSegment logSegment = (LogSegment)list3.head();
                group = group.$colon$colon(logSegment);
                logSize += ((LogSegment)list3.head()).size();
                indexSize += ((LogSegment)list3.head()).index().sizeInBytes();
                list3 = (List)list3.tail();
            }
            list2 = list2.$colon$colon(group.reverse());
        }
        return grouped2.reverse();
    }

    public long buildOffsetMap(Log log2, long start, long end, OffsetMap map2) {
        map2.clear();
        Seq<LogSegment> dirty = log2.logSegments(start, end).toSeq();
        this.info((Function0<String>)((Object)new Serializable(this, log2, start, end, dirty){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long start$1;
            private final long end$1;
            private final Seq dirty$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$2.name(), BoxesRunTime.boxToInteger(this.dirty$1.size()), BoxesRunTime.boxToLong(this.start$1), BoxesRunTime.boxToLong(this.end$1)}));
            }
            {
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.end$1 = end$1;
                this.dirty$1 = dirty$1;
            }
        }));
        LongRef offset = new LongRef(((LogSegment)dirty.head()).baseOffset());
        Predef$.MODULE$.require(offset.elem == start, (Function0<Object>)((Object)new Serializable(this, log2, start, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long start$1;
            private final LongRef offset$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Last clean offset is %d but segment base offset is %d for log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.start$1), BoxesRunTime.boxToLong(this.offset$1.elem), this.log$2.name()}));
            }
            {
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.offset$1 = offset$1;
            }
        }));
        long minStopOffset = (long)((double)start + (double)map2.slots() * this.kafka$log$Cleaner$$dupBufferLoadFactor);
        dirty.foreach(new Serializable(this, log2, map2, offset, minStopOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final Log log$2;
            private final OffsetMap map$1;
            private final LongRef offset$1;
            private final long minStopOffset$1;

            public final void apply(LogSegment segment) {
                this.$outer.kafka$log$Cleaner$$checkDone.apply(this.log$2.topicAndPartition());
                if (segment.baseOffset() <= this.minStopOffset$1 || this.map$1.utilization() < this.$outer.kafka$log$Cleaner$$dupBufferLoadFactor) {
                    this.offset$1.elem = this.$outer.kafka$log$Cleaner$$buildOffsetMapForSegment(this.log$2.topicAndPartition(), segment, this.map$1);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.map$1 = map$1;
                this.offset$1 = offset$1;
                this.minStopOffset$1 = minStopOffset$1;
            }
        });
        this.info((Function0<String>)((Object)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final Log log$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$2.name()}));
            }
            {
                this.log$2 = log$2;
            }
        }));
        return offset.elem;
    }

    public long kafka$log$Cleaner$$buildOffsetMapForSegment(TopicAndPartition topicAndPartition, LogSegment segment, OffsetMap map2) {
        IntRef position = new IntRef(0);
        LongRef offset = new LongRef(segment.baseOffset());
        while (position.elem < segment.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply(topicAndPartition);
            ((Buffer)this.kafka$log$Cleaner$$readBuffer()).clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position.elem));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            int startPosition = position.elem;
            messages.foreach(new Serializable(this, map2, position, offset){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                private final OffsetMap map$4;
                private final IntRef position$2;
                private final LongRef offset$2;

                public final void apply(MessageAndOffset entry2) {
                    Message message = entry2.message();
                    Predef$.MODULE$.require(message.hasKey());
                    int size2 = MessageSet$.MODULE$.entrySize(message);
                    this.position$2.elem += size2;
                    this.map$4.put(message.key(), entry2.offset());
                    this.offset$2.elem = entry2.offset();
                    this.$outer.stats().indexMessage(size2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.map$4 = map$4;
                    this.position$2 = position$2;
                    this.offset$2 = offset$2;
                }
            });
            if (position.elem != startPosition) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
        return offset.elem;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicAndPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.kafka$log$Cleaner$$offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.kafka$log$Cleaner$$dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq(new StringBuilder().append((Object)"Cleaner ").append(BoxesRunTime.boxToInteger(id)).append((Object)": ").toString());
        this.stats = new CleanerStats(time);
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.kafka$log$Cleaner$$writeBuffer = ByteBuffer.allocate(ioBufferSize);
    }
}

