/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.uis.persistent.dao;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.DataProvider;
import eu.europeana.cloud.common.model.DataProviderProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class CassandraDataProviderDAO {
    private CassandraConnectionProvider dbService;
    private PreparedStatement createDataProviderStatement;
    private PreparedStatement updateDataProviderStatement;
    private PreparedStatement getProviderStatement;
    private PreparedStatement deleteProviderStatement;
    private PreparedStatement getAllProvidersStatement;
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraDataProviderDAO.class);

    public CassandraDataProviderDAO(CassandraConnectionProvider dbService) {
        this.dbService = dbService;
        this.prepareStatements();
    }

    private void prepareStatements() {
        this.createDataProviderStatement = this.dbService.getSession().prepare("INSERT INTO data_providers(provider_id, active, properties, creation_date, partition_key) VALUES (?,true,?,?,?);");
        this.createDataProviderStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.updateDataProviderStatement = this.dbService.getSession().prepare("UPDATE data_providers SET active=?, properties=? where provider_id = ?;");
        this.updateDataProviderStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.getProviderStatement = this.dbService.getSession().prepare("SELECT provider_id, partition_key, active, properties FROM data_providers WHERE provider_id = ?;");
        this.getProviderStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.deleteProviderStatement = this.dbService.getSession().prepare("DELETE FROM data_providers WHERE provider_id = ?;");
        this.deleteProviderStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.getAllProvidersStatement = this.dbService.getSession().prepare("SELECT provider_id, active, partition_key, properties FROM data_providers WHERE token(provider_id) >= token(?) LIMIT ?;");
        this.getAllProvidersStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    public List<DataProvider> getProviders(String thresholdProviderId, int limit) throws NoHostAvailableException, QueryExecutionException {
        String provId = thresholdProviderId;
        if (provId == null) {
            provId = "";
        }
        BoundStatement boundStatement = this.getAllProvidersStatement.bind(provId, limit);
        ResultSet rs = this.dbService.getSession().execute(boundStatement);
        ArrayList<DataProvider> dataProviders = new ArrayList<DataProvider>();
        for (Row row : rs) {
            dataProviders.add(this.map(row));
        }
        return dataProviders;
    }

    public DataProvider getProvider(String providerId) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.getProviderStatement.bind(providerId);
        ResultSet rs = this.dbService.getSession().execute(boundStatement);
        Row result2 = rs.one();
        if (result2 == null) {
            return null;
        }
        return this.map(result2);
    }

    public void deleteProvider(String providerId) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.deleteProviderStatement.bind(providerId);
        this.dbService.getSession().execute(boundStatement);
    }

    public DataProvider createDataProvider(String providerId, DataProviderProperties properties) throws NoHostAvailableException, QueryExecutionException {
        int partitionKey = providerId.hashCode();
        BoundStatement boundStatement = this.createDataProviderStatement.bind(providerId, this.propertiesToMap(properties), new Date(), partitionKey);
        this.dbService.getSession().execute(boundStatement);
        DataProvider dp = new DataProvider();
        dp.setId(providerId);
        dp.setPartitionKey(partitionKey);
        dp.setProperties(properties);
        return dp;
    }

    public DataProvider updateDataProvider(DataProvider dataProvider) throws NoHostAvailableException, QueryExecutionException {
        BoundStatement boundStatement = this.updateDataProviderStatement.bind(dataProvider.isActive(), this.propertiesToMap(dataProvider.getProperties()), dataProvider.getId());
        this.dbService.getSession().execute(boundStatement);
        return dataProvider;
    }

    private DataProvider map(Row row) {
        DataProvider provider = new DataProvider();
        String providerId = row.getString("provider_id");
        int partitionKey = row.getInt("partition_key");
        Map<String, String> propertiesMap = row.getMap("properties", String.class, String.class);
        DataProviderProperties properties = this.mapToProperties(propertiesMap);
        provider.setId(providerId);
        provider.setPartitionKey(partitionKey);
        provider.setProperties(properties);
        provider.setActive(row.getBool("active"));
        return provider;
    }

    private Map<String, String> propertiesToMap(DataProviderProperties properties) {
        Method[] methods;
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (Method m : methods = DataProviderProperties.class.getDeclaredMethods()) {
            if (!m.getName().startsWith("get")) continue;
            try {
                Object value2 = m.invoke((Object)properties, new Object[0]);
                if (value2 == null) continue;
                map2.put(m.getName().substring(3), value2.toString());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
        return map2;
    }

    private DataProviderProperties mapToProperties(Map<String, String> map2) {
        Method[] methods;
        DataProviderProperties properties = new DataProviderProperties();
        for (Method m : methods = DataProviderProperties.class.getDeclaredMethods()) {
            String propName;
            String propValue;
            if (!m.getName().startsWith("set") || (propValue = map2.get(propName = m.getName().substring(3))) == null) continue;
            try {
                m.invoke((Object)properties, propValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
        return properties;
    }
}

