/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.urls;

import eu.europeana.cloud.service.commons.urls.UrlBuilderException;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import eu.europeana.cloud.service.commons.urls.ValuedUrlPart;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UrlBuilder {
    private Map<UrlPart, String> parts;
    private Set<ValuedUrlPart> partsToInclude = new HashSet<ValuedUrlPart>();

    UrlBuilder(Map<UrlPart, String> parts) {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.CONTEXT, true));
        this.parts = parts;
    }

    public UrlBuilder clear() {
        this.partsToInclude = new HashSet<ValuedUrlPart>();
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.CONTEXT, true));
        return this;
    }

    public UrlBuilder withCloudID() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.RECORDS, true));
        return this;
    }

    public UrlBuilder withRepresentation() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.REPRESENTATIONS, true));
        return this;
    }

    public UrlBuilder withVersion() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.VERSIONS, true));
        return this;
    }

    public UrlBuilder withVersionWithoutValue() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.VERSIONS, false));
        return this;
    }

    public UrlBuilder withDataProvider() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.DATA_PROVIDERS, true));
        return this;
    }

    public UrlBuilder withDataSet() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.DATA_SETS, true));
        return this;
    }

    public UrlBuilder withDataSetWithoutValue() {
        this.partsToInclude.add(new ValuedUrlPart(UrlPart.DATA_SETS, false));
        return this;
    }

    public String build() throws UrlBuilderException {
        String result2 = "";
        for (Map.Entry<UrlPart, String> entry2 : this.parts.entrySet()) {
            ValuedUrlPart key = new ValuedUrlPart(entry2.getKey(), true);
            String value2 = entry2.getValue();
            if (!this.shouldBeIncludedInResult(entry2.getKey())) continue;
            ValuedUrlPart currentPart = this.removeFromPartsToInclude(entry2.getKey());
            if (currentPart.isAddValue()) {
                if (value2 != null) {
                    if ("".equals(key.getPart().getValue())) {
                        result2 = result2 + "/" + value2;
                        continue;
                    }
                    result2 = result2 + "/" + key.getPart().getValue() + "/" + value2;
                    continue;
                }
                throw new UrlBuilderException("Value for: " + key + " is empty");
            }
            result2 = result2 + "/" + key.getPart().getValue();
        }
        if (this.partsToInclude.size() > 0) {
            String errorMessage = this.createErrorMessage(this.partsToInclude);
            throw new UrlBuilderException("Missing parts for given request: " + errorMessage);
        }
        return result2;
    }

    private boolean shouldBeIncludedInResult(UrlPart urlPart) {
        Iterator<ValuedUrlPart> it = this.partsToInclude.iterator();
        while (it.hasNext()) {
            if (!it.next().getPart().equals((Object)urlPart)) continue;
            return true;
        }
        return false;
    }

    private ValuedUrlPart removeFromPartsToInclude(UrlPart urlPart) throws UrlBuilderException {
        Iterator<ValuedUrlPart> it = this.partsToInclude.iterator();
        while (it.hasNext()) {
            ValuedUrlPart currentPart = it.next();
            if (!currentPart.getPart().equals((Object)urlPart)) continue;
            it.remove();
            return currentPart;
        }
        throw new UrlBuilderException("The provided parts are not sufficient to build the correct URL");
    }

    private String createErrorMessage(Set<ValuedUrlPart> leftParts) {
        String result2 = "";
        for (ValuedUrlPart leftPart : leftParts) {
            result2 = result2 + (Object)((Object)leftPart.getPart()) + " ";
        }
        return result2;
    }
}

