/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.servlet;

import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class RedirFilter
implements Filter {
    private final String EXAMPLE = "  <filter>\n        <filter-name>RedirFilter</filter-name>\n        <filter-class>com.eaio.servlet.RedirFilter</filter-class>\n        <init-param>\n            <param-name>allowedURIs</param-name>\n            <param-value>^/upload.*$</param-value>\n        </init-param>\n        <init-param>\n            <param-name>hostname</param-name>\n            <param-value>foo.com</param-value>\n        </init-param>\n    </filter>";
    private final String ALLOWED_URIS = "Please define an \"allowedURIs\" init-parameter in your web.xml, like this:\n\n  <filter>\n        <filter-name>RedirFilter</filter-name>\n        <filter-class>com.eaio.servlet.RedirFilter</filter-class>\n        <init-param>\n            <param-name>allowedURIs</param-name>\n            <param-value>^/upload.*$</param-value>\n        </init-param>\n        <init-param>\n            <param-name>hostname</param-name>\n            <param-value>foo.com</param-value>\n        </init-param>\n    </filter>\n\nFor now, a default value that allows all requests will be used.";
    private final String HOSTNAME = "Please define an \"hostname\" init-parameter in your web.xml, like this:\n\n  <filter>\n        <filter-name>RedirFilter</filter-name>\n        <filter-class>com.eaio.servlet.RedirFilter</filter-class>\n        <init-param>\n            <param-name>allowedURIs</param-name>\n            <param-value>^/upload.*$</param-value>\n        </init-param>\n        <init-param>\n            <param-name>hostname</param-name>\n            <param-value>foo.com</param-value>\n        </init-param>\n    </filter>\n\nFor now, a default value that allows all requests will be used.";
    private Pattern allowedURIs;
    private String hostnamePlusPort;

    public void init(FilterConfig config) {
        String hostname;
        String uriPattern = config.getInitParameter("allowedURIs");
        if (uriPattern == null) {
            config.getServletContext().log("Please define an \"allowedURIs\" init-parameter in your web.xml, like this:\n\n  <filter>\n        <filter-name>RedirFilter</filter-name>\n        <filter-class>com.eaio.servlet.RedirFilter</filter-class>\n        <init-param>\n            <param-name>allowedURIs</param-name>\n            <param-value>^/upload.*$</param-value>\n        </init-param>\n        <init-param>\n            <param-name>hostname</param-name>\n            <param-value>foo.com</param-value>\n        </init-param>\n    </filter>\n\nFor now, a default value that allows all requests will be used.");
            uriPattern = "^/";
        }
        if ((hostname = config.getInitParameter("hostname")) == null) {
            config.getServletContext().log("Please define an \"hostname\" init-parameter in your web.xml, like this:\n\n  <filter>\n        <filter-name>RedirFilter</filter-name>\n        <filter-class>com.eaio.servlet.RedirFilter</filter-class>\n        <init-param>\n            <param-name>allowedURIs</param-name>\n            <param-value>^/upload.*$</param-value>\n        </init-param>\n        <init-param>\n            <param-name>hostname</param-name>\n            <param-value>foo.com</param-value>\n        </init-param>\n    </filter>\n\nFor now, a default value that allows all requests will be used.");
            hostname = "guh";
        }
        this.init(uriPattern, hostname);
    }

    public void init(String uriPattern, String hostname) {
        assert (uriPattern != null);
        assert (hostname != null);
        this.allowedURIs = Pattern.compile(uriPattern);
        this.hostnamePlusPort = String.valueOf(hostname) + ":";
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain2) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String host = StringUtils.defaultString((String)request.getHeader("HOST"));
        String uri = StringUtils.defaultString((String)StringUtils.substringAfter((String)request.getRequestURI(), (String)request.getContextPath()));
        String query = request.getQueryString();
        if (host.startsWith(this.hostnamePlusPort) && !this.allowedURIs.matcher(uri).matches()) {
            URL hostURL = new URL("http://" + host);
            URL u = new URL("http", hostURL.getHost(), query == null ? uri : new StringBuilder(uri.length() + 1 + query.length()).append(uri).append('?').append(query).toString());
            response.sendRedirect(u.toString());
        } else {
            chain2.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

