/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import ch.qos.cal10n.BaseName;
import ch.qos.cal10n.Locale;
import ch.qos.cal10n.LocaleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationExtractor {
    public static <E extends Enum<?>> String getBaseName(Class<E> enumClass) {
        BaseName rbnAnnotation = enumClass.getAnnotation(BaseName.class);
        if (rbnAnnotation == null) {
            return null;
        }
        return rbnAnnotation.value();
    }

    public static <E extends Enum<?>> String[] getLocaleNames(Class<E> enumClass) {
        Locale[] localeDataArray = AnnotationExtractor.getLocaleData(enumClass);
        if (localeDataArray == null) {
            return null;
        }
        String[] names = new String[localeDataArray.length];
        for (int i = 0; i < localeDataArray.length; ++i) {
            names[i] = localeDataArray[i].value();
        }
        return names;
    }

    public static <E extends Enum<?>> Locale[] getLocaleData(Class<E> enumClass) {
        LocaleData localeDataArrayAnnotation = enumClass.getAnnotation(LocaleData.class);
        if (localeDataArrayAnnotation == null) {
            return null;
        }
        return localeDataArrayAnnotation.value();
    }

    public static String getCharset(Class<?> enumClass, java.util.Locale juLocale) {
        LocaleData localeDataArrayAnnotation = enumClass.getAnnotation(LocaleData.class);
        if (localeDataArrayAnnotation == null) {
            return "";
        }
        String defaultCharset = localeDataArrayAnnotation.defaultCharset();
        Locale la = AnnotationExtractor.findLocaleAnnotation(juLocale, localeDataArrayAnnotation);
        String localeCharset = null;
        if (la != null) {
            localeCharset = la.charset();
        }
        if (!AnnotationExtractor.isEmttyString(localeCharset)) {
            return localeCharset;
        }
        return defaultCharset;
    }

    static Locale findLocaleAnnotation(java.util.Locale julocale, LocaleData localeDataArrayAnnotation) {
        Locale[] localeAnnotationArray = localeDataArrayAnnotation.value();
        if (localeAnnotationArray == null) {
            return null;
        }
        for (Locale la : localeAnnotationArray) {
            if (!la.value().equals(julocale.toString())) continue;
            return la;
        }
        return null;
    }

    static boolean isEmttyString(String s2) {
        return s2 == null || s2.length() == 0;
    }
}

