/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import javax.servlet.ServletContext;
import org.springframework.util.PropertyPlaceholderHelper;

public abstract class ServletContextPropertyUtils {
    private static final PropertyPlaceholderHelper strictHelper = new PropertyPlaceholderHelper("${", "}", ":", false);
    private static final PropertyPlaceholderHelper nonStrictHelper = new PropertyPlaceholderHelper("${", "}", ":", true);

    public static String resolvePlaceholders(String text2, ServletContext servletContext) {
        return ServletContextPropertyUtils.resolvePlaceholders(text2, servletContext, false);
    }

    public static String resolvePlaceholders(String text2, ServletContext servletContext, boolean ignoreUnresolvablePlaceholders) {
        PropertyPlaceholderHelper helper = ignoreUnresolvablePlaceholders ? nonStrictHelper : strictHelper;
        return helper.replacePlaceholders(text2, new ServletContextPlaceholderResolver(text2, servletContext));
    }

    private static class ServletContextPlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final String text;
        private final ServletContext servletContext;

        public ServletContextPlaceholderResolver(String text2, ServletContext servletContext) {
            this.text = text2;
            this.servletContext = servletContext;
        }

        public String resolvePlaceholder(String placeholderName) {
            try {
                String propVal = this.servletContext.getInitParameter(placeholderName);
                if (propVal == null && (propVal = System.getProperty(placeholderName)) == null) {
                    propVal = System.getenv(placeholderName);
                }
                return propVal;
            }
            catch (Throwable ex) {
                System.err.println("Could not resolve placeholder '" + placeholderName + "' in [" + this.text + "] as ServletContext init-parameter or system property: " + ex);
                return null;
            }
        }
    }
}

