/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.savedrequest;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class FastHttpDateFormat {
    protected static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    protected static long currentDateGenerated;
    protected static String currentDate;
    protected static final HashMap<Long, String> formatCache;
    protected static final HashMap<String, Long> parseCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(long value2, DateFormat threadLocalformat) {
        String newDate;
        String cachedDate = null;
        Long longValue = value2;
        try {
            cachedDate = formatCache.get(longValue);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (cachedDate != null) {
            return cachedDate;
        }
        Date dateValue = new Date(value2);
        if (threadLocalformat != null) {
            newDate = threadLocalformat.format(dateValue);
            HashMap<Long, String> hashMap = formatCache;
            synchronized (hashMap) {
                FastHttpDateFormat.updateCache(formatCache, longValue, newDate);
            }
        }
        HashMap<Long, String> hashMap = formatCache;
        synchronized (hashMap) {
            newDate = format.format(dateValue);
            FastHttpDateFormat.updateCache(formatCache, longValue, newDate);
        }
        return newDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentDate() {
        long now = System.currentTimeMillis();
        if (now - currentDateGenerated > 1000L) {
            SimpleDateFormat simpleDateFormat = format;
            synchronized (simpleDateFormat) {
                if (now - currentDateGenerated > 1000L) {
                    currentDateGenerated = now;
                    currentDate = format.format(new Date(now));
                }
            }
        }
        return currentDate;
    }

    private static Long internalParseDate(String value2, DateFormat[] formats) {
        Date date = null;
        for (int i = 0; date == null && i < formats.length; ++i) {
            try {
                date = formats[i].parse(value2);
                continue;
            }
            catch (ParseException ignored) {
                // empty catch block
            }
        }
        if (date == null) {
            return null;
        }
        return new Long(date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseDate(String value2, DateFormat[] threadLocalformats) {
        Long date;
        Long cachedDate = null;
        try {
            cachedDate = parseCache.get(value2);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (cachedDate != null) {
            return cachedDate;
        }
        if (threadLocalformats != null) {
            date = FastHttpDateFormat.internalParseDate(value2, threadLocalformats);
            HashMap<String, Long> hashMap = parseCache;
            synchronized (hashMap) {
                FastHttpDateFormat.updateCache(parseCache, value2, date);
            }
        }
        HashMap<String, Long> hashMap = parseCache;
        synchronized (hashMap) {
            date = FastHttpDateFormat.internalParseDate(value2, formats);
            FastHttpDateFormat.updateCache(parseCache, value2, date);
        }
        if (date == null) {
            return -1L;
        }
        return date;
    }

    private static void updateCache(HashMap cache, Object key, Object value2) {
        if (value2 == null) {
            return;
        }
        if (cache.size() > 1000) {
            cache.clear();
        }
        cache.put(key, value2);
    }

    static {
        format.setTimeZone(gmtZone);
        formats[0].setTimeZone(gmtZone);
        formats[1].setTimeZone(gmtZone);
        formats[2].setTimeZone(gmtZone);
        currentDateGenerated = 0L;
        currentDate = null;
        formatCache = new HashMap();
        parseCache = new HashMap();
    }
}

