/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.jaasapi;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.security.authentication.jaas.JaasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class JaasApiIntegrationFilter
extends GenericFilterBean {
    private boolean createEmptySubject;

    public final void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain2) throws ServletException, IOException {
        Subject subject = this.obtainSubject(request);
        if (subject == null && this.createEmptySubject) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Subject returned was null and createEmtpySubject is true; creating new empty subject to run as.");
            }
            subject = new Subject();
        }
        if (subject == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Subject is null continue running with no Subject.");
            }
            chain2.doFilter(request, response);
            return;
        }
        PrivilegedExceptionAction<Object> continueChain = new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException, ServletException {
                chain2.doFilter(request, response);
                return null;
            }
        };
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Running as Subject " + subject);
        }
        try {
            Subject.doAs(subject, continueChain);
        }
        catch (PrivilegedActionException e) {
            throw new ServletException(e.getMessage(), e);
        }
    }

    protected Subject obtainSubject(ServletRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Attempting to obtainSubject using authentication : " + authentication);
        }
        if (authentication == null) {
            return null;
        }
        if (!authentication.isAuthenticated()) {
            return null;
        }
        if (!(authentication instanceof JaasAuthenticationToken)) {
            return null;
        }
        JaasAuthenticationToken token2 = (JaasAuthenticationToken)authentication;
        LoginContext loginContext = token2.getLoginContext();
        if (loginContext == null) {
            return null;
        }
        return loginContext.getSubject();
    }

    public final void setCreateEmptySubject(boolean createEmptySubject) {
        this.createEmptySubject = createEmptySubject;
    }
}

