/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.lang.reflect.Field;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldUtils {
    public static Field getField(Class<?> clazz, String fieldName) throws IllegalStateException {
        Assert.notNull(clazz, "Class required");
        Assert.hasText(fieldName, "Field name required");
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsf) {
            if (clazz.getSuperclass() != null) {
                return FieldUtils.getField(clazz.getSuperclass(), fieldName);
            }
            throw new IllegalStateException("Could not locate field '" + fieldName + "' on class " + clazz);
        }
    }

    public static Object getFieldValue(Object bean, String fieldName) throws IllegalAccessException {
        Assert.notNull(bean, "Bean cannot be null");
        Assert.hasText(fieldName, "Field name required");
        String[] nestedFields = StringUtils.tokenizeToStringArray(fieldName, ".");
        Class<?> componentClass = bean.getClass();
        Object value2 = bean;
        for (String nestedField : nestedFields) {
            Field field2 = FieldUtils.getField(componentClass, nestedField);
            field2.setAccessible(true);
            value2 = field2.get(value2);
            if (value2 == null) continue;
            componentClass = value2.getClass();
        }
        return value2;
    }

    public static Object getProtectedFieldValue(String protectedField, Object object) {
        Field field2 = FieldUtils.getField(object.getClass(), protectedField);
        try {
            field2.setAccessible(true);
            return field2.get(object);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            return null;
        }
    }

    public static void setProtectedFieldValue(String protectedField, Object object, Object newValue) {
        Field field2 = FieldUtils.getField(object.getClass(), protectedField);
        try {
            field2.setAccessible(true);
            field2.set(object, newValue);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
    }
}

