/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.password;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class Digester {
    private final MessageDigest messageDigest;
    private final int iterations;

    public Digester(String algorithm, int iterations) {
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No such hashing algorithm", e);
        }
        this.iterations = iterations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(byte[] value2) {
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            for (int i = 0; i < this.iterations; ++i) {
                value2 = this.messageDigest.digest(value2);
            }
            return value2;
        }
    }
}

