/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.token;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.springframework.security.crypto.codec.Hex;

public abstract class Sha512DigestUtils {
    private static MessageDigest getSha512Digest() {
        try {
            return MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static byte[] sha(byte[] data2) {
        return Sha512DigestUtils.getSha512Digest().digest(data2);
    }

    public static byte[] sha(String data2) {
        return Sha512DigestUtils.sha(data2.getBytes());
    }

    public static String shaHex(byte[] data2) {
        return new String(Hex.encode(Sha512DigestUtils.sha(data2)));
    }

    public static String shaHex(String data2) {
        return new String(Hex.encode(Sha512DigestUtils.sha(data2)));
    }
}

