/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.ldap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.authentication.PasswordEncoderParser;
import org.springframework.security.config.ldap.LdapUserServiceBeanDefinitionParser;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class LdapProviderBeanDefinitionParser
implements BeanDefinitionParser {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String ATT_USER_DN_PATTERN = "user-dn-pattern";
    private static final String ATT_USER_PASSWORD = "password-attribute";
    private static final String ATT_HASH = "hash";
    private static final String DEF_USER_SEARCH_FILTER = "uid={0}";
    static final String PROVIDER_CLASS = "org.springframework.security.ldap.authentication.LdapAuthenticationProvider";
    static final String BIND_AUTH_CLASS = "org.springframework.security.ldap.authentication.BindAuthenticator";
    static final String PASSWD_AUTH_CLASS = "org.springframework.security.ldap.authentication.PasswordComparisonAuthenticator";

    public BeanDefinition parse(Element elt, ParserContext parserContext) {
        RuntimeBeanReference contextSource = LdapUserServiceBeanDefinitionParser.parseServerReference(elt, parserContext);
        AbstractBeanDefinition searchBean = LdapUserServiceBeanDefinitionParser.parseSearchBean(elt, parserContext);
        String userDnPattern = elt.getAttribute(ATT_USER_DN_PATTERN);
        String[] userDnPatternArray = new String[]{};
        if (StringUtils.hasText(userDnPattern)) {
            userDnPatternArray = new String[]{userDnPattern};
        } else if (searchBean == null) {
            this.logger.info("No search information or DN pattern specified. Using default search filter 'uid={0}'");
            BeanDefinitionBuilder searchBeanBuilder = BeanDefinitionBuilder.rootBeanDefinition("org.springframework.security.ldap.search.FilterBasedLdapUserSearch");
            searchBeanBuilder.getRawBeanDefinition().setSource(elt);
            searchBeanBuilder.addConstructorArgValue("");
            searchBeanBuilder.addConstructorArgValue(DEF_USER_SEARCH_FILTER);
            searchBeanBuilder.addConstructorArgValue(contextSource);
            searchBean = searchBeanBuilder.getBeanDefinition();
        }
        BeanDefinitionBuilder authenticatorBuilder = BeanDefinitionBuilder.rootBeanDefinition(BIND_AUTH_CLASS);
        Element passwordCompareElt = DomUtils.getChildElementByTagName(elt, "password-compare");
        if (passwordCompareElt != null) {
            authenticatorBuilder = BeanDefinitionBuilder.rootBeanDefinition(PASSWD_AUTH_CLASS);
            String passwordAttribute = passwordCompareElt.getAttribute(ATT_USER_PASSWORD);
            if (StringUtils.hasText(passwordAttribute)) {
                authenticatorBuilder.addPropertyValue("passwordAttributeName", passwordAttribute);
            }
            Element passwordEncoderElement = DomUtils.getChildElementByTagName(passwordCompareElt, "password-encoder");
            String hash2 = passwordCompareElt.getAttribute(ATT_HASH);
            if (passwordEncoderElement != null) {
                if (StringUtils.hasText(hash2)) {
                    parserContext.getReaderContext().warning("Attribute 'hash' cannot be used with 'password-encoder' and will be ignored.", parserContext.extractSource(elt));
                }
                PasswordEncoderParser pep = new PasswordEncoderParser(passwordEncoderElement, parserContext);
                authenticatorBuilder.addPropertyValue("passwordEncoder", pep.getPasswordEncoder());
                if (pep.getSaltSource() != null) {
                    parserContext.getReaderContext().warning("Salt source information isn't valid when used with LDAP", passwordEncoderElement);
                }
            } else if (StringUtils.hasText(hash2)) {
                authenticatorBuilder.addPropertyValue("passwordEncoder", PasswordEncoderParser.createPasswordEncoderBeanDefinition(hash2, false));
            }
        }
        authenticatorBuilder.addConstructorArgValue(contextSource);
        authenticatorBuilder.addPropertyValue("userDnPatterns", userDnPatternArray);
        if (searchBean != null) {
            authenticatorBuilder.addPropertyValue("userSearch", searchBean);
        }
        BeanDefinitionBuilder ldapProvider = BeanDefinitionBuilder.rootBeanDefinition(PROVIDER_CLASS);
        ldapProvider.addConstructorArgValue(authenticatorBuilder.getBeanDefinition());
        ldapProvider.addConstructorArgValue(LdapUserServiceBeanDefinitionParser.parseAuthoritiesPopulator(elt, parserContext));
        ldapProvider.addPropertyValue("userDetailsContextMapper", LdapUserServiceBeanDefinitionParser.parseUserDetailsClassOrUserMapperRef(elt, parserContext));
        return ldapProvider.getBeanDefinition();
    }
}

