/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.Collections;
import org.springframework.http.MediaType;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.RequestCacheAwareFilter;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestCacheConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<RequestCacheConfigurer<H>, H> {
    public RequestCacheConfigurer<H> requestCache(RequestCache requestCache) {
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(RequestCache.class, requestCache);
        return this;
    }

    @Override
    public void init(H http) throws Exception {
        http.setSharedObject(RequestCache.class, (RequestCache)this.getRequestCache(http));
    }

    @Override
    public void configure(H http) throws Exception {
        RequestCache requestCache = this.getRequestCache(http);
        RequestCacheAwareFilter requestCacheFilter = new RequestCacheAwareFilter(requestCache);
        requestCacheFilter = this.postProcess(requestCacheFilter);
        http.addFilter(requestCacheFilter);
    }

    private RequestCache getRequestCache(H http) {
        RequestCache result2 = http.getSharedObject(RequestCache.class);
        if (result2 != null) {
            return result2;
        }
        HttpSessionRequestCache defaultCache = new HttpSessionRequestCache();
        defaultCache.setRequestMatcher(this.createDefaultSavedRequestMatcher(http));
        return defaultCache;
    }

    private RequestMatcher createDefaultSavedRequestMatcher(H http) {
        ContentNegotiationStrategy contentNegotiationStrategy = http.getSharedObject(ContentNegotiationStrategy.class);
        if (contentNegotiationStrategy == null) {
            contentNegotiationStrategy = new HeaderContentNegotiationStrategy();
        }
        NegatedRequestMatcher notFavIcon = new NegatedRequestMatcher(new AntPathRequestMatcher("/**/favicon.ico"));
        MediaTypeRequestMatcher jsonRequest = new MediaTypeRequestMatcher(contentNegotiationStrategy, MediaType.APPLICATION_JSON);
        jsonRequest.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        NegatedRequestMatcher notJson = new NegatedRequestMatcher(jsonRequest);
        NegatedRequestMatcher notXRequestedWith = new NegatedRequestMatcher(new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest"));
        boolean isCsrfEnabled = http.getConfigurer(CsrfConfigurer.class) != null;
        ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
        if (isCsrfEnabled) {
            AntPathRequestMatcher getRequests = new AntPathRequestMatcher("/**", "GET");
            matchers.add(0, getRequests);
        }
        matchers.add(notFavIcon);
        matchers.add(notJson);
        matchers.add(notXRequestedWith);
        return new AndRequestMatcher(matchers);
    }
}

