/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.acls.domain.AccessControlEntryImpl;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.domain.DefaultPermissionGrantingStrategy;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AuditableAcl;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.OwnershipAcl;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.acls.model.UnloadedSidException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AclImpl
implements Acl,
MutableAcl,
AuditableAcl,
OwnershipAcl {
    private Acl parentAcl;
    private transient AclAuthorizationStrategy aclAuthorizationStrategy;
    private transient PermissionGrantingStrategy permissionGrantingStrategy;
    private final List<AccessControlEntry> aces = new ArrayList<AccessControlEntry>();
    private ObjectIdentity objectIdentity;
    private Serializable id;
    private Sid owner;
    private List<Sid> loadedSids = null;
    private boolean entriesInheriting = true;

    public AclImpl(ObjectIdentity objectIdentity, Serializable id, AclAuthorizationStrategy aclAuthorizationStrategy, AuditLogger auditLogger) {
        Assert.notNull(objectIdentity, "Object Identity required");
        Assert.notNull(id, "Id required");
        Assert.notNull(aclAuthorizationStrategy, "AclAuthorizationStrategy required");
        Assert.notNull(auditLogger, "AuditLogger required");
        this.objectIdentity = objectIdentity;
        this.id = id;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
        this.permissionGrantingStrategy = new DefaultPermissionGrantingStrategy(auditLogger);
    }

    @Deprecated
    public AclImpl(ObjectIdentity objectIdentity, Serializable id, AclAuthorizationStrategy aclAuthorizationStrategy, AuditLogger auditLogger, Acl parentAcl, List<Sid> loadedSids, boolean entriesInheriting, Sid owner) {
        this(objectIdentity, id, aclAuthorizationStrategy, new DefaultPermissionGrantingStrategy(auditLogger), parentAcl, loadedSids, entriesInheriting, owner);
    }

    public AclImpl(ObjectIdentity objectIdentity, Serializable id, AclAuthorizationStrategy aclAuthorizationStrategy, PermissionGrantingStrategy grantingStrategy, Acl parentAcl, List<Sid> loadedSids, boolean entriesInheriting, Sid owner) {
        Assert.notNull(objectIdentity, "Object Identity required");
        Assert.notNull(id, "Id required");
        Assert.notNull(aclAuthorizationStrategy, "AclAuthorizationStrategy required");
        Assert.notNull(owner, "Owner required");
        this.objectIdentity = objectIdentity;
        this.id = id;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
        this.parentAcl = parentAcl;
        this.loadedSids = loadedSids;
        this.entriesInheriting = entriesInheriting;
        this.owner = owner;
        this.permissionGrantingStrategy = grantingStrategy;
    }

    private AclImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAce(int aceIndex) throws NotFoundException {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        this.verifyAceIndexExists(aceIndex);
        List<AccessControlEntry> list2 = this.aces;
        synchronized (list2) {
            this.aces.remove(aceIndex);
        }
    }

    private void verifyAceIndexExists(int aceIndex) {
        if (aceIndex < 0) {
            throw new NotFoundException("aceIndex must be greater than or equal to zero");
        }
        if (aceIndex >= this.aces.size()) {
            throw new NotFoundException("aceIndex must refer to an index of the AccessControlEntry list. List size is " + this.aces.size() + ", index was " + aceIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertAce(int atIndexLocation, Permission permission, Sid sid, boolean granting) throws NotFoundException {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        Assert.notNull(permission, "Permission required");
        Assert.notNull(sid, "Sid required");
        if (atIndexLocation < 0) {
            throw new NotFoundException("atIndexLocation must be greater than or equal to zero");
        }
        if (atIndexLocation > this.aces.size()) {
            throw new NotFoundException("atIndexLocation must be less than or equal to the size of the AccessControlEntry collection");
        }
        AccessControlEntryImpl ace = new AccessControlEntryImpl(null, this, sid, permission, granting, false, false);
        List<AccessControlEntry> list2 = this.aces;
        synchronized (list2) {
            this.aces.add(atIndexLocation, ace);
        }
    }

    @Override
    public List<AccessControlEntry> getEntries() {
        return new ArrayList<AccessControlEntry>(this.aces);
    }

    @Override
    public Serializable getId() {
        return this.id;
    }

    @Override
    public ObjectIdentity getObjectIdentity() {
        return this.objectIdentity;
    }

    @Override
    public boolean isEntriesInheriting() {
        return this.entriesInheriting;
    }

    @Override
    public boolean isGranted(List<Permission> permission, List<Sid> sids, boolean administrativeMode) throws NotFoundException, UnloadedSidException {
        Assert.notEmpty(permission, "Permissions required");
        Assert.notEmpty(sids, "SIDs required");
        if (!this.isSidLoaded(sids)) {
            throw new UnloadedSidException("ACL was not loaded for one or more SID");
        }
        return this.permissionGrantingStrategy.isGranted(this, permission, sids, administrativeMode);
    }

    @Override
    public boolean isSidLoaded(List<Sid> sids) {
        if (this.loadedSids == null || sids == null || sids.size() == 0) {
            return true;
        }
        for (Sid sid : sids) {
            boolean found = false;
            for (Sid loadedSid : this.loadedSids) {
                if (!((Object)sid).equals(loadedSid)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEntriesInheriting(boolean entriesInheriting) {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        this.entriesInheriting = entriesInheriting;
    }

    @Override
    public void setOwner(Sid newOwner) {
        this.aclAuthorizationStrategy.securityCheck(this, 0);
        Assert.notNull(newOwner, "Owner required");
        this.owner = newOwner;
    }

    @Override
    public Sid getOwner() {
        return this.owner;
    }

    @Override
    public void setParent(Acl newParent) {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        Assert.isTrue(newParent == null || !newParent.equals(this), "Cannot be the parent of yourself");
        this.parentAcl = newParent;
    }

    @Override
    public Acl getParentAcl() {
        return this.parentAcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAce(int aceIndex, Permission permission) throws NotFoundException {
        this.aclAuthorizationStrategy.securityCheck(this, 2);
        this.verifyAceIndexExists(aceIndex);
        List<AccessControlEntry> list2 = this.aces;
        synchronized (list2) {
            AccessControlEntryImpl ace = (AccessControlEntryImpl)this.aces.get(aceIndex);
            ace.setPermission(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAuditing(int aceIndex, boolean auditSuccess, boolean auditFailure) {
        this.aclAuthorizationStrategy.securityCheck(this, 1);
        this.verifyAceIndexExists(aceIndex);
        List<AccessControlEntry> list2 = this.aces;
        synchronized (list2) {
            AccessControlEntryImpl ace = (AccessControlEntryImpl)this.aces.get(aceIndex);
            ace.setAuditSuccess(auditSuccess);
            ace.setAuditFailure(auditFailure);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AclImpl) {
            AclImpl rhs = (AclImpl)obj;
            if (((Object)this.aces).equals(rhs.aces) && (this.parentAcl == null && rhs.parentAcl == null || this.parentAcl != null && this.parentAcl.equals(rhs.parentAcl)) && (this.objectIdentity == null && rhs.objectIdentity == null || this.objectIdentity != null && ((Object)this.objectIdentity).equals(rhs.objectIdentity)) && (this.id == null && rhs.id == null || this.id != null && this.id.equals(rhs.id)) && (this.owner == null && rhs.owner == null || this.owner != null && ((Object)this.owner).equals(rhs.owner)) && this.entriesInheriting == rhs.entriesInheriting) {
                if (this.loadedSids == null && rhs.loadedSids == null) {
                    return true;
                }
                if (this.loadedSids != null && this.loadedSids.size() == rhs.loadedSids.size()) {
                    for (int i = 0; i < this.loadedSids.size(); ++i) {
                        if (((Object)this.loadedSids.get(i)).equals(rhs.loadedSids.get(i))) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AclImpl[");
        sb.append("id: ").append(this.id).append("; ");
        sb.append("objectIdentity: ").append(this.objectIdentity).append("; ");
        sb.append("owner: ").append(this.owner).append("; ");
        int count2 = 0;
        for (AccessControlEntry ace : this.aces) {
            if (++count2 == 1) {
                sb.append("\n");
            }
            sb.append(ace).append("\n");
        }
        if (count2 == 0) {
            sb.append("no ACEs; ");
        }
        sb.append("inheriting: ").append(this.entriesInheriting).append("; ");
        sb.append("parent: ").append(this.parentAcl == null ? "Null" : this.parentAcl.getObjectIdentity().toString());
        sb.append("; ");
        sb.append("aclAuthorizationStrategy: ").append(this.aclAuthorizationStrategy).append("; ");
        sb.append("permissionGrantingStrategy: ").append(this.permissionGrantingStrategy);
        sb.append("]");
        return sb.toString();
    }
}

