/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.afterinvocation;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.acls.afterinvocation.AbstractAclProvider;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.SpringSecurityMessageSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AclEntryAfterInvocationProvider
extends AbstractAclProvider
implements MessageSourceAware {
    protected static final Log logger = LogFactory.getLog(AclEntryAfterInvocationProvider.class);
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();

    public AclEntryAfterInvocationProvider(AclService aclService, List<Permission> requirePermission) {
        this(aclService, "AFTER_ACL_READ", requirePermission);
    }

    public AclEntryAfterInvocationProvider(AclService aclService, String processConfigAttribute, List<Permission> requirePermission) {
        super(aclService, processConfigAttribute, requirePermission);
    }

    @Override
    public Object decide(Authentication authentication, Object object, Collection<ConfigAttribute> config, Object returnedObject) throws AccessDeniedException {
        if (returnedObject == null) {
            logger.debug("Return object is null, skipping");
            return null;
        }
        if (!this.getProcessDomainObjectClass().isAssignableFrom(returnedObject.getClass())) {
            logger.debug("Return object is not applicable for this provider, skipping");
            return returnedObject;
        }
        for (ConfigAttribute attr : config) {
            if (!this.supports(attr)) continue;
            if (this.hasPermission(authentication, returnedObject)) {
                return returnedObject;
            }
            logger.debug("Denying access");
            throw new AccessDeniedException(this.messages.getMessage("AclEntryAfterInvocationProvider.noPermission", new Object[]{authentication.getName(), returnedObject}, "Authentication {0} has NO permissions to the domain object {1}"));
        }
        return returnedObject;
    }

    @Override
    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }
}

