/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.StatementCreatorUtils;

class ArgTypePreparedStatementSetter
implements PreparedStatementSetter,
ParameterDisposer {
    private final Object[] args;
    private final int[] argTypes;

    public ArgTypePreparedStatementSetter(Object[] args, int[] argTypes) {
        if (args != null && argTypes == null || args == null && argTypes != null || args != null && args.length != argTypes.length) {
            throw new InvalidDataAccessApiUsageException("args and argTypes parameters must match");
        }
        this.args = args;
        this.argTypes = argTypes;
    }

    public void setValues(PreparedStatement ps) throws SQLException {
        int parameterPosition = 1;
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                Object arg = this.args[i];
                if (arg instanceof Collection && this.argTypes[i] != 2003) {
                    Collection entries = (Collection)arg;
                    for (Object entry2 : entries) {
                        if (entry2 instanceof Object[]) {
                            Object[] valueArray = (Object[])entry2;
                            int k = 0;
                            while (k < valueArray.length) {
                                Object argValue = valueArray[k];
                                this.doSetValue(ps, parameterPosition, this.argTypes[i], argValue);
                                ++parameterPosition;
                                ++k;
                            }
                            continue;
                        }
                        this.doSetValue(ps, parameterPosition, this.argTypes[i], entry2);
                        ++parameterPosition;
                    }
                } else {
                    this.doSetValue(ps, parameterPosition, this.argTypes[i], arg);
                    ++parameterPosition;
                }
                ++i;
            }
        }
    }

    protected void doSetValue(PreparedStatement ps, int parameterPosition, int argType, Object argValue) throws SQLException {
        StatementCreatorUtils.setParameterValue(ps, parameterPosition, argType, argValue);
    }

    public void cleanupParameters() {
        StatementCreatorUtils.cleanupParameters(this.args);
    }
}

