/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanInterceptor;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.MessageInterpolatorImpl;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.Transactor;

public class WriteableView
implements InvocationHandler,
Transactor,
ConfigView {
    private static final TraversableResolver TRAVERSABLE_RESOLVER = new TraversableResolver(){

        @Override
        public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return true;
        }

        @Override
        public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return true;
        }
    };
    private static final Validator beanValidator;
    private final ConfigBean bean;
    private final ConfigBeanProxy defaultView;
    private final Map<String, PropertyChangeEvent> changedAttributes;
    private final Map<String, ProtectedList> changedCollections;
    Transaction currentTx;
    private boolean isDeleted;
    private static final ResourceBundle i18n;
    private static final ParameterizedType parameterizedType;

    public Transaction getTransaction() {
        return this.currentTx;
    }

    public WriteableView(ConfigBeanProxy readView) {
        this.bean = (ConfigBean)((ConfigView)Proxy.getInvocationHandler(readView)).getMasterView();
        this.defaultView = this.bean.createProxy();
        this.changedAttributes = new HashMap<String, PropertyChangeEvent>();
        this.changedCollections = new HashMap<String, ProtectedList>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("hashCode")) {
            return super.hashCode();
        }
        if (method.getName().equals("equals")) {
            return super.equals(args[0]);
        }
        if (method.getAnnotation(DuckTyped.class) != null) {
            return this.bean.invokeDuckMethod(method, proxy, args);
        }
        ConfigModel.Property property = this.bean.model.toProperty(method);
        if (property == null) {
            throw new IllegalArgumentException("No corresponding property found for method: " + method);
        }
        if (args == null || args.length == 0) {
            if (this.changedAttributes.containsKey(property.xmlName())) {
                Object changedValue = this.changedAttributes.get(property.xmlName()).getNewValue();
                if (changedValue instanceof Dom) {
                    return ((Dom)changedValue).createProxy();
                }
                return changedValue;
            }
            return this.getter(property, method.getGenericReturnType());
        }
        this.setter(property, args[0], method.getGenericParameterTypes()[0]);
        return null;
    }

    public String getPropertyValue(String propertyName) {
        ConfigModel.Property prop = this.getProperty(propertyName);
        if (prop != null) {
            if (this.changedAttributes.containsKey(prop.xmlName())) {
                return (String)this.changedAttributes.get(prop.xmlName()).getNewValue();
            }
            return (String)this.getter(prop, (Type)((Object)String.class));
        }
        return null;
    }

    public Object getter(ConfigModel.Property property, Type t) {
        Object value2 = this.bean._getter(property, t);
        if (value2 instanceof List) {
            if (!this.changedCollections.containsKey(property.xmlName())) {
                this.changedCollections.put(property.xmlName(), new ProtectedList((List)List.class.cast(value2), this.defaultView, property.xmlName()));
            }
            return this.changedCollections.get(property.xmlName());
        }
        return value2;
    }

    public void setter(ConfigModel.Property property, Object newValue, Type t) {
        if (this.currentTx == null) {
            throw new IllegalStateException("Not part of a transaction");
        }
        try {
            if (newValue != null) {
                this.handleValidation(property, newValue);
            }
        }
        catch (Exception v) {
            this.bean.getLock().unlock();
            throw new RuntimeException(v);
        }
        if (property instanceof ConfigModel.AttributeLeaf) {
            ConfigModel.AttributeLeaf al = (ConfigModel.AttributeLeaf)property;
            ConfigBean master = this.getMasterView();
            String key = master.model.key;
            if (key != null && key.substring(1).equals(property.xmlName)) {
                key = key.substring(1);
                String oldKeyValue = this.getPropertyValue(key);
                Dom thisview = Dom.unwrap(this.defaultView);
                Dom parent = thisview.parent();
                List<Object> siblings = parent != null ? parent.domNodeByTypeElements(thisview.getProxyType()) : new ArrayList();
                for (Dom dom : siblings) {
                    String siblingKey = dom.getKey();
                    if (!newValue.equals(siblingKey)) continue;
                    this.bean.getLock().unlock();
                    throw new IllegalArgumentException("Keys cannot be duplicate. Old value of this key property, " + oldKeyValue + "will be retained");
                }
            }
        }
        Object oldValue = this.bean.getter(property, t);
        if (newValue instanceof ConfigBeanProxy) {
            ConfigView bean = (ConfigView)Proxy.getInvocationHandler((ConfigBeanProxy)newValue);
            newValue = bean.getMasterView();
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.defaultView, property.xmlName(), oldValue, newValue);
        try {
            for (ConfigBeanInterceptor interceptor : this.bean.getOptionalFeatures()) {
                interceptor.beforeChange(evt);
            }
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException(e);
        }
        this.changedAttributes.put(property.xmlName(), evt);
        for (ConfigBeanInterceptor interceptor : this.bean.getOptionalFeatures()) {
            interceptor.afterChange(evt, System.currentTimeMillis());
        }
    }

    public ConfigModel.Property getProperty(String xmlName) {
        return this.bean.model.findIgnoreCase(xmlName);
    }

    @Override
    public synchronized boolean join(Transaction t) {
        if (this.currentTx == null) {
            this.currentTx = t;
            t.addParticipant(this);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean canCommit(Transaction t) throws TransactionFailure {
        if (!this.isDeleted) {
            Set constraintViolations = beanValidator.validate(this.getProxy(this.getProxyType()), new Class[0]);
            try {
                this.handleValidationException(constraintViolations);
            }
            catch (ConstraintViolationException constraintViolationException) {
                throw new TransactionFailure(constraintViolationException.getMessage(), constraintViolationException);
            }
        }
        return this.currentTx == t;
    }

    private void handleValidationException(Set constraintViolations) throws ConstraintViolationException {
        if (constraintViolations != null && !constraintViolations.isEmpty()) {
            Iterator it = constraintViolations.iterator();
            StringBuilder sb = new StringBuilder();
            sb.append(MessageFormat.format(i18n.getString("bean.validation.failure"), this.getProxyType().getSimpleName()));
            String violationMsg = i18n.getString("bean.validation.constraintViolation");
            while (it.hasNext()) {
                ConstraintViolation cv = (ConstraintViolation)it.next();
                sb.append(" ");
                sb.append(MessageFormat.format(violationMsg, cv.getMessage(), cv.getPropertyPath()));
                if (!it.hasNext()) continue;
                sb.append(i18n.getString("bean.validation.separator"));
            }
            this.bean.getLock().unlock();
            throw new ConstraintViolationException(sb.toString(), constraintViolations);
        }
    }

    public static String stripMarkers(String s2) {
        if (s2.startsWith("@")) {
            return s2.substring(1);
        }
        if (s2.startsWith("<")) {
            return s2.substring(1, s2.length() - 1);
        }
        return s2;
    }

    @Override
    public synchronized List<PropertyChangeEvent> commit(Transaction t) throws TransactionFailure {
        if (this.currentTx == t) {
            this.currentTx = null;
        }
        ConfigBean master = this.getMasterView();
        String keyStr = master.model.key;
        if (keyStr != null) {
            String key = WriteableView.stripMarkers(keyStr);
            String value2 = this.getPropertyValue(key);
            if (value2 == null) {
                throw new TransactionFailure("Key value cannot be null: " + key);
            }
            if (value2.length() == 0) {
                throw new TransactionFailure("Key value cannot be empty string: " + key);
            }
        }
        try {
            ArrayList<PropertyChangeEvent> appliedChanges = new ArrayList<PropertyChangeEvent>();
            for (PropertyChangeEvent event : this.changedAttributes.values()) {
                ConfigModel.Property property = this.bean.model.findIgnoreCase(event.getPropertyName());
                ConfigBeanInterceptor interceptor = this.bean.getOptionalFeature(ConfigBeanInterceptor.class);
                try {
                    if (interceptor != null) {
                        interceptor.beforeChange(event);
                    }
                }
                catch (PropertyVetoException e) {
                    throw new TransactionFailure(e.getMessage(), e);
                }
                property.set(this.bean, event.getNewValue());
                if (interceptor != null) {
                    interceptor.afterChange(event, System.currentTimeMillis());
                }
                appliedChanges.add(event);
            }
            for (ProtectedList entry2 : this.changedCollections.values()) {
                List<Object> originalList = entry2.readOnly;
                for (PropertyChangeEvent event : entry2.changeEvents) {
                    if (event.getOldValue() == null) {
                        originalList.add(event.getNewValue());
                    } else {
                        int index2;
                        Object toBeRemoved;
                        Object toBeRemovedObj = event.getOldValue();
                        if (toBeRemovedObj instanceof ConfigBeanProxy) {
                            toBeRemoved = Dom.unwrap((ConfigBeanProxy)toBeRemovedObj);
                            for (index2 = 0; index2 < originalList.size(); ++index2) {
                                Object element = originalList.get(index2);
                                Dom dom = Dom.unwrap((ConfigBeanProxy)element);
                                if (dom != toBeRemoved) continue;
                                Object newValue = event.getNewValue();
                                if (newValue == null) {
                                    originalList.remove(index2);
                                    continue;
                                }
                                originalList.set(index2, newValue);
                            }
                        } else if (toBeRemovedObj instanceof String) {
                            toBeRemoved = (String)toBeRemovedObj;
                            for (index2 = 0; index2 < originalList.size(); ++index2) {
                                String item = (String)originalList.get(index2);
                                if (!item.equals(toBeRemoved)) continue;
                                originalList.remove(index2);
                            }
                        } else {
                            throw new IllegalArgumentException();
                        }
                    }
                    appliedChanges.add(event);
                }
            }
            this.changedAttributes.clear();
            this.changedCollections.clear();
            ArrayList<PropertyChangeEvent> arrayList = appliedChanges;
            return arrayList;
        }
        catch (TransactionFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransactionFailure(e.getMessage(), e);
        }
        finally {
            this.bean.getLock().unlock();
        }
    }

    @Override
    public synchronized void abort(Transaction t) {
        this.currentTx = null;
        this.bean.getLock().unlock();
        this.changedAttributes.clear();
    }

    public <T extends ConfigBeanProxy> T allocateProxy(Class<T> type) throws TransactionFailure {
        if (this.currentTx == null) {
            throw new TransactionFailure("Not part of a transaction", null);
        }
        ConfigBean newBean = this.bean.allocate(type);
        this.bean.getHabitat().getService(ConfigSupport.class, new Annotation[0]);
        WriteableView writeableView = ConfigSupport.getWriteableView(newBean.getProxy(type), newBean);
        writeableView.join(this.currentTx);
        return writeableView.getProxy(type);
    }

    @Override
    public ConfigBean getMasterView() {
        return this.bean;
    }

    @Override
    public void setMasterView(ConfigView view) {
    }

    @Override
    public <T extends ConfigBeanProxy> Class<T> getProxyType() {
        return this.bean.getProxyType();
    }

    @Override
    public <T extends ConfigBeanProxy> T getProxy(final Class<T> type) {
        ConfigBean sourceBean = this.getMasterView();
        if (!type.getName().equals(sourceBean.model.targetTypeName)) {
            throw new IllegalArgumentException("This config bean interface is " + sourceBean.model.targetTypeName + " not " + type.getName());
        }
        Class[] interfacesClasses = new Class[]{type};
        ClassLoader cl = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return type.getClassLoader();
            }
        }) : type.getClassLoader();
        return (T)((ConfigBeanProxy)Proxy.newProxyInstance(cl, interfacesClasses, (InvocationHandler)this));
    }

    boolean removeNestedElements(Object object) {
        InvocationHandler h = Proxy.getInvocationHandler(object);
        if (!(h instanceof WriteableView)) {
            ConfigBean bean = (ConfigBean)((ConfigView)h).getMasterView();
            if ((h = bean.getWriteableView()) == null) {
                ConfigBeanProxy writable;
                try {
                    writable = this.currentTx.enroll((ConfigBeanProxy)object);
                }
                catch (TransactionFailure e) {
                    throw new RuntimeException(e);
                }
                h = Proxy.getInvocationHandler(writable);
            } else {
                return false;
            }
        }
        WriteableView writableView = (WriteableView)h;
        writableView.isDeleted = true;
        boolean removed = false;
        for (ConfigModel.Property property : writableView.bean.model.elements.values()) {
            Object oldValue;
            if (property.isCollection()) {
                Object nested = writableView.getter(property, parameterizedType);
                ProtectedList list2 = (ProtectedList)nested;
                if (list2.size() <= 0) continue;
                list2.clear();
                removed = true;
                continue;
            }
            if (property.isLeaf() || (oldValue = writableView.getter(property, (Type)((Object)ConfigBeanProxy.class))) == null) continue;
            writableView.setter(property, null, (Type)((Object)Dom.class));
            removed = true;
            this.removeNestedElements(oldValue);
        }
        return removed;
    }

    private String toCamelCase(String xmlName) {
        StringTokenizer st = new StringTokenizer(xmlName, "-");
        StringBuffer camelCaseName = null;
        if (st.hasMoreTokens()) {
            camelCaseName = new StringBuffer(st.nextToken());
        }
        StringBuffer sb = null;
        while (st.hasMoreTokens()) {
            sb = new StringBuffer(st.nextToken());
            char startChar = sb.charAt(0);
            sb.setCharAt(0, Character.toUpperCase(startChar));
            camelCaseName.append(sb);
        }
        return camelCaseName.toString();
    }

    private void handleValidation(ConfigModel.Property property, Object value2) throws ConstraintViolationException {
        ConstraintViolation cv;
        ConfigModel.AttributeLeaf al;
        HashSet constraintViolations = new HashSet();
        if (property instanceof ConfigModel.AttributeLeaf && !(al = (ConfigModel.AttributeLeaf)property).isReference() && (cv = this.validateDataType(al, value2.toString())) != null) {
            constraintViolations.add(cv);
        }
        constraintViolations.addAll(beanValidator.validateValue(this.bean.getProxyType(), this.toCamelCase(property.xmlName()), value2, new Class[0]));
        this.handleValidationException(constraintViolations);
    }

    private ConstraintViolation validateDataType(final ConfigModel.AttributeLeaf al, final String value2) {
        if (value2.startsWith("${") && value2.endsWith("}")) {
            return null;
        }
        boolean isValid = String.class.getName().equals(al.dataType);
        if ("int".equals(al.dataType) || "java.lang.Integer".equals(al.dataType)) {
            isValid = this.representsInteger(value2);
        } else if ("long".equals(al.dataType) || "java.lang.Long".equals(al.dataType)) {
            isValid = this.representsLong(value2);
        } else if ("boolean".equals(al.dataType) || "java.lang.Boolean".endsWith(al.dataType)) {
            isValid = this.representsBoolean(value2);
        } else if ("char".equals(al.dataType) || "java.lang.Character".equals(al.dataType)) {
            isValid = this.representsChar(value2);
        }
        if (!isValid) {
            return new ConstraintViolation(){

                @Override
                public String getMessage() {
                    return i18n.getString("bean.validation.dataType.failure") + al.dataType;
                }

                @Override
                public String getMessageTemplate() {
                    return null;
                }

                public Object getRootBean() {
                    return WriteableView.this;
                }

                public Class getRootBeanClass() {
                    return WriteableView.this.getProxyType();
                }

                @Override
                public Object getLeafBean() {
                    return null;
                }

                @Override
                public Object[] getExecutableParameters() {
                    return null;
                }

                @Override
                public Object getExecutableReturnValue() {
                    return null;
                }

                @Override
                public Path getPropertyPath() {
                    final HashSet<1> nodes = new HashSet<1>();
                    nodes.add(new Path.Node(){

                        @Override
                        public String getName() {
                            return al.xmlName;
                        }

                        @Override
                        public boolean isInIterable() {
                            return false;
                        }

                        @Override
                        public Integer getIndex() {
                            return null;
                        }

                        @Override
                        public Object getKey() {
                            return null;
                        }

                        @Override
                        public ElementKind getKind() {
                            return null;
                        }

                        @Override
                        public <T extends Path.Node> T as(Class<T> tClass) {
                            return null;
                        }
                    });
                    return new Path(){

                        @Override
                        public Iterator<Path.Node> iterator() {
                            return nodes.iterator();
                        }
                    };
                }

                @Override
                public Object getInvalidValue() {
                    return value2;
                }

                @Override
                public ConstraintDescriptor<?> getConstraintDescriptor() {
                    return null;
                }

                public Object unwrap(Class type) {
                    return null;
                }
            };
        }
        return null;
    }

    private boolean representsBoolean(String value2) {
        boolean isBoolean = "true".equalsIgnoreCase(value2) || "false".equalsIgnoreCase(value2);
        return isBoolean;
    }

    private boolean representsChar(String value2) {
        return value2.length() == 1;
    }

    private boolean representsInteger(String value2) {
        try {
            Integer.parseInt(value2);
            return true;
        }
        catch (NumberFormatException ne) {
            return false;
        }
    }

    private boolean representsLong(String value2) {
        try {
            Long.parseLong(value2);
            return true;
        }
        catch (NumberFormatException ne) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader cl = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        try {
            Thread.currentThread().setContextClassLoader(ValidatorFactory.class.getClassLoader());
            ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
            ValidatorContext validatorContext = validatorFactory.usingContext();
            validatorContext.messageInterpolator(new MessageInterpolatorImpl());
            beanValidator = validatorContext.traversableResolver(TRAVERSABLE_RESOLVER).getValidator();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        i18n = ResourceBundle.getBundle("org.jvnet.hk2.config.LocalStrings");
        parameterizedType = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{ConfigBeanProxy.class};
            }

            @Override
            public Type getRawType() {
                return Collection.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    private class ProtectedList
    extends AbstractList {
        final ConfigBeanProxy readView;
        final List<Object> readOnly;
        final String id;
        final List<PropertyChangeEvent> changeEvents = new ArrayList<PropertyChangeEvent>();
        final List proxied;

        ProtectedList(List<Object> readOnly, ConfigBeanProxy parent, String id) {
            this.proxied = Collections.synchronizedList(new ArrayList<Object>(readOnly));
            this.readView = parent;
            this.readOnly = readOnly;
            this.id = id;
        }

        @Override
        public int size() {
            return this.proxied.size();
        }

        @Override
        public Object get(int index2) {
            return this.proxied.get(index2);
        }

        @Override
        public synchronized boolean add(Object object) {
            Object param2 = object;
            InvocationHandler handler = null;
            try {
                handler = Proxy.getInvocationHandler(object);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (handler != null && handler instanceof WriteableView) {
                ConfigBean master = ((WriteableView)handler).getMasterView();
                String key = master.model.key;
                if (key != null) {
                    key = key.substring(1);
                    String keyValue = ((WriteableView)handler).getPropertyValue(key);
                    for (Object o : this.proxied) {
                        String value2 = null;
                        if (Proxy.getInvocationHandler(o) instanceof WriteableView) {
                            ConfigBean masterView = ((WriteableView)handler).getMasterView();
                            String masterViewKey = masterView.model.key;
                            if (masterViewKey != null && key.equals(masterViewKey.substring(1))) {
                                value2 = ((WriteableView)Proxy.getInvocationHandler(o)).getPropertyValue(key);
                            }
                        } else {
                            Dom cbo = Dom.unwrap((ConfigBeanProxy)o);
                            String cboKey = cbo.model.key;
                            if (cboKey != null && key.equals(cboKey.substring(1))) {
                                value2 = cbo.attribute(key);
                            }
                        }
                        if (keyValue == null || value2 == null || !keyValue.equals(value2)) continue;
                        Dom parent = Dom.unwrap(this.readView);
                        throw new IllegalArgumentException("A " + master.getProxyType().getSimpleName() + " with the same key \"" + keyValue + "\" already exists in " + parent.getProxyType().getSimpleName() + " " + parent.getKey());
                    }
                }
                param2 = ((WriteableView)handler).getMasterView().createProxy(master.getImplementationClass());
            }
            PropertyChangeEvent evt = new PropertyChangeEvent(WriteableView.this.defaultView, this.id, null, param2);
            this.changeEvents.add(evt);
            boolean added = this.proxied.add(object);
            try {
                for (ConfigBeanInterceptor interceptor : WriteableView.this.bean.getOptionalFeatures()) {
                    interceptor.beforeChange(evt);
                }
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
            return added;
        }

        @Override
        public synchronized void clear() {
            ArrayList allItems = new ArrayList(this.proxied);
            for (Object item : allItems) {
                this.remove(item);
            }
        }

        @Override
        public synchronized boolean retainAll(Collection keepers) {
            ArrayList toRemoveList = new ArrayList();
            for (Object iffy : this.proxied) {
                if (keepers.contains(iffy)) continue;
                toRemoveList.add(iffy);
            }
            boolean changed = this.removeAll((Collection)toRemoveList);
            return changed;
        }

        @Override
        public synchronized boolean removeAll(Collection goners) {
            boolean listChanged = false;
            for (Object goner : goners) {
                if (!this.remove(goner)) continue;
                listChanged = true;
            }
            return listChanged;
        }

        @Override
        public synchronized boolean remove(Object object) {
            PropertyChangeEvent evt = new PropertyChangeEvent(WriteableView.this.defaultView, this.id, object, null);
            boolean removed = false;
            try {
                ConfigView handler = ((ConfigView)Proxy.getInvocationHandler(object)).getMasterView();
                for (int index2 = 0; index2 < this.proxied.size() && !removed; ++index2) {
                    Object target = this.proxied.get(index2);
                    try {
                        ConfigView targetHandler = ((ConfigView)Proxy.getInvocationHandler(target)).getMasterView();
                        if (targetHandler != handler) continue;
                        removed = this.proxied.remove(index2) != null;
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                }
            }
            catch (IllegalArgumentException e) {
                removed = this.proxied.remove(object);
            }
            try {
                for (ConfigBeanInterceptor interceptor : WriteableView.this.bean.getOptionalFeatures()) {
                    interceptor.beforeChange(evt);
                }
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
            this.changeEvents.add(evt);
            return removed;
        }

        @Override
        public Object set(int index2, Object object) {
            Object replaced = this.proxied.set(index2, object);
            PropertyChangeEvent evt = new PropertyChangeEvent(WriteableView.this.defaultView, this.id, replaced, object);
            try {
                for (ConfigBeanInterceptor interceptor : WriteableView.this.bean.getOptionalFeatures()) {
                    interceptor.beforeChange(evt);
                }
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
            this.changeEvents.add(evt);
            return replaced;
        }
    }
}

