/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import org.jvnet.hk2.config.DataType;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.ValidationException;

public final class PrimitiveDataType
implements DataType {
    private final String realType;

    PrimitiveDataType(String realType) {
        assert (DomDocument.PRIMS.contains(realType)) : "This class can't validate: " + realType;
        this.realType = realType;
    }

    @Override
    public void validate(String value2) throws ValidationException {
        if (value2.startsWith("${") && value2.endsWith("}")) {
            return;
        }
        boolean match = false;
        if ("int".equals(this.realType) || "java.lang.Integer".equals(this.realType)) {
            match = PrimitiveDataType.representsInteger(value2);
        } else if ("boolean".equals(this.realType) || "java.lang.Boolean".endsWith(this.realType)) {
            match = PrimitiveDataType.representsBoolean(value2);
        } else if ("char".equals(this.realType) || "java.lang.Character".equals(this.realType)) {
            PrimitiveDataType.representsChar(value2);
        }
        if (!match) {
            String msg = "This value: " + value2 + " is not of type: " + this.realType + ", validation failed";
            throw new ValidationException(msg);
        }
    }

    private static boolean representsBoolean(String value2) {
        boolean isBoolean = "true".equalsIgnoreCase(value2) || "false".equalsIgnoreCase(value2);
        return isBoolean;
    }

    private static boolean representsChar(String value2) {
        return value2.length() == 1;
    }

    private static boolean representsInteger(String value2) {
        try {
            Integer.parseInt(value2);
            return true;
        }
        catch (NumberFormatException ne) {
            return false;
        }
    }
}

