/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.MultiException;
import org.jvnet.hk2.config.InjectionResolver;
import org.jvnet.hk2.config.UnsatisfiedDependencyException;
import org.jvnet.hk2.config.WorkManager;

public class InjectionManager {
    public void inject(Object component, InjectionResolver ... targets) {
        this.syncDoInject(component, component.getClass(), targets);
    }

    public void inject(Object component, ExecutorService es, InjectionResolver ... targets) {
        try {
            if (null == es) {
                this.syncDoInject(component, component.getClass(), targets);
            } else {
                this.syncDoInject(component, component.getClass(), targets);
            }
        }
        catch (Exception e) {
            if (e instanceof MultiException) {
                throw (MultiException)e;
            }
            throw new MultiException(e);
        }
    }

    public void inject(Object component, Class type, InjectionResolver ... targets) {
        this.syncDoInject(component, type, targets);
    }

    protected void syncDoInject(Object component, Class type, InjectionResolver ... targets) {
        assert (component != null);
        try {
            for (Class currentClass = type; currentClass != null && Object.class != currentClass; currentClass = currentClass.getSuperclass()) {
                for (Field field2 : currentClass.getDeclaredFields()) {
                    Annotation nonOptionalAnnotation = null;
                    boolean injected = false;
                    for (InjectionResolver target : targets) {
                        Object inject = field2.getAnnotation(target.type);
                        if (inject == null) continue;
                        Type genericType = field2.getGenericType();
                        Class<?> fieldType = field2.getType();
                        try {
                            Object value2 = target.getValue(component, field2, genericType, fieldType);
                            if (value2 != null) {
                                field2.setAccessible(true);
                                field2.set(component, value2);
                                injected = true;
                                break;
                            }
                            if (target.isOptional(field2, inject)) continue;
                            nonOptionalAnnotation = (Annotation)inject;
                        }
                        catch (MultiException e) {
                            this.error_injectionException(target, (Annotation)inject, field2, e);
                        }
                        catch (IllegalAccessException e) {
                            this.error_injectionException(target, (Annotation)inject, field2, e);
                        }
                        catch (RuntimeException e) {
                            this.error_injectionException(target, (Annotation)inject, field2, e);
                        }
                        catch (Exception ex) {
                            this.error_injectionException(target, (Annotation)inject, field2, ex);
                        }
                    }
                    if (injected || nonOptionalAnnotation == null) continue;
                    throw new UnsatisfiedDependencyException(field2, nonOptionalAnnotation);
                }
                for (AccessibleObject accessibleObject : currentClass.getDeclaredMethods()) {
                    for (InjectionResolver target : targets) {
                        Object inject = ((Method)accessibleObject).getAnnotation(target.type);
                        if (inject == null) continue;
                        Method setter2 = target.getSetterMethod((Method)accessibleObject, inject);
                        if (setter2.getReturnType() != Void.TYPE) {
                            if (Collection.class.isAssignableFrom(setter2.getReturnType())) {
                                this.injectCollection(component, setter2, target.getValue(component, accessibleObject, null, setter2.getReturnType()));
                                continue;
                            }
                            this.error_InjectMethodIsNotVoid((Method)accessibleObject);
                        }
                        Class<?>[] paramTypes = setter2.getParameterTypes();
                        Type[] genericParamTypes = setter2.getGenericParameterTypes();
                        if (!this.allowInjection((Method)accessibleObject, paramTypes)) continue;
                        try {
                            if (1 == paramTypes.length) {
                                Object value3 = target.getValue(component, accessibleObject, genericParamTypes[0], paramTypes[0]);
                                if (value3 != null) {
                                    setter2.setAccessible(true);
                                    setter2.invoke(component, value3);
                                    continue;
                                }
                                if (target.isOptional(accessibleObject, inject)) continue;
                                throw new UnsatisfiedDependencyException(accessibleObject, (Annotation)inject);
                            }
                            setter2.setAccessible(true);
                            Type[] gparamType = setter2.getGenericParameterTypes();
                            Object[] params = new Object[paramTypes.length];
                            for (int i = 0; i < paramTypes.length; ++i) {
                                Object value4 = target.getValue(component, accessibleObject, gparamType[i], paramTypes[i]);
                                if (value4 != null) {
                                    params[i] = value4;
                                    continue;
                                }
                                if (target.isOptional(accessibleObject, inject)) continue;
                                throw new UnsatisfiedDependencyException(accessibleObject, (Annotation)inject);
                            }
                            setter2.invoke(component, params);
                        }
                        catch (MultiException e) {
                            this.error_injectionException(target, (Annotation)inject, setter2, e);
                        }
                        catch (IllegalAccessException e) {
                            this.error_injectionException(target, (Annotation)inject, setter2, e);
                        }
                        catch (InvocationTargetException e) {
                            this.error_injectionException(target, (Annotation)inject, setter2, e);
                        }
                        catch (RuntimeException e) {
                            this.error_injectionException(target, (Annotation)inject, setter2, e);
                        }
                    }
                }
            }
        }
        catch (LinkageError e) {
            final Class cls = type;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    LinkageError x = new LinkageError("injection failed on " + cls + " from " + cls.getClassLoader());
                    x.initCause(e);
                    throw x;
                }
            });
        }
    }

    protected void error_injectionException(InjectionResolver target, Annotation inject, AnnotatedElement injectionPoint, Throwable e) {
        Logger.getAnonymousLogger().log(Level.FINE, "** Injection failure **", e);
        if (UnsatisfiedDependencyException.class.isInstance(e)) {
            if (injectionPoint == ((UnsatisfiedDependencyException)e).getUnsatisfiedElement()) {
                throw (UnsatisfiedDependencyException)e;
            }
            if (target.isOptional(injectionPoint, inject)) {
                return;
            }
            throw new UnsatisfiedDependencyException(injectionPoint, inject, e);
        }
        if (null != e.getCause() && InvocationTargetException.class.isInstance(e)) {
            e = e.getCause();
        }
        throw new MultiException(e);
    }

    protected boolean allowInjection(Method method, Class<?>[] paramTypes) {
        return true;
    }

    protected void error_InjectMethodIsNotVoid(Method method) {
        throw new MultiException(new IllegalStateException("Injection failed on " + method.getName() + " : setter method is not declared with a void return type"));
    }

    private void injectCollection(Object component, Method method, Object value2) {
        if (value2 == null) {
            return;
        }
        Collection c = (Collection)Collection.class.cast(value2);
        Collection target = null;
        try {
            target = (Collection)Collection.class.cast(method.invoke(component, new Object[0]));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
        target.addAll(c);
    }

    protected class InjectMethod
    implements Runnable {
        private final InjectContext ic;
        private final Method method;
        private final Annotation inject;
        private final InjectionResolver target;

        public InjectMethod(InjectClass iClass, Method method, Annotation inject, InjectionResolver target) {
            this.ic = iClass.ic;
            this.method = method;
            this.inject = inject;
            this.target = target;
        }

        @Override
        public void run() {
            Class<?>[] paramTypes;
            Method setter2 = this.target.getSetterMethod(this.method, this.inject);
            if (Void.TYPE != setter2.getReturnType()) {
                if (Collection.class.isAssignableFrom(setter2.getReturnType())) {
                    InjectionManager.this.injectCollection(this.ic.component, setter2, this.target.getValue(this.ic.component, this.method, null, setter2.getReturnType()));
                } else {
                    InjectionManager.this.error_InjectMethodIsNotVoid(this.method);
                }
            }
            if (InjectionManager.this.allowInjection(this.method, paramTypes = setter2.getParameterTypes())) {
                try {
                    if (1 == paramTypes.length) {
                        Object value2 = this.target.getValue(this.ic.component, this.method, null, paramTypes[0]);
                        if (value2 != null) {
                            setter2.setAccessible(true);
                            setter2.invoke(this.ic.component, value2);
                        } else if (!this.target.isOptional(this.method, this.inject)) {
                            throw new UnsatisfiedDependencyException(this.method, this.inject);
                        }
                    } else {
                        setter2.setAccessible(true);
                        Type[] gparamType = setter2.getGenericParameterTypes();
                        Object[] params = new Object[paramTypes.length];
                        for (int i = 0; i < paramTypes.length; ++i) {
                            Object value3 = this.target.getValue(this.ic.component, this.method, gparamType[i], paramTypes[i]);
                            if (value3 != null) {
                                params[i] = value3;
                                continue;
                            }
                            if (this.target.isOptional(this.method, this.inject)) continue;
                            throw new UnsatisfiedDependencyException(this.method, this.inject);
                        }
                        setter2.invoke(this.ic.component, params);
                    }
                }
                catch (MultiException e) {
                    InjectionManager.this.error_injectionException(this.target, this.inject, setter2, e);
                }
                catch (IllegalAccessException e) {
                    InjectionManager.this.error_injectionException(this.target, this.inject, setter2, e);
                }
                catch (InvocationTargetException e) {
                    InjectionManager.this.error_injectionException(this.target, this.inject, setter2, e);
                }
                catch (RuntimeException e) {
                    InjectionManager.this.error_injectionException(this.target, this.inject, setter2, e);
                }
            }
        }
    }

    protected class InjectField
    implements Runnable {
        private final InjectContext ic;
        private final Field field;
        private final Annotation inject;
        private final InjectionResolver target;

        public InjectField(InjectClass iClass, Field field2, Annotation inject, InjectionResolver target) {
            this.ic = iClass.ic;
            this.field = field2;
            this.inject = inject;
            this.target = target;
        }

        @Override
        public void run() {
            Type genericType = this.field.getGenericType();
            Class<?> fieldType = this.field.getType();
            try {
                Object value2 = this.target.getValue(this.ic.component, this.field, genericType, fieldType);
                if (value2 != null) {
                    this.field.setAccessible(true);
                    this.field.set(this.ic.component, value2);
                } else if (!this.target.isOptional(this.field, this.inject)) {
                    throw new UnsatisfiedDependencyException(this.field, this.inject);
                }
            }
            catch (MultiException e) {
                InjectionManager.this.error_injectionException(this.target, this.inject, this.field, e);
            }
            catch (IllegalAccessException e) {
                InjectionManager.this.error_injectionException(this.target, this.inject, this.field, e);
            }
            catch (RuntimeException e) {
                InjectionManager.this.error_injectionException(this.target, this.inject, this.field, e);
            }
        }
    }

    protected class InjectMethods
    implements Runnable {
        private final InjectClass iClass;

        public InjectMethods(InjectClass iClass) {
            this.iClass = iClass;
        }

        @Override
        public void run() {
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            for (Method method : this.iClass.classType.getDeclaredMethods()) {
                for (InjectionResolver target : ((InjectClass)this.iClass).ic.targets) {
                    Object inject = method.getAnnotation(target.type);
                    if (inject == null) continue;
                    tasks.add(new InjectMethod(this.iClass, method, (Annotation)inject, target));
                }
            }
            WorkManager wm = new WorkManager(((InjectClass)this.iClass).ic.es, tasks.size());
            wm.executeAll(tasks);
            wm.awaitCompletion();
        }
    }

    protected class InjectFields
    implements Runnable {
        private final InjectClass iClass;

        public InjectFields(InjectClass iClass) {
            this.iClass = iClass;
        }

        @Override
        public void run() {
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            for (Field field2 : this.iClass.classType.getDeclaredFields()) {
                for (InjectionResolver target : ((InjectClass)this.iClass).ic.targets) {
                    Object inject = field2.getAnnotation(target.type);
                    if (inject == null) continue;
                    tasks.add(new InjectField(this.iClass, field2, (Annotation)inject, target));
                }
            }
            WorkManager wm = new WorkManager(((InjectClass)this.iClass).ic.es, tasks.size());
            wm.executeAll(tasks);
            wm.awaitCompletion();
        }
    }

    protected class InjectClass
    implements Runnable {
        private final Class<?> classType;
        private final InjectContext ic;

        public InjectClass(Class type, InjectContext ic) {
            this.classType = type;
            this.ic = ic;
        }

        @Override
        public void run() {
            WorkManager wm = new WorkManager(this.ic.es, 2);
            wm.execute(new InjectMethods(this));
            wm.execute(new InjectFields(this));
            wm.awaitCompletion();
            new InjectMethods(this).run();
            new InjectFields(this).run();
        }
    }

    protected static class InjectContext {
        public final Object component;
        public final Class<?> type;
        public final ExecutorService es;
        public final InjectionResolver[] targets;

        public InjectContext(Object component, Class type, ExecutorService es, InjectionResolver[] targets) {
            assert (null != component);
            this.component = component;
            this.type = type;
            this.es = es;
            this.targets = targets;
        }
    }
}

