/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.text.MessageFormat;
import org.jboss.logging.Logger;

final class Slf4jLogger
extends Logger {
    private static final long serialVersionUID = 8685757928087758380L;
    private final org.slf4j.Logger logger;

    Slf4jLogger(String name, org.slf4j.Logger logger2) {
        super(name);
        this.logger = logger2;
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        if (level != null) {
            switch (level) {
                case FATAL: {
                    return this.logger.isErrorEnabled();
                }
                case ERROR: {
                    return this.logger.isErrorEnabled();
                }
                case WARN: {
                    return this.logger.isWarnEnabled();
                }
                case INFO: {
                    return this.logger.isInfoEnabled();
                }
                case DEBUG: {
                    return this.logger.isDebugEnabled();
                }
                case TRACE: {
                    return this.logger.isTraceEnabled();
                }
            }
        }
        return true;
    }

    @Override
    protected void doLog(Logger.Level level, String loggerClassName, Object message, Object[] parameters, Throwable thrown) {
        if (this.isEnabled(level)) {
            try {
                String text2 = parameters == null || parameters.length == 0 ? String.valueOf(message) : MessageFormat.format(String.valueOf(message), parameters);
                switch (level) {
                    case FATAL: 
                    case ERROR: {
                        this.logger.error(text2, thrown);
                        return;
                    }
                    case WARN: {
                        this.logger.warn(text2, thrown);
                        return;
                    }
                    case INFO: {
                        this.logger.info(text2, thrown);
                        return;
                    }
                    case DEBUG: {
                        this.logger.debug(text2, thrown);
                        return;
                    }
                    case TRACE: {
                        this.logger.trace(text2, thrown);
                        return;
                    }
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doLogf(Logger.Level level, String loggerClassName, String format2, Object[] parameters, Throwable thrown) {
        if (this.isEnabled(level)) {
            try {
                String text2 = parameters == null ? String.format(format2, new Object[0]) : String.format(format2, parameters);
                switch (level) {
                    case FATAL: 
                    case ERROR: {
                        this.logger.error(text2, thrown);
                        return;
                    }
                    case WARN: {
                        this.logger.warn(text2, thrown);
                        return;
                    }
                    case INFO: {
                        this.logger.info(text2, thrown);
                        return;
                    }
                    case DEBUG: {
                        this.logger.debug(text2, thrown);
                        return;
                    }
                    case TRACE: {
                        this.logger.trace(text2, thrown);
                        return;
                    }
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
    }
}

