/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.xml;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.validation.ConstraintValidator;
import javax.validation.ParameterNameProvider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;
import org.hibernate.validator.internal.util.privilegedactions.NewJaxbContext;
import org.hibernate.validator.internal.util.privilegedactions.Unmarshal;
import org.hibernate.validator.internal.xml.BeanType;
import org.hibernate.validator.internal.xml.ClassLoadingHelper;
import org.hibernate.validator.internal.xml.ConstrainedExecutableBuilder;
import org.hibernate.validator.internal.xml.ConstrainedFieldBuilder;
import org.hibernate.validator.internal.xml.ConstrainedGetterBuilder;
import org.hibernate.validator.internal.xml.ConstrainedTypeBuilder;
import org.hibernate.validator.internal.xml.ConstraintDefinitionType;
import org.hibernate.validator.internal.xml.ConstraintMappingsType;
import org.hibernate.validator.internal.xml.ValidatedByType;
import org.hibernate.validator.internal.xml.XmlParserHelper;

public class XmlMappingParser {
    private static final Log log = LoggerFactory.make();
    private final Set<Class<?>> processedClasses = CollectionHelper.newHashSet();
    private final ConstraintHelper constraintHelper;
    private final AnnotationProcessingOptionsImpl annotationProcessingOptions;
    private final Map<Class<?>, List<Class<?>>> defaultSequences;
    private final Map<Class<?>, Set<ConstrainedElement>> constrainedElements;
    private final XmlParserHelper xmlParserHelper;
    private final ParameterNameProvider parameterNameProvider;
    private static final ConcurrentMap<String, String> SCHEMAS_BY_VERSION = new ConcurrentHashMap<String, String>(2, 0.75f, 1);

    public XmlMappingParser(ConstraintHelper constraintHelper, ParameterNameProvider parameterNameProvider) {
        this.constraintHelper = constraintHelper;
        this.annotationProcessingOptions = new AnnotationProcessingOptionsImpl();
        this.defaultSequences = CollectionHelper.newHashMap();
        this.constrainedElements = CollectionHelper.newHashMap();
        this.xmlParserHelper = new XmlParserHelper();
        this.parameterNameProvider = parameterNameProvider;
    }

    public final void parse(Set<InputStream> mappingStreams) {
        try {
            JAXBContext jc = this.run(NewJaxbContext.action(ConstraintMappingsType.class));
            HashSet<String> alreadyProcessedConstraintDefinitions = CollectionHelper.newHashSet();
            for (InputStream in : mappingStreams) {
                String schemaVersion = this.xmlParserHelper.getSchemaVersion("constraint mapping file", in);
                String schemaResourceName = this.getSchemaResourceName(schemaVersion);
                Schema schema = this.xmlParserHelper.getSchema(schemaResourceName);
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                unmarshaller.setSchema(schema);
                ConstraintMappingsType mapping = this.getValidationConfig(in, unmarshaller);
                String defaultPackage = mapping.getDefaultPackage();
                this.parseConstraintDefinitions(mapping.getConstraintDefinition(), defaultPackage, alreadyProcessedConstraintDefinitions);
                for (BeanType bean : mapping.getBean()) {
                    Class<?> beanClass = ClassLoadingHelper.loadClass(bean.getClazz(), defaultPackage);
                    this.checkClassHasNotBeenProcessed(this.processedClasses, beanClass);
                    this.annotationProcessingOptions.ignoreAnnotationConstraintForClass(beanClass, bean.getIgnoreAnnotations());
                    ConstrainedType constrainedType = ConstrainedTypeBuilder.buildConstrainedType(bean.getClassType(), beanClass, defaultPackage, this.constraintHelper, this.annotationProcessingOptions, this.defaultSequences);
                    if (constrainedType != null) {
                        this.addConstrainedElement(beanClass, constrainedType);
                    }
                    Set<ConstrainedField> constrainedFields = ConstrainedFieldBuilder.buildConstrainedFields(bean.getField(), beanClass, defaultPackage, this.constraintHelper, this.annotationProcessingOptions);
                    this.addConstrainedElements(beanClass, constrainedFields);
                    Set<ConstrainedExecutable> constrainedGetters = ConstrainedGetterBuilder.buildConstrainedGetters(bean.getGetter(), beanClass, defaultPackage, this.constraintHelper, this.annotationProcessingOptions);
                    this.addConstrainedElements(beanClass, constrainedGetters);
                    Set<ConstrainedExecutable> constrainedConstructors = ConstrainedExecutableBuilder.buildConstructorConstrainedExecutable(bean.getConstructor(), beanClass, defaultPackage, this.parameterNameProvider, this.constraintHelper, this.annotationProcessingOptions);
                    this.addConstrainedElements(beanClass, constrainedConstructors);
                    Set<ConstrainedExecutable> constrainedMethods = ConstrainedExecutableBuilder.buildMethodConstrainedExecutable(bean.getMethod(), beanClass, defaultPackage, this.parameterNameProvider, this.constraintHelper, this.annotationProcessingOptions);
                    this.addConstrainedElements(beanClass, constrainedMethods);
                    this.processedClasses.add(beanClass);
                }
            }
        }
        catch (JAXBException e) {
            throw log.getErrorParsingMappingFileException((Exception)((Object)e));
        }
    }

    public final Set<Class<?>> getXmlConfiguredClasses() {
        return this.processedClasses;
    }

    public final AnnotationProcessingOptions getAnnotationProcessingOptions() {
        return this.annotationProcessingOptions;
    }

    public final Set<ConstrainedElement> getConstrainedElementsForClass(Class<?> beanClass) {
        if (this.constrainedElements.containsKey(beanClass)) {
            return this.constrainedElements.get(beanClass);
        }
        return Collections.emptySet();
    }

    public final List<Class<?>> getDefaultSequenceForClass(Class<?> beanClass) {
        return this.defaultSequences.get(beanClass);
    }

    private void parseConstraintDefinitions(List<ConstraintDefinitionType> constraintDefinitionList, String defaultPackage, Set<String> alreadyProcessedConstraintDefinitions) {
        for (ConstraintDefinitionType constraintDefinition : constraintDefinitionList) {
            String annotationClassName = constraintDefinition.getAnnotation();
            if (alreadyProcessedConstraintDefinitions.contains(annotationClassName)) {
                throw log.getOverridingConstraintDefinitionsInMultipleMappingFilesException(annotationClassName);
            }
            alreadyProcessedConstraintDefinitions.add(annotationClassName);
            Class<?> clazz = ClassLoadingHelper.loadClass(annotationClassName, defaultPackage);
            if (!clazz.isAnnotation()) {
                throw log.getIsNotAnAnnotationException(annotationClassName);
            }
            Class<?> annotationClass = clazz;
            this.addValidatorDefinitions(annotationClass, constraintDefinition.getValidatedBy());
        }
    }

    private <A extends Annotation> void addValidatorDefinitions(Class<A> annotationClass, ValidatedByType validatedByType) {
        ArrayList constraintValidatorClasses = CollectionHelper.newArrayList();
        for (String validatorClassName : validatedByType.getValue()) {
            Class validatorClass = (Class)this.run(LoadClass.action(validatorClassName, this.getClass()));
            if (!ConstraintValidator.class.isAssignableFrom(validatorClass)) {
                throw log.getIsNotAConstraintValidatorClassException(validatorClass);
            }
            constraintValidatorClasses.add(validatorClass);
        }
        this.constraintHelper.putValidatorClasses(annotationClass, constraintValidatorClasses, Boolean.TRUE.equals(validatedByType.getIncludeExistingValidators()));
    }

    private void checkClassHasNotBeenProcessed(Set<Class<?>> processedClasses, Class<?> beanClass) {
        if (processedClasses.contains(beanClass)) {
            throw log.getBeanClassHasAlreadyBeConfiguredInXmlException(beanClass.getName());
        }
    }

    private void addConstrainedElement(Class<?> beanClass, ConstrainedElement constrainedElement) {
        if (this.constrainedElements.containsKey(beanClass)) {
            this.constrainedElements.get(beanClass).add(constrainedElement);
        } else {
            HashSet tmpList = CollectionHelper.newHashSet();
            tmpList.add(constrainedElement);
            this.constrainedElements.put(beanClass, tmpList);
        }
    }

    private void addConstrainedElements(Class<?> beanClass, Set<? extends ConstrainedElement> newConstrainedElements) {
        if (this.constrainedElements.containsKey(beanClass)) {
            Set<ConstrainedElement> existingConstrainedElements = this.constrainedElements.get(beanClass);
            for (ConstrainedElement constrainedElement : newConstrainedElements) {
                for (ConstrainedElement existingConstrainedElement : existingConstrainedElements) {
                    if (existingConstrainedElement.getLocation().getMember() == null || !existingConstrainedElement.getLocation().getMember().equals(constrainedElement.getLocation().getMember())) continue;
                    ConstraintLocation location = constrainedElement.getLocation();
                    throw log.getConstrainedElementConfiguredMultipleTimesException(location.getMember().toString());
                }
                existingConstrainedElements.add(constrainedElement);
            }
        } else {
            HashSet tmpSet = CollectionHelper.newHashSet();
            tmpSet.addAll(newConstrainedElements);
            this.constrainedElements.put(beanClass, tmpSet);
        }
    }

    private ConstraintMappingsType getValidationConfig(InputStream in, Unmarshaller unmarshaller) {
        ConstraintMappingsType constraintMappings;
        try {
            boolean markSupported = in.markSupported();
            if (markSupported) {
                in.mark(Integer.MAX_VALUE);
            }
            StreamSource stream = new StreamSource(new CloseIgnoringInputStream(in));
            JAXBElement root2 = (JAXBElement)this.run(Unmarshal.action(unmarshaller, stream, ConstraintMappingsType.class));
            constraintMappings = (ConstraintMappingsType)root2.getValue();
            if (markSupported) {
                try {
                    in.reset();
                }
                catch (IOException e) {
                    log.debug("Unable to reset input stream.");
                }
            }
        }
        catch (Exception e) {
            throw log.getErrorParsingMappingFileException(e);
        }
        return constraintMappings;
    }

    private String getSchemaResourceName(String schemaVersion) {
        String schemaResource = (String)SCHEMAS_BY_VERSION.get(schemaVersion);
        if (schemaResource == null) {
            throw log.getUnsupportedSchemaVersionException("constraint mapping file", schemaVersion);
        }
        return schemaResource;
    }

    private <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private <T> T run(PrivilegedExceptionAction<T> action) throws JAXBException {
        try {
            return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        }
        catch (JAXBException e) {
            throw e;
        }
        catch (Exception e) {
            throw log.getErrorParsingMappingFileException(e);
        }
    }

    static {
        SCHEMAS_BY_VERSION.put("1.0", "META-INF/validation-mapping-1.0.xsd");
        SCHEMAS_BY_VERSION.put("1.1", "META-INF/validation-mapping-1.1.xsd");
    }

    private static class CloseIgnoringInputStream
    extends FilterInputStream {
        public CloseIgnoringInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

