/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.annotationfactory;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class AnnotationDescriptor<T extends Annotation> {
    private final Class<T> type;
    private final Map<String, Object> elements = new HashMap<String, Object>();

    public static <S extends Annotation> AnnotationDescriptor<S> getInstance(Class<S> annotationType) {
        return new AnnotationDescriptor<S>(annotationType);
    }

    public static <S extends Annotation> AnnotationDescriptor<S> getInstance(Class<S> annotationType, Map<String, Object> elements) {
        return new AnnotationDescriptor<S>(annotationType, elements);
    }

    public AnnotationDescriptor(Class<T> annotationType) {
        this.type = annotationType;
    }

    public AnnotationDescriptor(Class<T> annotationType, Map<String, Object> elements) {
        this.type = annotationType;
        for (Map.Entry<String, Object> entry2 : elements.entrySet()) {
            this.elements.put(entry2.getKey(), entry2.getValue());
        }
    }

    public void setValue(String elementName, Object value2) {
        this.elements.put(elementName, value2);
    }

    public Object valueOf(String elementName) {
        return this.elements.get(elementName);
    }

    public boolean containsElement(String elementName) {
        return this.elements.containsKey(elementName);
    }

    public int numberOfElements() {
        return this.elements.size();
    }

    public Map<String, Object> getElements() {
        return new HashMap<String, Object>(this.elements);
    }

    public Class<T> type() {
        return this.type;
    }
}

