/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.util.Arrays;

public class StringHelper {
    private StringHelper() {
    }

    public static String join(Object[] array, String separator) {
        return array != null ? StringHelper.join(Arrays.asList(array), separator) : null;
    }

    public static String join(Iterable<?> iterable, String separator) {
        if (iterable == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object object : iterable) {
            if (!isFirst) {
                sb.append(separator);
            } else {
                isFirst = false;
            }
            sb.append(object);
        }
        return sb.toString();
    }

    public static String decapitalize(String string2) {
        if (string2 == null || string2.isEmpty() || StringHelper.startsWithSeveralUpperCaseLetters(string2)) {
            return string2;
        }
        return string2.substring(0, 1).toLowerCase() + string2.substring(1);
    }

    private static boolean startsWithSeveralUpperCaseLetters(String string2) {
        return string2.length() > 1 && Character.isUpperCase(string2.charAt(0)) && Character.isUpperCase(string2.charAt(1));
    }
}

