/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.provider;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.GroupSequence;
import javax.validation.ParameterNameProvider;
import javax.validation.Valid;
import javax.validation.groups.ConvertGroup;
import org.hibernate.validator.group.GroupSequenceProvider;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptionsImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ConcurrentReferenceHashMap;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.classhierarchy.ClassHierarchyHelper;
import org.hibernate.validator.internal.util.classhierarchy.Filter;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredConstructors;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredFields;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethods;
import org.hibernate.validator.internal.util.privilegedactions.GetMethods;
import org.hibernate.validator.internal.util.privilegedactions.NewInstance;
import org.hibernate.validator.spi.group.DefaultGroupSequenceProvider;
import org.hibernate.validator.valuehandling.UnwrapValidatedValue;

public class AnnotationMetaDataProvider
implements MetaDataProvider {
    private static final Log log = LoggerFactory.make();
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final ConstraintHelper constraintHelper;
    private final ConcurrentReferenceHashMap<Class<?>, BeanConfiguration<?>> configuredBeans;
    private final AnnotationProcessingOptions annotationProcessingOptions;
    private final ParameterNameProvider parameterNameProvider;

    public AnnotationMetaDataProvider(ConstraintHelper constraintHelper, ParameterNameProvider parameterNameProvider, AnnotationProcessingOptions annotationProcessingOptions) {
        this.constraintHelper = constraintHelper;
        this.parameterNameProvider = parameterNameProvider;
        this.annotationProcessingOptions = annotationProcessingOptions;
        this.configuredBeans = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    }

    @Override
    public AnnotationProcessingOptions getAnnotationProcessingOptions() {
        return new AnnotationProcessingOptionsImpl();
    }

    @Override
    public <T> List<BeanConfiguration<? super T>> getBeanConfigurationForHierarchy(Class<T> beanClass) {
        ArrayList<BeanConfiguration<T>> configurations = CollectionHelper.newArrayList();
        for (Class<T> hierarchyClass : ClassHierarchyHelper.getHierarchy(beanClass, new Filter[0])) {
            BeanConfiguration<T> configuration = this.getBeanConfiguration(hierarchyClass);
            if (configuration == null) continue;
            configurations.add(configuration);
        }
        return configurations;
    }

    private <T> BeanConfiguration<T> getBeanConfiguration(Class<T> beanClass) {
        BeanConfiguration<Object> configuration = this.configuredBeans.get(beanClass);
        if (configuration != null) {
            return configuration;
        }
        configuration = this.retrieveBeanConfiguration(beanClass);
        this.configuredBeans.put(beanClass, configuration);
        return configuration;
    }

    private <T> BeanConfiguration<T> retrieveBeanConfiguration(Class<T> beanClass) {
        Set<ConstrainedElement> constrainedElements = this.getFieldMetaData(beanClass);
        constrainedElements.addAll(this.getMethodMetaData(beanClass));
        constrainedElements.addAll(this.getConstructorMetaData(beanClass));
        Set<MetaConstraint<?>> classLevelConstraints = this.getClassLevelConstraints(beanClass);
        if (!classLevelConstraints.isEmpty()) {
            ConstrainedType classLevelMetaData = new ConstrainedType(ConfigurationSource.ANNOTATION, ConstraintLocation.forClass(beanClass), classLevelConstraints);
            constrainedElements.add(classLevelMetaData);
        }
        return new BeanConfiguration<T>(ConfigurationSource.ANNOTATION, beanClass, constrainedElements, this.getDefaultGroupSequence(beanClass), this.getDefaultGroupSequenceProvider(beanClass));
    }

    private List<Class<?>> getDefaultGroupSequence(Class<?> beanClass) {
        GroupSequence groupSequenceAnnotation = beanClass.getAnnotation(GroupSequence.class);
        return groupSequenceAnnotation != null ? Arrays.asList(groupSequenceAnnotation.value()) : null;
    }

    private <T> DefaultGroupSequenceProvider<? super T> getDefaultGroupSequenceProvider(Class<T> beanClass) {
        GroupSequenceProvider groupSequenceProviderAnnotation = beanClass.getAnnotation(GroupSequenceProvider.class);
        if (groupSequenceProviderAnnotation != null) {
            Class<? extends DefaultGroupSequenceProvider<?>> providerClass = groupSequenceProviderAnnotation.value();
            return this.newGroupSequenceProviderClassInstance(beanClass, providerClass);
        }
        return null;
    }

    private <T> DefaultGroupSequenceProvider<? super T> newGroupSequenceProviderClassInstance(Class<T> beanClass, Class<? extends DefaultGroupSequenceProvider<? super T>> providerClass) {
        Method[] providerMethods;
        for (Method method : providerMethods = this.run(GetMethods.action(providerClass))) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (!"getValidationGroups".equals(method.getName()) || method.isBridge() || paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(beanClass)) continue;
            return this.run(NewInstance.action(providerClass, "the default group sequence provider"));
        }
        throw log.getWrongDefaultGroupSequenceProviderTypeException(beanClass.getName());
    }

    private Set<MetaConstraint<?>> getClassLevelConstraints(Class<?> clazz) {
        if (this.annotationProcessingOptions.areClassLevelConstraintsIgnoredFor(clazz)) {
            return Collections.emptySet();
        }
        HashSet<MetaConstraint<?>> classLevelConstraints = CollectionHelper.newHashSet();
        List<ConstraintDescriptorImpl<?>> classMetaData = this.findClassLevelConstraints(clazz);
        for (ConstraintDescriptorImpl<?> constraintDescription : classMetaData) {
            classLevelConstraints.add(this.createMetaConstraint(clazz, constraintDescription));
        }
        return classLevelConstraints;
    }

    private Set<ConstrainedElement> getFieldMetaData(Class<?> beanClass) {
        HashSet<ConstrainedElement> propertyMetaData = CollectionHelper.newHashSet();
        for (Field field2 : this.run(GetDeclaredFields.action(beanClass))) {
            if (Modifier.isStatic(field2.getModifiers()) || this.annotationProcessingOptions.areMemberConstraintsIgnoredFor(field2) || field2.isSynthetic()) continue;
            propertyMetaData.add(this.findPropertyMetaData(field2));
        }
        return propertyMetaData;
    }

    private ConstrainedField findPropertyMetaData(Field field2) {
        Set<MetaConstraint<?>> constraints = this.convertToMetaConstraints(this.findConstraints(field2, ElementType.FIELD), field2);
        Map<Class<?>, Class<?>> groupConversions = this.getGroupConversions(field2.getAnnotation(ConvertGroup.class), field2.getAnnotation(ConvertGroup.List.class));
        boolean isCascading = field2.isAnnotationPresent(Valid.class);
        boolean requiresUnwrapping = field2.isAnnotationPresent(UnwrapValidatedValue.class);
        return new ConstrainedField(ConfigurationSource.ANNOTATION, ConstraintLocation.forProperty(field2), constraints, groupConversions, isCascading, requiresUnwrapping);
    }

    private Set<MetaConstraint<?>> convertToMetaConstraints(List<ConstraintDescriptorImpl<?>> constraintDescriptors, Field field2) {
        HashSet<MetaConstraint<?>> constraints = CollectionHelper.newHashSet();
        for (ConstraintDescriptorImpl<?> constraintDescription : constraintDescriptors) {
            constraints.add(this.createMetaConstraint(field2, constraintDescription));
        }
        return constraints;
    }

    private Set<ConstrainedExecutable> getConstructorMetaData(Class<?> clazz) {
        List<ExecutableElement> declaredConstructors = ExecutableElement.forConstructors(this.run(GetDeclaredConstructors.action(clazz)));
        return this.getMetaData(declaredConstructors);
    }

    private Set<ConstrainedExecutable> getMethodMetaData(Class<?> clazz) {
        List<ExecutableElement> declaredMethods = ExecutableElement.forMethods(this.run(GetDeclaredMethods.action(clazz)));
        return this.getMetaData(declaredMethods);
    }

    private Set<ConstrainedExecutable> getMetaData(List<ExecutableElement> executableElements) {
        HashSet<ConstrainedExecutable> executableMetaData = CollectionHelper.newHashSet();
        for (ExecutableElement executable : executableElements) {
            Member member = executable.getMember();
            if (Modifier.isStatic(member.getModifiers()) || member.isSynthetic()) continue;
            executableMetaData.add(this.findExecutableMetaData(executable));
        }
        return executableMetaData;
    }

    private ConstrainedExecutable findExecutableMetaData(ExecutableElement executable) {
        boolean isCascading;
        Map<Class<?>, Class<?>> groupConversions;
        Set<MetaConstraint<?>> returnValueConstraints;
        List<ConstrainedParameter> parameterConstraints = this.getParameterMetaData(executable);
        AccessibleObject member = executable.getAccessibleObject();
        Map<ConstraintDescriptorImpl.ConstraintType, List<ConstraintDescriptorImpl<?>>> executableConstraints = CollectionHelper.partition(this.findConstraints(executable.getMember(), executable.getElementType()), this.byType());
        Set<Object> crossParameterConstraints = this.annotationProcessingOptions.areCrossParameterConstraintsIgnoredFor(executable.getMember()) ? Collections.emptySet() : this.convertToMetaConstraints(executableConstraints.get((Object)ConstraintDescriptorImpl.ConstraintType.CROSS_PARAMETER), executable);
        boolean requiresUnwrapping = false;
        if (this.annotationProcessingOptions.areReturnValueConstraintsIgnoredFor(executable.getMember())) {
            returnValueConstraints = Collections.emptySet();
            groupConversions = Collections.emptyMap();
            isCascading = false;
        } else {
            requiresUnwrapping = executable.getAccessibleObject().isAnnotationPresent(UnwrapValidatedValue.class);
            returnValueConstraints = this.convertToMetaConstraints(executableConstraints.get((Object)ConstraintDescriptorImpl.ConstraintType.GENERIC), executable);
            groupConversions = this.getGroupConversions(member.getAnnotation(ConvertGroup.class), member.getAnnotation(ConvertGroup.List.class));
            isCascading = executable.getAccessibleObject().isAnnotationPresent(Valid.class);
        }
        return new ConstrainedExecutable(ConfigurationSource.ANNOTATION, ConstraintLocation.forReturnValue(executable), parameterConstraints, crossParameterConstraints, returnValueConstraints, groupConversions, isCascading, requiresUnwrapping);
    }

    private Set<MetaConstraint<?>> convertToMetaConstraints(List<ConstraintDescriptorImpl<?>> constraintsDescriptors, ExecutableElement executable) {
        if (constraintsDescriptors == null) {
            return Collections.emptySet();
        }
        HashSet<MetaConstraint<?>> constraints = CollectionHelper.newHashSet();
        for (ConstraintDescriptorImpl<?> constraintDescriptor : constraintsDescriptors) {
            constraints.add(constraintDescriptor.getConstraintType() == ConstraintDescriptorImpl.ConstraintType.GENERIC ? this.createReturnValueMetaConstraint(executable, constraintDescriptor) : this.createCrossParameterMetaConstraint(executable, constraintDescriptor));
        }
        return constraints;
    }

    private List<ConstrainedParameter> getParameterMetaData(ExecutableElement executable) {
        ArrayList<ConstrainedParameter> metaData = CollectionHelper.newArrayList();
        List<String> parameterNames = executable.getParameterNames(this.parameterNameProvider);
        int i = 0;
        for (Annotation[] parameterAnnotations : executable.getParameterAnnotations()) {
            boolean parameterIsCascading = false;
            String parameterName = parameterNames.get(i);
            HashSet<MetaConstraint<?>> parameterConstraints = CollectionHelper.newHashSet();
            ConvertGroup groupConversion = null;
            ConvertGroup.List groupConversionList = null;
            boolean requiresUnwrapping = false;
            if (this.annotationProcessingOptions.areParameterConstraintsIgnoredFor(executable.getMember(), i)) {
                metaData.add(new ConstrainedParameter(ConfigurationSource.ANNOTATION, ConstraintLocation.forParameter(executable, i), ReflectionHelper.typeOf(executable, i), i, parameterName, parameterConstraints, this.getGroupConversions(groupConversion, groupConversionList), false, false));
                ++i;
                continue;
            }
            for (Annotation parameterAnnotation : parameterAnnotations) {
                if (parameterAnnotation.annotationType().equals(Valid.class)) {
                    parameterIsCascading = true;
                } else if (parameterAnnotation.annotationType().equals(ConvertGroup.class)) {
                    groupConversion = (ConvertGroup)parameterAnnotation;
                } else if (parameterAnnotation.annotationType().equals(ConvertGroup.List.class)) {
                    groupConversionList = (ConvertGroup.List)parameterAnnotation;
                } else if (parameterAnnotation.annotationType().equals(UnwrapValidatedValue.class)) {
                    requiresUnwrapping = true;
                }
                List<ConstraintDescriptorImpl<?>> constraints = this.findConstraintAnnotations(executable.getMember(), parameterAnnotation, ElementType.PARAMETER);
                for (ConstraintDescriptorImpl<?> constraintDescriptorImpl : constraints) {
                    parameterConstraints.add(this.createParameterMetaConstraint(executable, i, constraintDescriptorImpl));
                }
            }
            metaData.add(new ConstrainedParameter(ConfigurationSource.ANNOTATION, ConstraintLocation.forParameter(executable, i), ReflectionHelper.typeOf(executable, i), i, parameterName, parameterConstraints, this.getGroupConversions(groupConversion, groupConversionList), parameterIsCascading, requiresUnwrapping));
            ++i;
        }
        return metaData;
    }

    private List<ConstraintDescriptorImpl<?>> findConstraints(Member member, ElementType type) {
        ArrayList<ConstraintDescriptorImpl<?>> metaData = CollectionHelper.newArrayList();
        for (Annotation annotation : ((AccessibleObject)((Object)member)).getDeclaredAnnotations()) {
            metaData.addAll(this.findConstraintAnnotations(member, annotation, type));
        }
        return metaData;
    }

    private List<ConstraintDescriptorImpl<?>> findClassLevelConstraints(Class<?> beanClass) {
        ArrayList<ConstraintDescriptorImpl<?>> metaData = CollectionHelper.newArrayList();
        for (Annotation annotation : beanClass.getDeclaredAnnotations()) {
            metaData.addAll(this.findConstraintAnnotations(null, annotation, ElementType.TYPE));
        }
        return metaData;
    }

    private <A extends Annotation> List<ConstraintDescriptorImpl<?>> findConstraintAnnotations(Member member, A annotation, ElementType type) {
        ArrayList<ConstraintDescriptorImpl<?>> constraintDescriptors = CollectionHelper.newArrayList();
        ArrayList<Annotation> constraints = CollectionHelper.newArrayList();
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (this.constraintHelper.isConstraintAnnotation(annotationType)) {
            constraints.add(annotation);
        } else if (this.constraintHelper.isMultiValueConstraint(annotationType)) {
            constraints.addAll(this.constraintHelper.getConstraintsFromMultiValueConstraint(annotation));
        }
        for (Annotation constraint : constraints) {
            ConstraintDescriptorImpl<Annotation> constraintDescriptor = this.buildConstraintDescriptor(member, constraint, type);
            constraintDescriptors.add(constraintDescriptor);
        }
        return constraintDescriptors;
    }

    private Map<Class<?>, Class<?>> getGroupConversions(ConvertGroup groupConversion, ConvertGroup.List groupConversionList) {
        HashMap<Class<?>, Class<?>> groupConversions = CollectionHelper.newHashMap();
        if (groupConversion != null) {
            groupConversions.put(groupConversion.from(), groupConversion.to());
        }
        if (groupConversionList != null) {
            for (ConvertGroup conversion : groupConversionList.value()) {
                if (groupConversions.containsKey(conversion.from())) {
                    throw log.getMultipleGroupConversionsForSameSourceException(conversion.from(), CollectionHelper.asSet((Class)groupConversions.get(conversion.from()), conversion.to()));
                }
                groupConversions.put(conversion.from(), conversion.to());
            }
        }
        return groupConversions;
    }

    private CollectionHelper.Partitioner<ConstraintDescriptorImpl.ConstraintType, ConstraintDescriptorImpl<?>> byType() {
        return new CollectionHelper.Partitioner<ConstraintDescriptorImpl.ConstraintType, ConstraintDescriptorImpl<?>>(){

            @Override
            public ConstraintDescriptorImpl.ConstraintType getPartition(ConstraintDescriptorImpl<?> v) {
                return v.getConstraintType();
            }
        };
    }

    private <A extends Annotation> MetaConstraint<?> createMetaConstraint(Class<?> declaringClass, ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<A>(descriptor, ConstraintLocation.forClass(declaringClass));
    }

    private <A extends Annotation> MetaConstraint<?> createMetaConstraint(Member member, ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<A>(descriptor, ConstraintLocation.forProperty(member));
    }

    private <A extends Annotation> MetaConstraint<A> createParameterMetaConstraint(ExecutableElement member, int parameterIndex, ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<A>(descriptor, ConstraintLocation.forParameter(member, parameterIndex));
    }

    private <A extends Annotation> MetaConstraint<A> createReturnValueMetaConstraint(ExecutableElement member, ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<A>(descriptor, ConstraintLocation.forReturnValue(member));
    }

    private <A extends Annotation> MetaConstraint<A> createCrossParameterMetaConstraint(ExecutableElement member, ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<A>(descriptor, ConstraintLocation.forCrossParameter(member));
    }

    private <A extends Annotation> ConstraintDescriptorImpl<A> buildConstraintDescriptor(Member member, A annotation, ElementType type) {
        return new ConstraintDescriptorImpl<A>(this.constraintHelper, member, annotation, type);
    }

    private <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

