/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Min;

public class MinValidatorForNumber
implements ConstraintValidator<Min, Number> {
    private long minValue;

    @Override
    public void initialize(Min minValue) {
        this.minValue = minValue.value();
    }

    @Override
    public boolean isValid(Number value2, ConstraintValidatorContext constraintValidatorContext) {
        if (value2 == null) {
            return true;
        }
        if (value2 instanceof BigDecimal) {
            return ((BigDecimal)value2).compareTo(BigDecimal.valueOf(this.minValue)) != -1;
        }
        if (value2 instanceof BigInteger) {
            return ((BigInteger)value2).compareTo(BigInteger.valueOf(this.minValue)) != -1;
        }
        long longValue = value2.longValue();
        return longValue >= this.minValue;
    }
}

