/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMin;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class DecimalMinValidatorForNumber
implements ConstraintValidator<DecimalMin, Number> {
    private static final Log log = LoggerFactory.make();
    private BigDecimal minValue;
    private boolean inclusive;

    @Override
    public void initialize(DecimalMin minValue) {
        try {
            this.minValue = new BigDecimal(minValue.value());
        }
        catch (NumberFormatException nfe) {
            throw log.getInvalidBigDecimalFormatException(minValue.value(), nfe);
        }
        this.inclusive = minValue.inclusive();
    }

    @Override
    public boolean isValid(Number value2, ConstraintValidatorContext constraintValidatorContext) {
        int comparisonResult;
        if (value2 == null) {
            return true;
        }
        if (value2 instanceof BigDecimal) {
            comparisonResult = ((BigDecimal)value2).compareTo(this.minValue);
        } else if (value2 instanceof BigInteger) {
            comparisonResult = new BigDecimal((BigInteger)value2).compareTo(this.minValue);
        }
        comparisonResult = value2 instanceof Long ? BigDecimal.valueOf(value2.longValue()).compareTo(this.minValue) : BigDecimal.valueOf(value2.doubleValue()).compareTo(this.minValue);
        return this.inclusive ? comparisonResult >= 0 : comparisonResult > 0;
    }
}

