/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.glassfish.jersey.server.internal.monitoring.AbstractSlidingWindowTimeReservoir;
import org.glassfish.jersey.server.internal.monitoring.AggregatedValueObject;
import org.glassfish.jersey.server.internal.monitoring.AggregatingTrimmer;
import org.glassfish.jersey.server.internal.monitoring.UniformTimeSimpleSnapshot;
import org.glassfish.jersey.server.internal.monitoring.UniformTimeSnapshot;

class AggregatedSlidingWindowTimeReservoir
extends AbstractSlidingWindowTimeReservoir<AggregatedValueObject> {
    private final AggregatingTrimmer notifier;

    public AggregatedSlidingWindowTimeReservoir(long window, TimeUnit windowUnit, long startTime, TimeUnit startTimeUnit, AggregatingTrimmer notifier) {
        super(window, windowUnit, startTime, startTimeUnit);
        this.notifier = notifier;
        notifier.register(this);
    }

    @Override
    protected UniformTimeSnapshot snapshot(Collection<AggregatedValueObject> values, long timeInterval, TimeUnit timeIntervalUnit, long time, TimeUnit timeUnit) {
        UniformTimeSnapshot notTrimmedMeasurementsSnapshot = this.notifier.getTimeReservoirNotifier().getSnapshot(time, timeUnit);
        AggregatedValueObject[] arrayValues = new AggregatedValueObject[values.size()];
        arrayValues = values.toArray(arrayValues);
        long min2 = Long.MAX_VALUE;
        long max2 = Long.MIN_VALUE;
        long count2 = 0L;
        double meanNumerator = 0.0;
        for (AggregatedValueObject value2 : arrayValues) {
            min2 = Math.min(min2, value2.getMin());
            max2 = Math.max(max2, value2.getMax());
            count2 += value2.getCount();
            meanNumerator += (double)value2.getCount() * value2.getMean();
        }
        if (notTrimmedMeasurementsSnapshot.size() > 0L) {
            min2 = Math.min(min2, notTrimmedMeasurementsSnapshot.getMin());
            max2 = Math.max(max2, notTrimmedMeasurementsSnapshot.getMax());
            count2 += notTrimmedMeasurementsSnapshot.size();
            meanNumerator += (double)notTrimmedMeasurementsSnapshot.size() * notTrimmedMeasurementsSnapshot.getMean();
        }
        if (count2 == 0L) {
            return new UniformTimeSimpleSnapshot(0L, 0L, 0.0, 0L, timeInterval, timeIntervalUnit);
        }
        return new UniformTimeSimpleSnapshot(max2, min2, meanNumerator / (double)count2, count2, timeInterval, timeIntervalUnit);
    }
}

