/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import javax.ws.rs.core.CacheControl;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.Utils;
import org.glassfish.jersey.spi.HeaderDelegateProvider;

@Singleton
public final class CacheControlProvider
implements HeaderDelegateProvider<CacheControl> {
    private static final Pattern WHITESPACE = Pattern.compile("\\s");
    private static final Pattern COMMA_SEPARATED_LIST = Pattern.compile("[\\s]*,[\\s]*");

    @Override
    public boolean supports(Class<?> type) {
        return type == CacheControl.class;
    }

    @Override
    public String toString(CacheControl header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.CACHE_CONTROL_IS_NULL());
        StringBuilder b = new StringBuilder();
        if (header.isPrivate()) {
            this.appendQuotedWithSeparator(b, "private", this.buildListValue(header.getPrivateFields()));
        }
        if (header.isNoCache()) {
            this.appendQuotedWithSeparator(b, "no-cache", this.buildListValue(header.getNoCacheFields()));
        }
        if (header.isNoStore()) {
            this.appendWithSeparator(b, "no-store");
        }
        if (header.isNoTransform()) {
            this.appendWithSeparator(b, "no-transform");
        }
        if (header.isMustRevalidate()) {
            this.appendWithSeparator(b, "must-revalidate");
        }
        if (header.isProxyRevalidate()) {
            this.appendWithSeparator(b, "proxy-revalidate");
        }
        if (header.getMaxAge() != -1) {
            this.appendWithSeparator(b, "max-age", header.getMaxAge());
        }
        if (header.getSMaxAge() != -1) {
            this.appendWithSeparator(b, "s-maxage", header.getSMaxAge());
        }
        for (Map.Entry<String, String> e : header.getCacheExtension().entrySet()) {
            this.appendWithSeparator(b, e.getKey(), this.quoteIfWhitespace(e.getValue()));
        }
        return b.toString();
    }

    private void readFieldNames(List<String> fieldNames, HttpHeaderReader reader) throws ParseException {
        if (!reader.hasNextSeparator('=', false)) {
            return;
        }
        reader.nextSeparator('=');
        fieldNames.addAll(Arrays.asList(COMMA_SEPARATED_LIST.split(reader.nextQuotedString())));
    }

    private int readIntValue(HttpHeaderReader reader, String directiveName) throws ParseException {
        reader.nextSeparator('=');
        int index2 = reader.getIndex();
        try {
            return Integer.parseInt(reader.nextToken().toString());
        }
        catch (NumberFormatException nfe) {
            ParseException pe = new ParseException("Error parsing integer value for " + directiveName + " directive", index2);
            pe.initCause(nfe);
            throw pe;
        }
    }

    private void readDirective(CacheControl cacheControl, HttpHeaderReader reader) throws ParseException {
        String directiveName = reader.nextToken().toString().toLowerCase();
        if ("private".equals(directiveName)) {
            cacheControl.setPrivate(true);
            this.readFieldNames(cacheControl.getPrivateFields(), reader);
        } else if ("public".equals(directiveName)) {
            cacheControl.getCacheExtension().put(directiveName, null);
        } else if ("no-cache".equals(directiveName)) {
            cacheControl.setNoCache(true);
            this.readFieldNames(cacheControl.getNoCacheFields(), reader);
        } else if ("no-store".equals(directiveName)) {
            cacheControl.setNoStore(true);
        } else if ("no-transform".equals(directiveName)) {
            cacheControl.setNoTransform(true);
        } else if ("must-revalidate".equals(directiveName)) {
            cacheControl.setMustRevalidate(true);
        } else if ("proxy-revalidate".equals(directiveName)) {
            cacheControl.setProxyRevalidate(true);
        } else if ("max-age".equals(directiveName)) {
            cacheControl.setMaxAge(this.readIntValue(reader, directiveName));
        } else if ("s-maxage".equals(directiveName)) {
            cacheControl.setSMaxAge(this.readIntValue(reader, directiveName));
        } else {
            String value2 = null;
            if (reader.hasNextSeparator('=', false)) {
                reader.nextSeparator('=');
                value2 = reader.nextTokenOrQuotedString().toString();
            }
            cacheControl.getCacheExtension().put(directiveName, value2);
        }
    }

    @Override
    public CacheControl fromString(String header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.CACHE_CONTROL_IS_NULL());
        try {
            HttpHeaderReader reader = HttpHeaderReader.newInstance(header);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoTransform(false);
            while (reader.hasNext()) {
                this.readDirective(cacheControl, reader);
                if (!reader.hasNextSeparator(',', true)) continue;
                reader.nextSeparator(',');
            }
            return cacheControl;
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Error parsing cache control '" + header + "'", pe);
        }
    }

    private void appendWithSeparator(StringBuilder b, String field2) {
        if (b.length() > 0) {
            b.append(", ");
        }
        b.append(field2);
    }

    private void appendQuotedWithSeparator(StringBuilder b, String field2, String value2) {
        this.appendWithSeparator(b, field2);
        if (value2 != null && !value2.isEmpty()) {
            b.append("=\"");
            b.append(value2);
            b.append("\"");
        }
    }

    private void appendWithSeparator(StringBuilder b, String field2, String value2) {
        this.appendWithSeparator(b, field2);
        if (value2 != null && !value2.isEmpty()) {
            b.append("=");
            b.append(value2);
        }
    }

    private void appendWithSeparator(StringBuilder b, String field2, int value2) {
        this.appendWithSeparator(b, field2);
        b.append("=");
        b.append(value2);
    }

    private String buildListValue(List<String> values) {
        StringBuilder b = new StringBuilder();
        for (String value2 : values) {
            this.appendWithSeparator(b, value2);
        }
        return b.toString();
    }

    private String quoteIfWhitespace(String value2) {
        if (value2 == null) {
            return null;
        }
        Matcher m = WHITESPACE.matcher(value2);
        if (m.find()) {
            return "\"" + value2 + "\"";
        }
        return value2;
    }
}

