/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart.internal;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.media.multipart.Boundary;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.internal.LocalizationMessages;
import org.glassfish.jersey.message.MessageUtils;

@Singleton
@Produces(value={"multipart/*"})
public class MultiPartWriter
implements MessageBodyWriter<MultiPart> {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final Providers providers;

    public MultiPartWriter(@Context Providers providers) {
        this.providers = providers;
    }

    @Override
    public long getSize(MultiPart entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultiPart.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(MultiPart entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream stream) throws IOException, WebApplicationException {
        Object value2;
        if (entity.getBodyParts() == null || entity.getBodyParts().size() < 1) {
            throw new IllegalArgumentException(LocalizationMessages.MUST_SPECIFY_BODY_PART());
        }
        if (entity.getParent() == null && (value2 = headers.getFirst("MIME-Version")) == null) {
            headers.putSingle("MIME-Version", "1.0");
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, MessageUtils.getCharset(mediaType)));
        MediaType boundaryMediaType = Boundary.addBoundary(mediaType);
        if (boundaryMediaType != mediaType) {
            headers.putSingle("Content-Type", boundaryMediaType.toString());
        }
        String boundaryString = boundaryMediaType.getParameters().get("boundary");
        boolean isFirst = true;
        for (BodyPart bodyPart : entity.getBodyParts()) {
            MessageBodyWriter<?> bodyWriter;
            if (isFirst) {
                isFirst = false;
                writer.write("--");
            } else {
                writer.write("\r\n--");
            }
            writer.write(boundaryString);
            writer.write("\r\n");
            MediaType bodyMediaType = bodyPart.getMediaType();
            if (bodyMediaType == null) {
                throw new IllegalArgumentException(LocalizationMessages.MISSING_MEDIA_TYPE_OF_BODY_PART());
            }
            MultivaluedMap<String, Object> bodyHeaders = bodyPart.getHeaders();
            bodyHeaders.putSingle("Content-Type", bodyMediaType.toString());
            if (bodyHeaders.getFirst("Content-Disposition") == null && bodyPart.getContentDisposition() != null) {
                bodyHeaders.putSingle("Content-Disposition", bodyPart.getContentDisposition().toString());
            }
            for (Map.Entry entry2 : bodyHeaders.entrySet()) {
                writer.write((String)entry2.getKey());
                ((Writer)writer).write(58);
                boolean first = true;
                for (String value3 : (List)entry2.getValue()) {
                    if (first) {
                        ((Writer)writer).write(32);
                        first = false;
                    } else {
                        ((Writer)writer).write(44);
                    }
                    writer.write(value3);
                }
                writer.write("\r\n");
            }
            writer.write("\r\n");
            ((Writer)writer).flush();
            Object bodyEntity = bodyPart.getEntity();
            if (bodyEntity == null) {
                throw new IllegalArgumentException(LocalizationMessages.MISSING_ENTITY_OF_BODY_PART(bodyMediaType));
            }
            Class<Object> bodyClass = bodyEntity.getClass();
            if (bodyEntity instanceof BodyPartEntity) {
                bodyClass = InputStream.class;
                bodyEntity = ((BodyPartEntity)bodyEntity).getInputStream();
            }
            if ((bodyWriter = this.providers.getMessageBodyWriter(bodyClass, bodyClass, EMPTY_ANNOTATIONS, bodyMediaType)) == null) {
                throw new IllegalArgumentException(LocalizationMessages.NO_AVAILABLE_MBW(bodyClass, mediaType));
            }
            bodyWriter.writeTo(bodyEntity, bodyClass, bodyClass, EMPTY_ANNOTATIONS, bodyMediaType, bodyHeaders, stream);
        }
        writer.write("\r\n--");
        writer.write(boundaryString);
        writer.write("--\r\n");
        ((Writer)writer).flush();
    }
}

