/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;

public class StoredProcedureDefinition
extends DatabaseObjectDefinition {
    protected Vector variables;
    protected Vector statements = new Vector();
    protected Vector arguments;
    protected Vector argumentTypes;
    protected static final Integer IN = 1;
    protected static final Integer OUT = 2;
    protected static final Integer INOUT = 3;

    public StoredProcedureDefinition() {
        this.variables = new Vector();
        this.arguments = new Vector();
        this.argumentTypes = new Vector();
    }

    public void addArgument(String argumentName, Class type) {
        this.addArgument(new FieldDefinition(argumentName, type));
    }

    public void addArgument(String argumentName, Class type, int size2) {
        this.addArgument(new FieldDefinition(argumentName, type, size2));
    }

    public void addArgument(String argumentName, String typeName) {
        this.addArgument(new FieldDefinition(argumentName, typeName));
    }

    public void addArgument(FieldDefinition argument) {
        this.getArguments().addElement(argument);
        this.getArgumentTypes().addElement(IN);
    }

    public void addInOutputArgument(String argumentName, Class type) {
        this.addInOutputArgument(new FieldDefinition(argumentName, type));
    }

    public void addInOutputArgument(FieldDefinition argument) {
        this.getArguments().addElement(argument);
        this.getArgumentTypes().addElement(INOUT);
    }

    public void addOutputArgument(String argumentName, Class type) {
        this.addOutputArgument(new FieldDefinition(argumentName, type));
    }

    public void addOutputArgument(String argumentName, Class type, int size2) {
        this.addOutputArgument(new FieldDefinition(argumentName, type, size2));
    }

    public void addOutputArgument(String argumentName, String typeName) {
        this.addOutputArgument(new FieldDefinition(argumentName, typeName));
    }

    public void addOutputArgument(FieldDefinition argument) {
        this.getArguments().addElement(argument);
        this.getArgumentTypes().addElement(OUT);
    }

    public void addStatement(String statement) {
        this.getStatements().addElement(statement);
    }

    public void addVariable(String variableName, String typeName) {
        this.addVariable(new FieldDefinition(variableName, typeName));
    }

    public void addVariable(FieldDefinition variable) {
        this.getVariables().addElement(variable);
    }

    @Override
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            DatabasePlatform platform = session.getPlatform();
            writer.write(String.valueOf(this.getCreationHeader()) + this.getFullName());
            if (this.getArguments().size() > this.getFirstArgumentIndex() || platform.requiresProcedureBrackets()) {
                writer.write(" (");
            }
            writer.write("\n");
            int i = this.getFirstArgumentIndex();
            while (i < this.getArguments().size()) {
                writer.write("\t");
                FieldDefinition argument = (FieldDefinition)this.getArguments().elementAt(i);
                Integer argumentType = (Integer)this.getArgumentTypes().elementAt(i);
                if (argumentType == IN) {
                    this.printArgument(argument, writer, session);
                } else if (argumentType == OUT) {
                    this.printOutputArgument(argument, writer, session);
                } else if (argumentType == INOUT) {
                    this.printInOutputArgument(argument, writer, session);
                }
                if (i < this.getArguments().size() - 1) {
                    writer.write(",\n");
                }
                ++i;
            }
            if (this.getArguments().size() > this.getFirstArgumentIndex() || platform.requiresProcedureBrackets()) {
                writer.write(")");
            }
            this.printReturn(writer, session);
            writer.write(platform.getProcedureAsString());
            writer.write("\n");
            if (platform.shouldPrintStoredProcedureVariablesAfterBeginString()) {
                writer.write(platform.getProcedureBeginString());
                writer.write("\n");
            }
            if (!this.getVariables().isEmpty()) {
                writer.write("DECLARE\n");
            }
            Enumeration variablesEnum = this.getVariables().elements();
            while (variablesEnum.hasMoreElements()) {
                FieldDefinition field2 = (FieldDefinition)variablesEnum.nextElement();
                writer.write("\t");
                writer.write(field2.getName());
                writer.write(" ");
                writer.write(field2.getTypeName());
                writer.write(platform.getBatchDelimiterString());
                writer.write("\n");
            }
            if (!platform.shouldPrintStoredProcedureVariablesAfterBeginString()) {
                writer.write(platform.getProcedureBeginString());
                writer.write("\n");
            }
            Enumeration statementsEnum = this.getStatements().elements();
            while (statementsEnum.hasMoreElements()) {
                writer.write((String)statementsEnum.nextElement());
                writer.write(platform.getBatchDelimiterString());
                writer.write("\n");
            }
            writer.write(platform.getProcedureEndString());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write(String.valueOf(this.getDeletionHeader()) + this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Vector getArguments() {
        return this.arguments;
    }

    public String getCreationHeader() {
        return "CREATE PROCEDURE ";
    }

    public String getDeletionHeader() {
        return "DROP PROCEDURE ";
    }

    public int getFirstArgumentIndex() {
        return 0;
    }

    public Vector getArgumentTypes() {
        return this.argumentTypes;
    }

    public Vector getStatements() {
        return this.statements;
    }

    public Vector getVariables() {
        return this.variables;
    }

    protected void printArgument(FieldDefinition argument, Writer writer, AbstractSession session) throws IOException {
        DatabasePlatform platform = session.getPlatform();
        FieldTypeDefinition fieldType = StoredProcedureDefinition.getFieldTypeDefinition(session, argument.type, argument.typeName);
        writer.write(platform.getProcedureArgumentString());
        if (platform.shouldPrintInputTokenAtStart()) {
            writer.write(" ");
            writer.write(platform.getInputProcedureToken());
            writer.write(" ");
        }
        writer.write(argument.name);
        writer.write(" ");
        writer.write(fieldType.getName());
        if (fieldType.isSizeAllowed() && platform.allowsSizeInProcedureArguments() && (argument.size != 0 || fieldType.isSizeRequired())) {
            writer.write("(");
            if (argument.size == 0) {
                writer.write(Integer.toString(fieldType.getDefaultSize()));
            } else {
                writer.write(Integer.toString(argument.size));
            }
            if (argument.subSize != 0) {
                writer.write(",");
                writer.write(Integer.toString(argument.subSize));
            } else if (fieldType.getDefaultSubSize() != 0) {
                writer.write(",");
                writer.write(Integer.toString(fieldType.getDefaultSubSize()));
            }
            writer.write(")");
        }
    }

    protected void printInOutputArgument(FieldDefinition argument, Writer writer, AbstractSession session) throws ValidationException {
        try {
            DatabasePlatform platform = session.getPlatform();
            FieldTypeDefinition fieldType = StoredProcedureDefinition.getFieldTypeDefinition(session, argument.type, argument.typeName);
            writer.write(platform.getProcedureArgumentString());
            if (platform.shouldPrintOutputTokenAtStart()) {
                writer.write(" ");
                writer.write(platform.getCreationInOutputProcedureToken());
                writer.write(" ");
            }
            writer.write(argument.name);
            if (!platform.shouldPrintOutputTokenAtStart() && platform.shouldPrintOutputTokenBeforeType()) {
                writer.write(" ");
                writer.write(platform.getCreationInOutputProcedureToken());
            }
            writer.write(" ");
            writer.write(fieldType.getName());
            if (fieldType.isSizeAllowed() && platform.allowsSizeInProcedureArguments() && (argument.size != 0 || fieldType.isSizeRequired())) {
                writer.write("(");
                if (argument.size == 0) {
                    writer.write(Integer.toString(fieldType.getDefaultSize()));
                } else {
                    writer.write(Integer.toString(argument.size));
                }
                if (argument.subSize != 0) {
                    writer.write(",");
                    writer.write(Integer.toString(argument.subSize));
                } else if (fieldType.getDefaultSubSize() != 0) {
                    writer.write(",");
                    writer.write(Integer.toString(fieldType.getDefaultSubSize()));
                }
                writer.write(")");
            }
            if (!platform.shouldPrintOutputTokenAtStart() && !platform.shouldPrintOutputTokenBeforeType()) {
                writer.write(" ");
                writer.write(platform.getCreationInOutputProcedureToken());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    protected void printOutputArgument(FieldDefinition argument, Writer writer, AbstractSession session) throws ValidationException {
        try {
            DatabasePlatform platform = session.getPlatform();
            FieldTypeDefinition fieldType = StoredProcedureDefinition.getFieldTypeDefinition(session, argument.type, argument.typeName);
            writer.write(platform.getProcedureArgumentString());
            if (platform.shouldPrintOutputTokenAtStart()) {
                writer.write(" ");
                writer.write(platform.getCreationOutputProcedureToken());
                writer.write(" ");
            }
            writer.write(argument.name);
            if (!platform.shouldPrintOutputTokenAtStart() && platform.shouldPrintOutputTokenBeforeType()) {
                writer.write(" ");
                writer.write(platform.getCreationOutputProcedureToken());
            }
            writer.write(" ");
            writer.write(fieldType.getName());
            if (fieldType.isSizeAllowed() && platform.allowsSizeInProcedureArguments() && (argument.size != 0 || fieldType.isSizeRequired())) {
                writer.write("(");
                if (argument.size == 0) {
                    writer.write(Integer.toString(fieldType.getDefaultSize()));
                } else {
                    writer.write(Integer.toString(argument.size));
                }
                if (argument.subSize != 0) {
                    writer.write(",");
                    writer.write(Integer.toString(argument.subSize));
                } else if (fieldType.getDefaultSubSize() != 0) {
                    writer.write(",");
                    writer.write(Integer.toString(fieldType.getDefaultSubSize()));
                }
                writer.write(")");
            }
            if (!platform.shouldPrintOutputTokenAtStart() && !platform.shouldPrintOutputTokenBeforeType()) {
                writer.write(" ");
                writer.write(platform.getCreationOutputProcedureToken());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    protected void printReturn(Writer writer, AbstractSession session) throws ValidationException {
    }

    public void setArguments(Vector arguments) {
        this.arguments = arguments;
    }

    public void setStatements(Vector statements) {
        this.statements = statements;
    }

    public void setVariables(Vector variables) {
        this.variables = variables;
    }
}

