/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;

public class SessionManager {
    protected static boolean shouldUseSchemaValidation = true;
    protected static SessionManager manager;
    protected AbstractSession defaultSession;
    protected ConcurrentMap<String, Session> sessions = new ConcurrentHashMap<String, Session>(5);
    protected static boolean shouldPerformDTDValidation;
    private static final ConcurrentMap<String, SessionManager> managers;
    private String context;
    private static final Object[] lock;
    private static final ContextHelper ctxHelper;

    static {
        managers = new ConcurrentHashMap<String, SessionManager>(4, 0.9f, 1);
        lock = new Object[0];
        ctxHelper = ContextHelper.getContextHelper();
    }

    public static boolean shouldUseSchemaValidation() {
        return shouldUseSchemaValidation;
    }

    public static void setShouldUseSchemaValidation(boolean useSchemaValidation) {
        shouldUseSchemaValidation = useSchemaValidation;
    }

    public void addSession(Session session) {
        this.getSessions().put(session.getName(), session);
    }

    public void addSession(String sessionName, Session session) {
        session.setName(sessionName);
        this.getSessions().put(sessionName, session);
    }

    public Session getDefaultSession() {
        if (this.defaultSession == null) {
            this.defaultSession = this.getSession("default");
        }
        return this.defaultSession;
    }

    public void destroy() {
        if (this.context != null) {
            managers.remove(this.context);
        } else {
            AbstractSessionLog.getLog().log(6, "session_manager_no_partition");
        }
        this.context = null;
        manager = null;
    }

    public void destroySession(String sessionName) {
        Session session = (Session)this.getSessions().get(sessionName);
        if (session != null) {
            this.destroy(session);
        } else {
            this.logAndThrowException(6, ValidationException.noSessionRegisteredForName(sessionName));
        }
    }

    private void destroy(Session session) {
        try {
            if (session.isConnected()) {
                ((DatabaseSession)session).logout();
            }
        }
        catch (Throwable ignore) {
            AbstractSessionLog.getLog().logThrowable(6, "connection", ignore);
        }
        this.sessions.remove(session.getName());
        session = null;
    }

    public void destroyAllSessions() {
        Iterator toRemoveSessions = new ArrayList(this.getSessions().values()).iterator();
        while (toRemoveSessions.hasNext()) {
            this.destroy((Session)toRemoveSessions.next());
        }
    }

    public synchronized SessionConfigs getInternalMWConfigObjects(String resourceName, ClassLoader objectClassLoader) {
        return this.getInternalMWConfigObjects(resourceName, objectClassLoader, true);
    }

    public synchronized SessionConfigs getInternalMWConfigObjects(String resourceName, ClassLoader objectClassLoader, boolean validate2) {
        return new XMLSessionConfigLoader(resourceName).loadConfigsForMappingWorkbench(objectClassLoader, validate2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SessionManager getManager() {
        if (ctxHelper == null) {
            if (manager != null) return manager;
            Object[] objectArray = lock;
            synchronized (lock) {
                if (manager != null) return manager;
                manager = SessionManager.initializeManager();
                // ** MonitorExit[var0] (shouldn't be in output)
                return manager;
            }
        }
        String currentCtx = ctxHelper.getPartitionID();
        if (manager != null && currentCtx.equals(SessionManager.manager.context)) {
            return manager;
        }
        manager = (SessionManager)managers.get(currentCtx);
        if (manager != null) return manager;
        Object[] objectArray = lock;
        synchronized (lock) {
            if (manager != null) return manager;
            manager = SessionManager.initializeManager();
            SessionManager.manager.context = currentCtx;
            managers.put(SessionManager.manager.context, manager);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return manager;
        }
    }

    public static Collection<SessionManager> getAllManagers() {
        return managers.values();
    }

    protected static SessionManager initializeManager() {
        return new SessionManager();
    }

    public AbstractSession getSession(String sessionName) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, boolean shouldLoginSession) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setShouldLogin(shouldLoginSession);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, boolean shouldLoginSession, boolean shouldRefreshSession) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setShouldLogin(shouldLoginSession);
        loader.setShouldRefresh(shouldRefreshSession);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, Object objectBean) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        ClassLoader classLoader = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(objectBean.getClass()));
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getCause();
            }
        } else {
            classLoader = PrivilegedAccessHelper.getClassLoaderForClass(objectBean.getClass());
        }
        loader.setClassLoader(classLoader);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, String filename) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setResourceName(filename);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, String filename, ClassLoader classLoader) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setResourceName(filename);
        loader.setClassLoader(classLoader);
        loader.setShouldCheckClassLoader(true);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, ClassLoader objectClassLoader) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setClassLoader(objectClassLoader);
        loader.setShouldCheckClassLoader(true);
        return this.getSession(loader);
    }

    public AbstractSession getSession(XMLSessionConfigLoader loader, String sessionName, ClassLoader objectClassLoader) {
        if (loader == null) {
            loader = new XMLSessionConfigLoader();
        }
        loader.setSessionName(sessionName);
        loader.setClassLoader(objectClassLoader);
        loader.setShouldCheckClassLoader(true);
        return this.getSession(loader);
    }

    public AbstractSession getSession(XMLSessionConfigLoader loader, String sessionName, ClassLoader objectClassLoader, boolean shouldLoginSession, boolean shouldRefreshSession) {
        if (loader == null) {
            loader = new XMLSessionConfigLoader();
        }
        loader.setSessionName(sessionName);
        loader.setClassLoader(objectClassLoader);
        loader.setShouldLogin(shouldLoginSession);
        loader.setShouldRefresh(shouldRefreshSession);
        return this.getSession(loader);
    }

    public AbstractSession getSession(XMLSessionConfigLoader loader, String sessionName, ClassLoader objectClassLoader, boolean shouldLoginSession, boolean shouldRefreshSession, boolean shouldCheckClassLoader) {
        if (loader == null) {
            loader = new XMLSessionConfigLoader();
        }
        loader.setSessionName(sessionName);
        loader.setClassLoader(objectClassLoader);
        loader.setShouldLogin(shouldLoginSession);
        loader.setShouldRefresh(shouldRefreshSession);
        loader.setShouldCheckClassLoader(shouldCheckClassLoader);
        return this.getSession(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractSession getSession(XMLSessionConfigLoader loader) {
        SessionManager sessionManager;
        AbstractSession session = (AbstractSession)this.getSessions().get(loader.getSessionName());
        boolean shouldRefreshSession = loader.shouldRefresh();
        if (loader.shouldCheckClassLoader() && session != null && !session.getDatasourcePlatform().getConversionManager().getLoader().equals(loader.getClassLoader())) {
            shouldRefreshSession = true;
        }
        if (session == null || shouldRefreshSession) {
            sessionManager = this;
            synchronized (sessionManager) {
                session = (AbstractSession)this.getSessions().get(loader.getSessionName());
                if (loader.shouldCheckClassLoader() && session != null && !session.getDatasourcePlatform().getConversionManager().getLoader().equals(loader.getClassLoader())) {
                    shouldRefreshSession = true;
                }
                if (session == null || shouldRefreshSession) {
                    if (session != null) {
                        if (session.isDatabaseSession() && session.isConnected()) {
                            try {
                                ((DatabaseSession)((Object)session)).logout();
                            }
                            catch (Throwable ignore) {
                                AbstractSessionLog.getLog().logThrowable(6, "connection", ignore);
                            }
                        }
                        this.getSessions().remove(loader.getSessionName());
                    }
                    if (loader.load(this, loader.getClassLoader())) {
                        session = (AbstractSession)this.getSessions().get(loader.getSessionName());
                    }
                }
            }
        }
        if (session == null) {
            this.logAndThrowException(6, ValidationException.noSessionFound(loader.getSessionName(), loader.getResourcePath()));
        } else if (loader.shouldLogin() && !session.isConnected()) {
            sessionManager = this;
            synchronized (sessionManager) {
                if (loader.shouldLogin() && !session.isConnected()) {
                    ((DatabaseSession)((Object)session)).login();
                }
            }
        }
        return session;
    }

    private void logAndThrowException(int level, RuntimeException exception) throws RuntimeException {
        AbstractSessionLog.getLog().logThrowable(level, "connection", exception);
        throw exception;
    }

    public void setSessions(ConcurrentMap sessions) {
        this.sessions = sessions;
    }

    public ConcurrentMap<String, Session> getSessions() {
        return this.sessions;
    }

    public void setDefaultSession(Session defaultSession) {
        this.defaultSession = (AbstractSession)defaultSession;
        this.addSession("default", defaultSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void setManager(SessionManager theManager) {
        if (ctxHelper == null) {
            manager = theManager;
            return;
        }
        if (theManager.context == null) {
            Object[] objectArray = lock;
            // MONITORENTER : lock
            if (theManager.context == null) {
                theManager.context = ctxHelper.getPartitionID();
            }
            // MONITOREXIT : objectArray
        }
        managers.put(theManager.context, theManager);
    }

    private static class ContextHelper {
        private Object cicManagerInstance;
        private Method getCurrentCicMethod;
        private Method getPartitionIdMethod;
        private static final Class cicManagerClass = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedAction<Class>(){

            @Override
            public Class run() {
                return ContextHelper.getCicManagerClass(ContextHelper.CIC_MANAGER_RESOURCE_NAME, ContextHelper.CIC_MANAGER_CLASS_NAME);
            }
        }) : ContextHelper.getCicManagerClass("META-INF/services/weblogic.invocation.ComponentInvocationContextManager", "weblogic.invocation.ComponentInvocationContextManager");
        private static ContextHelper instance;
        private static final String CIC_MANAGER_RESOURCE_NAME = "META-INF/services/weblogic.invocation.ComponentInvocationContextManager";
        private static final String CIC_MANAGER_CLASS_NAME = "weblogic.invocation.ComponentInvocationContextManager";

        private static Class getCicManagerClass(String cicManagerResourceName, String cicManagerClassName) {
            try {
                if (SessionManager.class.getClassLoader().getResource(cicManagerResourceName) != null) {
                    return PrivilegedAccessHelper.getClassForName(cicManagerClassName);
                }
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        private ContextHelper(final Class managerClass, final String contextClassName) {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ContextHelper.this.initialize(managerClass, contextClassName);
                        return null;
                    }
                });
            } else {
                this.initialize(managerClass, contextClassName);
            }
        }

        private void initialize(Class managerClass, String contextClassName) {
            try {
                Method getInstance = PrivilegedAccessHelper.getDeclaredMethod(managerClass, "getInstance", new Class[0]);
                this.cicManagerInstance = PrivilegedAccessHelper.invokeMethod(getInstance, managerClass);
                this.getCurrentCicMethod = PrivilegedAccessHelper.getMethod(managerClass, "getCurrentComponentInvocationContext", new Class[0], true);
                Class cicClass = PrivilegedAccessHelper.getClassForName(contextClassName);
                this.getPartitionIdMethod = PrivilegedAccessHelper.getDeclaredMethod(cicClass, "getPartitionId", new Class[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                AbstractSessionLog.getLog().logThrowable(6, null, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static ContextHelper getContextHelper() {
            if (cicManagerClass == null) {
                return null;
            }
            if (instance != null) return instance;
            Class<ContextHelper> clazz = ContextHelper.class;
            synchronized (ContextHelper.class) {
                if (instance != null) return instance;
                instance = new ContextHelper(cicManagerClass, "weblogic.invocation.ComponentInvocationContext");
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        String getPartitionID() {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    return AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            try {
                                Object cicInstance = PrivilegedAccessHelper.invokeMethod(ContextHelper.this.getCurrentCicMethod, ContextHelper.this.cicManagerInstance);
                                return (String)PrivilegedAccessHelper.invokeMethod(ContextHelper.this.getPartitionIdMethod, cicInstance);
                            }
                            catch (IllegalAccessException | InvocationTargetException ex) {
                                AbstractSessionLog.getLog().logThrowable(6, null, ex);
                                return "UNKNOWN";
                            }
                        }
                    });
                }
                Object cicInstance = PrivilegedAccessHelper.invokeMethod(this.getCurrentCicMethod, this.cicManagerInstance);
                return (String)PrivilegedAccessHelper.invokeMethod(this.getPartitionIdMethod, cicInstance);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                AbstractSessionLog.getLog().logThrowable(6, null, ex);
                return "UNKNOWN";
            }
        }
    }
}

