/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;

public class QueryResultsCachePolicy
implements Serializable,
Cloneable {
    protected CacheInvalidationPolicy invalidationPolicy;
    protected int maximumResultSets;
    protected Class cacheType;
    protected boolean isNullIgnored;
    protected boolean invalidateOnChange;
    protected Set<Class> invalidationClasses;

    public QueryResultsCachePolicy() {
        this(new NoExpiryCacheInvalidationPolicy(), 100);
    }

    public QueryResultsCachePolicy(CacheInvalidationPolicy policy, int maximumResultSets) {
        this.invalidationPolicy = policy;
        this.maximumResultSets = maximumResultSets;
        this.cacheType = ClassConstants.CacheIdentityMap_Class;
        this.isNullIgnored = false;
        this.invalidateOnChange = true;
        this.invalidationClasses = new HashSet<Class>();
    }

    public QueryResultsCachePolicy clone() {
        try {
            QueryResultsCachePolicy clone2 = (QueryResultsCachePolicy)super.clone();
            clone2.invalidationClasses = new HashSet<Class>();
            return clone2;
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.toString());
        }
    }

    public Set<Class> getInvalidationClasses() {
        return this.invalidationClasses;
    }

    public void setInvalidationClasses(Set<Class> invalidationClasses) {
        this.invalidationClasses = invalidationClasses;
    }

    public boolean isNullIgnored() {
        return this.isNullIgnored;
    }

    public void setIsNullIgnored(boolean isNullIgnored) {
        this.isNullIgnored = isNullIgnored;
    }

    public boolean getInvalidateOnChange() {
        return this.invalidateOnChange;
    }

    public void setInvalidateOnChange(boolean invalidateOnChange) {
        this.invalidateOnChange = invalidateOnChange;
    }

    public Class getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(Class cacheType) {
        this.cacheType = cacheType;
    }

    public void useFullCache() {
        this.setCacheType(ClassConstants.FullIdentityMap_Class);
    }

    public void useSoftCache() {
        this.setCacheType(ClassConstants.SoftIdentityMap_Class);
    }

    public void useSoftLRUCache() {
        this.setCacheType(ClassConstants.SoftCacheWeakIdentityMap_Class);
    }

    public void useLRUCache() {
        this.setCacheType(ClassConstants.CacheIdentityMap_Class);
    }

    public QueryResultsCachePolicy(CacheInvalidationPolicy policy) {
        this(policy, 100);
    }

    public QueryResultsCachePolicy(int maximumResultSets) {
        this(new NoExpiryCacheInvalidationPolicy(), maximumResultSets);
    }

    public CacheInvalidationPolicy getCacheInvalidationPolicy() {
        return this.invalidationPolicy;
    }

    public void setCacheInvalidationPolicy(CacheInvalidationPolicy invalidationPolicy) {
        this.invalidationPolicy = invalidationPolicy;
    }

    public int getMaximumCachedResults() {
        return this.maximumResultSets;
    }

    public void setMaximumCachedResults(int maximumResultSets) {
        this.maximumResultSets = maximumResultSets;
    }
}

