/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml.jaxp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.validation.Schema;
import org.eclipse.persistence.platform.xml.DefaultErrorHandler;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JAXPParser
implements XMLParser {
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private DocumentBuilderFactory documentBuilderFactory;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private DocumentBuilder documentBuilder;
    private TransformerFactory transformerFactory;

    public JAXPParser() {
        this.errorHandler = DefaultErrorHandler.getInstance();
    }

    public JAXPParser(DocumentBuilderFactory documentBuilderFactory, ErrorHandler errorHandler) {
        this.documentBuilderFactory = documentBuilderFactory;
        this.errorHandler = errorHandler != null ? errorHandler : DefaultErrorHandler.getInstance();
    }

    public JAXPParser(Map<String, Boolean> parserFeatures) {
        this();
        try {
            if (parserFeatures != null) {
                for (Map.Entry<String, Boolean> entry2 : parserFeatures.entrySet()) {
                    this.documentBuilderFactory.setFeature(entry2.getKey(), entry2.getValue());
                }
            }
        }
        catch (Exception e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
    }

    private void loadDocumentBuilderFactory() {
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.setNamespaceAware(true);
        this.setWhitespacePreserving(false);
    }

    @Override
    public void setNamespaceAware(boolean isNamespaceAware) {
        if (this.documentBuilderFactory == null) {
            this.loadDocumentBuilderFactory();
        }
        this.documentBuilderFactory.setNamespaceAware(isNamespaceAware);
    }

    @Override
    public void setWhitespacePreserving(boolean isWhitespacePreserving) {
        if (this.documentBuilderFactory == null) {
            this.loadDocumentBuilderFactory();
        }
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(!isWhitespacePreserving);
    }

    @Override
    public int getValidationMode() {
        if (this.documentBuilderFactory == null) {
            this.loadDocumentBuilderFactory();
        }
        if (!this.documentBuilderFactory.isValidating()) {
            return 0;
        }
        try {
            if (this.documentBuilderFactory.getAttribute(SCHEMA_LANGUAGE) == null) {
                return 2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 2;
        }
        return 3;
    }

    @Override
    public void setValidationMode(int validationMode) {
        if (this.documentBuilderFactory == null) {
            this.loadDocumentBuilderFactory();
        }
        switch (validationMode) {
            case 0: {
                this.documentBuilderFactory.setValidating(false);
                return;
            }
            case 2: {
                this.documentBuilderFactory.setValidating(true);
                return;
            }
            case 3: {
                try {
                    this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
                    this.documentBuilderFactory.setValidating(true);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                return;
            }
        }
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void setXMLSchema(URL url) throws XMLPlatformException {
        if (url == null) {
            return;
        }
        if (this.documentBuilderFactory == null) {
            this.loadDocumentBuilderFactory();
        }
        try {
            this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
            this.documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, url.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            XMLPlatformException.xmlPlatformErrorResolvingXMLSchema(url, e);
        }
    }

    @Override
    public void setXMLSchema(Schema schema) throws XMLPlatformException {
        this.documentBuilderFactory.setSchema(schema);
    }

    @Override
    public Schema getXMLSchema() throws XMLPlatformException {
        return this.documentBuilderFactory.getSchema();
    }

    @Override
    public void setXMLSchemas(Object[] schemas) throws XMLPlatformException {
        if (schemas == null || schemas.length == 0) {
            return;
        }
        if (this.documentBuilderFactory == null) {
            this.loadDocumentBuilderFactory();
        }
        try {
            this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
            this.documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, schemas);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            XMLPlatformException.xmlPlatformErrorResolvingXMLSchemas(schemas, e);
        }
    }

    @Override
    public Document parse(InputSource inputSource) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(inputSource);
        }
        catch (SAXException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
        catch (IOException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
    }

    @Override
    public Document parse(File file) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(file);
        }
        catch (SAXParseException e) {
            throw XMLPlatformException.xmlPlatformSAXParseException(e);
        }
        catch (SAXException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
        catch (IOException e) {
            throw XMLPlatformException.xmlPlatformFileNotFoundException(file, e);
        }
    }

    @Override
    public Document parse(InputStream inputStream) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(inputStream);
        }
        catch (SAXParseException e) {
            throw XMLPlatformException.xmlPlatformSAXParseException(e);
        }
        catch (SAXException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
        catch (IOException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
    }

    @Override
    public Document parse(Reader reader) throws XMLPlatformException {
        InputSource inputSource = new InputSource(reader);
        return this.parse(inputSource);
    }

    @Override
    public Document parse(Source source) throws XMLPlatformException {
        try {
            if (this.transformerFactory == null) {
                this.transformerFactory = TransformerFactory.newInstance();
            }
            Transformer transformer = this.transformerFactory.newTransformer();
            SAXResult saxResult = new SAXResult();
            SAXDocumentBuilder builder = new SAXDocumentBuilder();
            saxResult.setHandler(builder);
            transformer.transform(source, saxResult);
            return builder.getDocument();
        }
        catch (TransformerException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
    }

    @Override
    public Document parse(URL url) throws XMLPlatformException {
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
        }
        catch (IOException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
        boolean hasThrownException = false;
        try {
            Document document2 = this.parse(inputStream);
            return document2;
        }
        catch (RuntimeException e) {
            hasThrownException = true;
            throw e;
        }
        finally {
            block11: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (hasThrownException) break block11;
                    throw XMLPlatformException.xmlPlatformParseException(e);
                }
            }
        }
    }

    private DocumentBuilder getDocumentBuilder() {
        try {
            if (this.documentBuilder == null) {
                if (this.documentBuilderFactory == null) {
                    this.loadDocumentBuilderFactory();
                }
                this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
                this.documentBuilder.setEntityResolver(this.entityResolver);
                this.documentBuilder.setErrorHandler(this.errorHandler);
            } else {
                this.documentBuilder.reset();
            }
            return this.documentBuilder;
        }
        catch (ParserConfigurationException e) {
            throw XMLPlatformException.xmlPlatformParseException(e);
        }
    }
}

