/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.was;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.server.JMXEnabledPlatform;
import org.eclipse.persistence.platform.server.was.WebSphere_6_1_Platform;
import org.eclipse.persistence.services.websphere.MBeanWebSphereRuntimeServices;
import org.eclipse.persistence.sessions.DatabaseSession;

public class WebSphere_7_Platform
extends WebSphere_6_1_Platform
implements JMXEnabledPlatform {
    public static final String SERVER_LOG_CLASS = "com.ibm.ws.jpa.container.eclipselink.logging.EclipseLinkLogger";

    static {
        APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX = "[app:";
        APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_POSTFIX = "]";
        APP_SERVER_CLASSLOADER_MODULE_EJB_SEARCH_STRING_PREFIX = ".jar!/";
        APP_SERVER_CLASSLOADER_MODULE_WAR_SEARCH_STRING_PREFIX = ".war!/";
        APP_SERVER_CLASSLOADER_MODULE_EJB_WAR_SEARCH_STRING_POSTFIX = "]";
    }

    public WebSphere_7_Platform(DatabaseSession newDatabaseSession) {
        super(newDatabaseSession);
        this.enableRuntimeServices();
        this.prepareServerSpecificServicesMBean();
    }

    @Override
    public SessionLog getServerLog() {
        return this.createSessionLog();
    }

    protected SessionLog createSessionLog() {
        SessionLog log2 = null;
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                log2 = AccessController.doPrivileged(new PrivilegedExceptionAction<SessionLog>(){

                    @Override
                    public SessionLog run() throws Exception {
                        Class cls = PrivilegedAccessHelper.getClassForName(WebSphere_7_Platform.SERVER_LOG_CLASS);
                        Constructor ctor = PrivilegedAccessHelper.getConstructorFor(cls, null, false);
                        return (SessionLog)ctor.newInstance(new Object[0]);
                    }
                });
            } else {
                Class cls = PrivilegedAccessHelper.getClassForName(SERVER_LOG_CLASS);
                Constructor ctor = PrivilegedAccessHelper.getConstructorFor(cls, null, false);
                log2 = (SessionLog)ctor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            log2 = super.getServerLog();
            log2.log(1, "Unable to create an instance of com.ibm.ws.jpa.container.eclipselink.logging.EclipseLinkLogger. Falling back to using default logger.", e);
        }
        return log2;
    }

    @Override
    public boolean isRuntimeServicesEnabledDefault() {
        return true;
    }

    @Override
    public void prepareServerSpecificServicesMBean() {
        if (this.shouldRegisterRuntimeBean) {
            this.setRuntimeServicesMBean(new MBeanWebSphereRuntimeServices(this.getDatabaseSession()));
        }
    }

    @Override
    public void serverSpecificRegisterMBean() {
        super.serverSpecificRegisterMBean();
        this.initializeApplicationNameAndModuleName();
    }
}

