/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import org.eclipse.persistence.internal.core.helper.CoreConversionManager;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.XMLUnmarshaller;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecordImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLRootRecord
extends UnmarshalRecordImpl {
    private Class targetClass;
    private StrBuffer characters;
    private boolean shouldReadChars;
    private int elementCount;
    private XMLUnmarshaller unmarshaller;

    public XMLRootRecord(Class cls, XMLUnmarshaller unmarshaller) {
        this.targetClass = cls;
        this.unmarshaller = unmarshaller;
        this.setSession((CoreAbstractSession)((Context)unmarshaller.getContext()).getSession());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.characters == null) {
            this.characters = new StrBuffer();
        }
        if (this.shouldReadChars) {
            this.characters.append(ch, start, length);
        }
    }

    @Override
    public void characters(CharSequence characters2) throws SAXException {
        if (characters2 != null) {
            String string2 = characters2.toString();
            this.characters(string2.toCharArray(), 0, string2.length());
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.shouldReadChars = false;
    }

    @Override
    public Object getCurrentObject() {
        Object xmlRoot = this.unmarshaller.createRoot();
        ((Root)xmlRoot).setLocalName(this.getLocalName());
        ((Root)xmlRoot).setNamespaceURI(this.getRootElementNamespaceUri());
        if (this.currentObject == null) {
            String val = null;
            if (this.characters != null) {
                val = this.characters.toString();
            }
            ((Root)xmlRoot).setObject(((CoreConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(val, this.targetClass));
        } else {
            ((Root)xmlRoot).setObject(this.currentObject);
        }
        return xmlRoot;
    }

    @Override
    public void startDocument() throws SAXException {
        this.characters = null;
        this.elementCount = 0;
        this.shouldReadChars = true;
    }

    @Override
    public void initializeRecord(Mapping selfRecordMapping) throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.getRootElementName() == null) {
            this.setRootElementName(qName);
            this.setLocalName(localName);
            this.setRootElementNamespaceUri(namespaceURI);
        }
        if ("".equals(localName)) {
            return;
        }
        ++this.elementCount;
        if (this.elementCount > 1) {
            this.shouldReadChars = false;
        }
    }
}

