/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.UnionField;
import org.eclipse.persistence.internal.oxm.record.AbstractUnmarshalRecord;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;

public class XMLUnionField
extends XMLField
implements UnionField<XMLConversionManager, NamespaceResolver> {
    private ArrayList schemaTypes = new ArrayList();

    public XMLUnionField() {
    }

    public XMLUnionField(String xPath) {
        super(xPath);
    }

    public ArrayList getSchemaTypes() {
        return this.schemaTypes;
    }

    public void setSchemaTypes(ArrayList value2) {
        this.schemaTypes = value2;
    }

    @Override
    public void addSchemaType(QName value2) {
        if (value2 != null) {
            if (this.schemaTypes == null) {
                this.schemaTypes = new ArrayList();
            }
            if (!this.contains(this.schemaTypes, value2)) {
                this.schemaTypes.add(value2);
            }
        }
    }

    @Override
    public QName getSchemaType() {
        if (this.schemaTypes != null) {
            return (QName)this.getSchemaTypes().get(0);
        }
        return null;
    }

    @Override
    public void setSchemaType(QName value2) {
        this.addSchemaType(value2);
    }

    private boolean contains(ArrayList types, QName value2) {
        for (QName type : types) {
            if (!type.equals(value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUnionField() {
        return true;
    }

    @Override
    public QName getSchemaTypeForValue(Object value2, CoreAbstractSession session) {
        if (this.leafElementType != null) {
            return this.leafElementType;
        }
        if (this.isTypedTextField()) {
            ConversionManager conversionManager = (ConversionManager)session.getDatasourcePlatform().getConversionManager();
            return this.getXMLType(value2.getClass(), conversionManager);
        }
        return this.getSingleValueToWriteForUnion(value2, session);
    }

    protected QName getSingleValueToWriteForUnion(Object value2, CoreAbstractSession session) {
        ArrayList schemaTypes = this.getSchemaTypes();
        QName schemaType = null;
        int i = 0;
        int schemaTypesSize = schemaTypes.size();
        while (i < schemaTypesSize) {
            block4: {
                QName nextQName = (QName)this.getSchemaTypes().get(i);
                try {
                    if (nextQName != null) {
                        ConversionManager conversionManager = (ConversionManager)session.getDatasourcePlatform().getConversionManager();
                        Class javaClass = this.getJavaClass(nextQName, conversionManager);
                        value2 = conversionManager.convertObject(value2, javaClass, nextQName);
                        schemaType = nextQName;
                        break;
                    }
                }
                catch (ConversionException conversionException) {
                    if (i != schemaTypes.size() - 1) break block4;
                    schemaType = nextQName;
                }
            }
            ++i;
        }
        return schemaType;
    }

    @Override
    public Object convertValueBasedOnSchemaType(Object value2, XMLConversionManager xmlConversionManager, AbstractUnmarshalRecord record) {
        Object convertedValue = value2;
        int i = 0;
        while (i < this.schemaTypes.size()) {
            block5: {
                QName nextQName = (QName)this.schemaTypes.get(i);
                try {
                    if (nextQName != null) {
                        if (XMLConstants.QNAME_QNAME.equals(nextQName)) {
                            xmlConversionManager.buildQNameFromString((String)value2, record);
                            break;
                        }
                        Class javaClass = this.getJavaClass(nextQName, xmlConversionManager);
                        convertedValue = xmlConversionManager.convertObject(value2, javaClass, nextQName);
                        break;
                    }
                }
                catch (ConversionException ce) {
                    if (i != this.schemaTypes.size() - 1) break block5;
                    throw ce;
                }
            }
            ++i;
        }
        return convertedValue;
    }

    @Override
    public Class getJavaClass(QName qname) {
        return this.getJavaClass(qname, XMLConversionManager.getDefaultXMLManager());
    }

    @Override
    public Class getJavaClass(QName qname, ConversionManager conversionManager) {
        Class theClass;
        if (this.userXMLTypes != null && (theClass = (Class)this.userXMLTypes.get(qname)) != null) {
            return theClass;
        }
        Class<?> javaClass = conversionManager.javaType(qname);
        return XMLConversionManager.getObjectClass(javaClass);
    }

    @Override
    public boolean isSchemaType(QName schemaType) {
        if (this.getSchemaTypes() == null || this.getSchemaTypes().size() == 0) {
            return false;
        }
        return this.contains(this.getSchemaTypes(), schemaType);
    }
}

