/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.oxm;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaClassInstanceOf;
import org.eclipse.persistence.jaxb.javamodel.JavaConstructor;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.jaxb.javamodel.oxm.OXMJavaConstructorImpl;
import org.eclipse.persistence.jaxb.javamodel.oxm.OXMJavaFieldImpl;
import org.eclipse.persistence.jaxb.javamodel.oxm.OXMJavaPackageImpl;
import org.eclipse.persistence.jaxb.xmlmodel.JavaAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElements;
import org.eclipse.persistence.jaxb.xmlmodel.XmlInverseReference;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlValue;

public class OXMJavaClassImpl
implements JavaClass {
    private JavaType javaType;
    private String javaName;
    private List<String> enumValues;
    private JavaModel javaModel;
    private static String EMPTY_STRING = "";
    private static String JAVA = "java";
    private static String DOT = ".";
    private static String JAVA_LANG_OBJECT = "java.lang.Object";
    private static String JAVA_UTIL_MAP = "java.util.Map";

    public OXMJavaClassImpl(JavaType aJavaType) {
        this.javaType = aJavaType;
    }

    public OXMJavaClassImpl(String aJavaTypeName) {
        this.javaName = aJavaTypeName;
    }

    public OXMJavaClassImpl(String aJavaTypeName, List<String> enumValues) {
        this.javaName = aJavaTypeName;
        this.enumValues = enumValues;
    }

    @Override
    public Collection<JavaClass> getActualTypeArguments() {
        Object jType = null;
        if (this.javaType != null) {
            jType = this.javaType;
        } else {
            try {
                Class jTypeClass = PrivilegedAccessHelper.getClassForName(this.javaName);
                jType = PrivilegedAccessHelper.newInstanceFromClass(jTypeClass);
            }
            catch (Exception exception) {
                return new ArrayList<JavaClass>();
            }
        }
        ArrayList<JavaClass> argCollection = new ArrayList<JavaClass>();
        if (jType instanceof ParameterizedType) {
            Type[] params;
            ParameterizedType pType = (ParameterizedType)jType;
            Type[] typeArray = params = pType.getActualTypeArguments();
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                if (type instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)type;
                    argCollection.add(this.javaModel.getClass(pt.getRawType().getClass()));
                } else if (type instanceof WildcardType) {
                    Type upperType;
                    Type[] upperTypes = ((WildcardType)type).getUpperBounds();
                    if (upperTypes.length > 0 && (upperType = upperTypes[0]) instanceof Class) {
                        argCollection.add(this.javaModel.getClass(upperType.getClass()));
                    }
                } else if (type instanceof Class) {
                    argCollection.add(this.javaModel.getClass(type.getClass()));
                } else if (type instanceof GenericArrayType) {
                    Class<?> genericTypeClass = (Class<?>)((GenericArrayType)type).getGenericComponentType();
                    genericTypeClass = Array.newInstance(genericTypeClass, 0).getClass();
                    argCollection.add(this.javaModel.getClass(genericTypeClass.getClass()));
                }
                ++n2;
            }
        }
        return argCollection;
    }

    @Override
    public JavaClass getComponentType() {
        return null;
    }

    @Override
    public JavaConstructor getConstructor(JavaClass[] parameterTypes) {
        return new OXMJavaConstructorImpl(this);
    }

    @Override
    public Collection<JavaConstructor> getConstructors() {
        ArrayList<JavaConstructor> constructors = new ArrayList<JavaConstructor>(1);
        constructors.add(new OXMJavaConstructorImpl(this));
        return constructors;
    }

    @Override
    public Collection<JavaClass> getDeclaredClasses() {
        return new ArrayList<JavaClass>();
    }

    @Override
    public JavaConstructor getDeclaredConstructor(JavaClass[] parameterTypes) {
        return new OXMJavaConstructorImpl(this);
    }

    @Override
    public Collection<JavaConstructor> getDeclaredConstructors() {
        ArrayList<JavaConstructor> constructors = new ArrayList<JavaConstructor>(1);
        constructors.add(new OXMJavaConstructorImpl(this));
        return constructors;
    }

    @Override
    public JavaField getDeclaredField(String name) {
        Collection<JavaField> allFields = this.getDeclaredFields();
        for (JavaField field2 : allFields) {
            if (!field2.getName().equals(name)) continue;
            return field2;
        }
        return null;
    }

    @Override
    public Collection<JavaField> getDeclaredFields() {
        ArrayList<JavaField> fieldsToReturn;
        block11: {
            block10: {
                fieldsToReturn = new ArrayList<JavaField>();
                if (this.enumValues == null) break block10;
                Iterator<String> iterator2 = this.enumValues.iterator();
                while (iterator2.hasNext()) {
                    fieldsToReturn.add(new OXMJavaFieldImpl(iterator2.next(), JAVA_LANG_OBJECT, this));
                }
                break block11;
            }
            JavaType.JavaAttributes javaAttributes = this.javaType.getJavaAttributes();
            if (javaAttributes == null) break block11;
            List<JAXBElement<? extends JavaAttribute>> fields = javaAttributes.getJavaAttribute();
            for (JAXBElement<? extends JavaAttribute> jaxbElement : fields) {
                String fieldType;
                String fieldName;
                JavaAttribute att = (JavaAttribute)jaxbElement.getValue();
                if (att instanceof XmlElement) {
                    XmlElement xme = (XmlElement)att;
                    fieldName = xme.getJavaAttribute();
                    fieldType = xme.getType();
                    fieldsToReturn.add(new OXMJavaFieldImpl(fieldName, fieldType, this));
                    continue;
                }
                if (att instanceof XmlElements) {
                    XmlElements xmes = (XmlElements)att;
                    fieldName = xmes.getJavaAttribute();
                    fieldType = JAVA_LANG_OBJECT;
                    fieldsToReturn.add(new OXMJavaFieldImpl(fieldName, fieldType, this));
                    continue;
                }
                if (att instanceof XmlElementRef) {
                    XmlElementRef xmer = (XmlElementRef)att;
                    fieldName = xmer.getJavaAttribute();
                    fieldType = xmer.getType();
                    fieldsToReturn.add(new OXMJavaFieldImpl(fieldName, fieldType, this));
                    continue;
                }
                if (att instanceof XmlAttribute) {
                    XmlAttribute xma = (XmlAttribute)att;
                    fieldName = xma.getJavaAttribute();
                    fieldType = xma.getType();
                    fieldsToReturn.add(new OXMJavaFieldImpl(fieldName, fieldType, this));
                    continue;
                }
                if (att instanceof XmlValue) {
                    XmlValue xmv = (XmlValue)att;
                    fieldName = xmv.getJavaAttribute();
                    fieldType = xmv.getType();
                    fieldsToReturn.add(new OXMJavaFieldImpl(fieldName, fieldType, this));
                    continue;
                }
                if (att instanceof XmlAnyElement) {
                    XmlAnyElement xmae = (XmlAnyElement)att;
                    fieldName = xmae.getJavaAttribute();
                    fieldType = JAVA_LANG_OBJECT;
                    fieldsToReturn.add(new OXMJavaFieldImpl(fieldName, fieldType, this));
                    continue;
                }
                if (att instanceof XmlAnyAttribute) {
                    XmlAnyAttribute xmaa = (XmlAnyAttribute)att;
                    fieldName = xmaa.getJavaAttribute();
                    fieldType = JAVA_UTIL_MAP;
                    fieldsToReturn.add(new OXMJavaFieldImpl(fieldName, fieldType, this));
                    continue;
                }
                if (att instanceof XmlJoinNodes) {
                    XmlJoinNodes xmjn = (XmlJoinNodes)att;
                    fieldName = xmjn.getJavaAttribute();
                    fieldType = xmjn.getType();
                    fieldsToReturn.add(new OXMJavaFieldImpl(fieldName, fieldType, this));
                    continue;
                }
                if (!(att instanceof XmlInverseReference)) continue;
                XmlInverseReference xmir = (XmlInverseReference)att;
                fieldName = xmir.getJavaAttribute();
                fieldType = xmir.getType();
                fieldsToReturn.add(new OXMJavaFieldImpl(fieldName, fieldType, this));
            }
        }
        return fieldsToReturn;
    }

    @Override
    public JavaMethod getDeclaredMethod(String name, JavaClass[] args) {
        return null;
    }

    @Override
    public Collection<JavaMethod> getDeclaredMethods() {
        return new ArrayList<JavaMethod>();
    }

    @Override
    public JavaMethod getMethod(String name, JavaClass[] args) {
        return null;
    }

    @Override
    public Collection<JavaMethod> getMethods() {
        return new ArrayList<JavaMethod>();
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public String getName() {
        if (this.javaType != null) {
            return this.javaType.getName();
        }
        return this.javaName;
    }

    @Override
    public JavaPackage getPackage() {
        return new OXMJavaPackageImpl(this.getPackageName());
    }

    @Override
    public String getPackageName() {
        int lastDotIndex = this.getQualifiedName().lastIndexOf(DOT);
        if (lastDotIndex == -1) {
            return EMPTY_STRING;
        }
        return this.getQualifiedName().substring(0, lastDotIndex);
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public String getRawName() {
        return this.getName();
    }

    @Override
    public JavaClass getSuperclass() {
        if (this.javaModel == null) {
            return null;
        }
        if (this.javaType != null && !this.javaType.getSuperType().equals("##default")) {
            return this.javaModel.getClass(this.javaType.getSuperType());
        }
        return this.javaModel.getClass(JAVA_LANG_OBJECT);
    }

    @Override
    public Type[] getGenericInterfaces() {
        return new Type[0];
    }

    @Override
    public Type getGenericSuperclass() {
        return null;
    }

    @Override
    public boolean hasActualTypeArguments() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isAnnotation() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isAssignableFrom(JavaClass arg0) {
        String thisJavaName = EMPTY_STRING;
        String argJavaName = arg0.getName();
        thisJavaName = this.javaName != null ? this.javaName : this.javaType.getName();
        if (thisJavaName.startsWith(JAVA) && argJavaName.startsWith(JAVA)) {
            try {
                Class thisClass = PrivilegedAccessHelper.getClassForName(thisJavaName);
                Class argClass = PrivilegedAccessHelper.getClassForName(argJavaName);
                return thisClass.isAssignableFrom(argClass);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return thisJavaName.equals(argJavaName);
    }

    @Override
    public boolean isEnum() {
        return this.enumValues != null;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isMemberClass() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isSynthetic() {
        throw new UnsupportedOperationException("isSynthetic");
    }

    @Override
    public JavaClassInstanceOf instanceOf() {
        return JavaClassInstanceOf.OXM_JAVA_CLASS_IMPL;
    }

    @Override
    public JavaAnnotation getAnnotation(JavaClass aClass) {
        return null;
    }

    @Override
    public Collection<JavaAnnotation> getAnnotations() {
        return new ArrayList<JavaAnnotation>();
    }

    @Override
    public JavaAnnotation getDeclaredAnnotation(JavaClass arg0) {
        return null;
    }

    @Override
    public Collection<JavaAnnotation> getDeclaredAnnotations() {
        return new ArrayList<JavaAnnotation>();
    }

    public void setJavaModel(JavaModel model) {
        this.javaModel = model;
    }

    public JavaModel getJavaModel() {
        return this.javaModel;
    }
}

