/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.helper.ConversionManager;

public class AnnotationProxy
implements InvocationHandler {
    private Map<String, Object> components;
    private ConversionManager conversionMgr;
    private static final String ANNOTATION_TYPE_METHOD_NAME = "annotationType";

    private AnnotationProxy(Map<String, Object> components, ConversionManager conversionMgr) {
        this.components = components;
        this.conversionMgr = conversionMgr;
    }

    public static <A extends Annotation> A getProxy(Map<String, Object> components, Class<A> annoClass, ClassLoader cl, ConversionManager conversionMgr) {
        if (components == null) {
            components = new HashMap<String, Object>();
        }
        components.put(ANNOTATION_TYPE_METHOD_NAME, annoClass.getName());
        return (A)((Annotation)Proxy.newProxyInstance(cl, new Class[]{annoClass}, (InvocationHandler)new AnnotationProxy(components, conversionMgr)));
    }

    public Map<String, Object> getComponents() {
        return this.components;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.components == null) {
            return null;
        }
        Class<?> returnType = method.getReturnType();
        Object value2 = this.getComponents().get(method.getName());
        if (value2 == null && returnType == Boolean.TYPE) {
            return false;
        }
        if (value2 == null && returnType == Boolean.class) {
            return Boolean.FALSE;
        }
        if (returnType.isArray()) {
            return this.handleArrayData(returnType, value2);
        }
        return this.conversionMgr.convertObject(value2, returnType);
    }

    private Object handleArrayData(Class returnType, Object value2) {
        if (value2 == null) {
            return null;
        }
        Object[] data2 = (Object[])value2;
        Class<?> componentType = returnType.getComponentType();
        Object[] convertedArray = (Object[])Array.newInstance(componentType, data2.length);
        int i = 0;
        while (i < data2.length) {
            convertedArray[i] = this.conversionMgr.convertObject(data2[i], componentType);
            ++i;
        }
        return convertedArray;
    }
}

