/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Vector;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ArrayRecord;

public class ResultSetRecord
extends ArrayRecord {
    protected transient ResultSet resultSet;
    protected transient ResultSetMetaData metaData;
    protected transient DatabaseAccessor accessor;
    protected transient DatabasePlatform platform;
    protected transient boolean optimizeData;
    protected transient AbstractSession session;

    protected ResultSetRecord() {
    }

    public ResultSetRecord(Vector fields, DatabaseField[] fieldsArray, ResultSet resultSet, ResultSetMetaData metaData, DatabaseAccessor accessor, AbstractSession session, DatabasePlatform platform, boolean optimizeData) {
        super(fields, fieldsArray, new Object[fieldsArray.length]);
        this.resultSet = resultSet;
        this.metaData = metaData;
        this.accessor = accessor;
        this.platform = platform;
        this.optimizeData = optimizeData;
        this.session = session;
    }

    public void loadAllValuesFromResultSet() {
        int size2 = this.valuesArray.length;
        int index2 = 0;
        while (index2 < size2) {
            DatabaseField field2;
            if (this.valuesArray[index2] == null && (field2 = this.fieldsArray[index2]) != null) {
                this.valuesArray[index2] = this.accessor.getObject(this.resultSet, field2, this.metaData, index2 + 1, this.platform, this.optimizeData, this.session);
            }
            ++index2;
        }
        this.resultSet = null;
        this.metaData = null;
        this.accessor = null;
        this.platform = null;
        this.session = null;
    }

    public void removeNonIndirectionValues() {
        if (this.fieldsArray != null) {
            int size2 = this.valuesArray.length;
            int index2 = 0;
            while (index2 < size2) {
                DatabaseField field2 = this.fieldsArray[index2];
                if (field2 != null && !field2.keepInRow) {
                    this.valuesArray[index2] = null;
                }
                ++index2;
            }
        }
    }

    public void removAllValue() {
        if (this.valuesArray != null) {
            int size2 = this.valuesArray.length;
            int index2 = 0;
            while (index2 < size2) {
                this.valuesArray[index2] = null;
                ++index2;
            }
        }
    }

    public boolean hasResultSet() {
        return this.resultSet != null;
    }

    public void removeResultSet() {
        this.resultSet = null;
        this.metaData = null;
        this.accessor = null;
        this.platform = null;
        this.session = null;
    }

    @Override
    public void clear() {
        this.removeResultSet();
        this.fieldsArray = null;
        this.valuesArray = null;
        super.clear();
    }

    @Override
    protected void checkValues() {
        if (this.resultSet != null) {
            this.loadAllValuesFromResultSet();
        }
        super.checkValues();
    }

    @Override
    public boolean containsValue(Object value2) {
        if (this.resultSet != null) {
            this.loadAllValuesFromResultSet();
        }
        return super.containsValue(value2);
    }

    @Override
    public Object get(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field2;
            int index2 = key.index;
            if (index2 < 0 || index2 >= this.size) {
                index2 = 0;
            }
            if ((field2 = this.fieldsArray[index2]) != key && !field2.equals(key)) {
                index2 = -1;
                int fieldIndex = 0;
                while (fieldIndex < this.size) {
                    field2 = this.fieldsArray[fieldIndex];
                    if (field2 == key || field2.equals(key)) {
                        if (key.index == -1) {
                            key.setIndex(fieldIndex);
                        }
                        index2 = fieldIndex;
                        break;
                    }
                    ++fieldIndex;
                }
                if (index2 < 0) {
                    return null;
                }
            }
            if (this.resultSet != null) {
                Object value2 = this.valuesArray[index2];
                if (value2 == null) {
                    this.valuesArray[index2] = value2 = this.accessor.getObject(this.resultSet, field2, this.metaData, index2 + 1, this.platform, this.optimizeData, this.session);
                } else {
                    this.loadAllValuesFromResultSet();
                }
                return value2;
            }
            return this.valuesArray[index2];
        }
        return super.get(key);
    }

    @Override
    public Object getIndicatingNoEntry(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field2;
            int index2 = key.index;
            if (index2 < 0 || index2 >= this.size) {
                index2 = 0;
            }
            if ((field2 = this.fieldsArray[index2]) != key && !field2.equals(key)) {
                index2 = -1;
                int fieldIndex = 0;
                while (fieldIndex < this.size) {
                    field2 = this.fieldsArray[fieldIndex];
                    if (field2 == key || field2.equals(key)) {
                        if (key.index == -1) {
                            key.setIndex(fieldIndex);
                        }
                        index2 = fieldIndex;
                        break;
                    }
                    ++fieldIndex;
                }
                if (index2 < 0) {
                    return null;
                }
            }
            if (this.resultSet != null) {
                Object value2 = this.valuesArray[index2];
                if (value2 == null) {
                    this.valuesArray[index2] = value2 = this.accessor.getObject(this.resultSet, field2, this.metaData, index2 + 1, this.platform, this.optimizeData, this.session);
                } else {
                    this.loadAllValuesFromResultSet();
                }
                return value2;
            }
            return this.valuesArray[index2];
        }
        return super.get(key);
    }

    @Override
    protected String toStringAditional() {
        return this.resultSet != null ? " hasResultSet" : "";
    }

    @Override
    public void setSopObject(Object sopObject) {
        super.setSopObject(sopObject);
        if (this.resultSet != null) {
            this.loadAllValuesFromResultSet();
        }
    }
}

