/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.namespaces;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceResolver;

public class StackUnmarshalNamespaceResolver
implements UnmarshalNamespaceResolver {
    private Map<String, List<String>> namespaceMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> uriToPrefixMap = new HashMap<String, List<String>>();

    @Override
    public String getPrefix(String namespaceURI) {
        int size2;
        List<String> prefixes = this.uriToPrefixMap.get(namespaceURI);
        if (prefixes != null && (size2 = prefixes.size()) > 0) {
            return prefixes.get(size2 - 1);
        }
        return null;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        int size2;
        List<String> uris;
        if (prefix == null) {
            prefix = "";
        }
        if ((uris = this.namespaceMap.get(prefix)) != null && (size2 = uris.size()) > 0) {
            return uris.get(size2 - 1);
        }
        return null;
    }

    @Override
    public void pop(String prefix) {
        int size2;
        List<String> uris = this.namespaceMap.get(prefix);
        if (uris != null && (size2 = uris.size()) > 0) {
            List<String> prefixes;
            String uri = uris.remove(size2 - 1);
            if (size2 == 1) {
                this.namespaceMap.remove(prefix);
            }
            if (uri != null && (prefixes = this.uriToPrefixMap.get(uri)) != null) {
                int prefixesSize = prefixes.size();
                if (prefixesSize == 1) {
                    this.uriToPrefixMap.remove(uri);
                } else {
                    prefixes.remove(prefixesSize - 1);
                }
            }
        }
    }

    @Override
    public void push(String prefix, String namespaceURI) {
        List<String> uris = this.namespaceMap.get(prefix);
        if (uris == null) {
            uris = new ArrayList<String>();
            this.namespaceMap.put(prefix, uris);
        }
        uris.add(namespaceURI);
        List<String> prefixes = this.uriToPrefixMap.get(namespaceURI);
        if (prefixes == null) {
            prefixes = new ArrayList<String>();
            this.uriToPrefixMap.put(namespaceURI, prefixes);
        }
        prefixes.add(prefix);
    }

    @Override
    public Set<String> getPrefixes() {
        return this.namespaceMap.keySet();
    }
}

