/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.xml;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.Handle;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.TypePath;
import org.eclipse.persistence.internal.libraries.asm.util.Printer;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXAdapter;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXAnnotationAdapter;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXClassAdapter;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXCodeAdapter
extends MethodVisitor {
    static final String[] TYPES = new String[]{"top", "int", "float", "double", "long", "null", "uninitializedThis"};
    SAXAdapter sa;
    int access;
    private final Map<Label, String> labelNames;

    public SAXCodeAdapter(SAXAdapter sAXAdapter, int n) {
        super(327680);
        this.sa = sAXAdapter;
        this.access = n;
        this.labelNames = new HashMap<Label, String>();
    }

    @Override
    public void visitParameter(String string2, int n) {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (string2 != null) {
            attributesImpl.addAttribute("", "name", "name", "", string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        SAXClassAdapter.appendAccess(n, stringBuffer);
        attributesImpl.addAttribute("", "access", "access", "", stringBuffer.toString());
        this.sa.addElement("parameter", attributesImpl);
    }

    @Override
    public final void visitCode() {
        if ((this.access & 0x700) == 0) {
            this.sa.addStart("code", new AttributesImpl());
        }
    }

    @Override
    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        switch (n) {
            case -1: 
            case 0: {
                if (n == -1) {
                    attributesImpl.addAttribute("", "type", "type", "", "NEW");
                } else {
                    attributesImpl.addAttribute("", "type", "type", "", "FULL");
                }
                this.sa.addStart("frame", attributesImpl);
                this.appendFrameTypes(true, n2, objectArray);
                this.appendFrameTypes(false, n3, objectArray2);
                break;
            }
            case 1: {
                attributesImpl.addAttribute("", "type", "type", "", "APPEND");
                this.sa.addStart("frame", attributesImpl);
                this.appendFrameTypes(true, n2, objectArray);
                break;
            }
            case 2: {
                attributesImpl.addAttribute("", "type", "type", "", "CHOP");
                attributesImpl.addAttribute("", "count", "count", "", Integer.toString(n2));
                this.sa.addStart("frame", attributesImpl);
                break;
            }
            case 3: {
                attributesImpl.addAttribute("", "type", "type", "", "SAME");
                this.sa.addStart("frame", attributesImpl);
                break;
            }
            case 4: {
                attributesImpl.addAttribute("", "type", "type", "", "SAME1");
                this.sa.addStart("frame", attributesImpl);
                this.appendFrameTypes(false, 1, objectArray2);
            }
        }
        this.sa.addEnd("frame");
    }

    private void appendFrameTypes(boolean bl, int n, Object[] objectArray) {
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            AttributesImpl attributesImpl = new AttributesImpl();
            if (object instanceof String) {
                attributesImpl.addAttribute("", "type", "type", "", (String)object);
            } else if (object instanceof Integer) {
                attributesImpl.addAttribute("", "type", "type", "", TYPES[(Integer)object]);
            } else {
                attributesImpl.addAttribute("", "type", "type", "", "uninitialized");
                attributesImpl.addAttribute("", "label", "label", "", this.getLabel((Label)object));
            }
            this.sa.addElement(bl ? "local" : "stack", attributesImpl);
        }
    }

    @Override
    public final void visitInsn(int n) {
        this.sa.addElement(Printer.OPCODES[n], new AttributesImpl());
    }

    @Override
    public final void visitIntInsn(int n, int n2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "value", "value", "", Integer.toString(n2));
        this.sa.addElement(Printer.OPCODES[n], attributesImpl);
    }

    @Override
    public final void visitVarInsn(int n, int n2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "var", "var", "", Integer.toString(n2));
        this.sa.addElement(Printer.OPCODES[n], attributesImpl);
    }

    @Override
    public final void visitTypeInsn(int n, String string2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "desc", "desc", "", string2);
        this.sa.addElement(Printer.OPCODES[n], attributesImpl);
    }

    @Override
    public final void visitFieldInsn(int n, String string2, String string3, String string4) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "owner", "owner", "", string2);
        attributesImpl.addAttribute("", "name", "name", "", string3);
        attributesImpl.addAttribute("", "desc", "desc", "", string4);
        this.sa.addElement(Printer.OPCODES[n], attributesImpl);
    }

    @Override
    public final void visitMethodInsn(int n, String string2, String string3, String string4, boolean bl) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "owner", "owner", "", string2);
        attributesImpl.addAttribute("", "name", "name", "", string3);
        attributesImpl.addAttribute("", "desc", "desc", "", string4);
        attributesImpl.addAttribute("", "itf", "itf", "", bl ? "true" : "false");
        this.sa.addElement(Printer.OPCODES[n], attributesImpl);
    }

    @Override
    public void visitInvokeDynamicInsn(String string2, String string3, Handle handle2, Object ... objectArray) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "name", "name", "", string2);
        attributesImpl.addAttribute("", "desc", "desc", "", string3);
        attributesImpl.addAttribute("", "bsm", "bsm", "", SAXClassAdapter.encode(handle2.toString()));
        this.sa.addStart("INVOKEDYNAMIC", attributesImpl);
        for (int i = 0; i < objectArray.length; ++i) {
            this.sa.addElement("bsmArg", SAXCodeAdapter.getConstantAttribute(objectArray[i]));
        }
        this.sa.addEnd("INVOKEDYNAMIC");
    }

    @Override
    public final void visitJumpInsn(int n, Label label) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "label", "label", "", this.getLabel(label));
        this.sa.addElement(Printer.OPCODES[n], attributesImpl);
    }

    @Override
    public final void visitLabel(Label label) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "name", "name", "", this.getLabel(label));
        this.sa.addElement("Label", attributesImpl);
    }

    @Override
    public final void visitLdcInsn(Object object) {
        this.sa.addElement(Printer.OPCODES[18], SAXCodeAdapter.getConstantAttribute(object));
    }

    private static AttributesImpl getConstantAttribute(Object object) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "cst", "cst", "", SAXClassAdapter.encode(object.toString()));
        attributesImpl.addAttribute("", "desc", "desc", "", Type.getDescriptor(object.getClass()));
        return attributesImpl;
    }

    @Override
    public final void visitIincInsn(int n, int n2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "var", "var", "", Integer.toString(n));
        attributesImpl.addAttribute("", "inc", "inc", "", Integer.toString(n2));
        this.sa.addElement(Printer.OPCODES[132], attributesImpl);
    }

    @Override
    public final void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "min", "min", "", Integer.toString(n));
        attributesImpl.addAttribute("", "max", "max", "", Integer.toString(n2));
        attributesImpl.addAttribute("", "dflt", "dflt", "", this.getLabel(label));
        String string2 = Printer.OPCODES[170];
        this.sa.addStart(string2, attributesImpl);
        for (int i = 0; i < labelArray.length; ++i) {
            AttributesImpl attributesImpl2 = new AttributesImpl();
            attributesImpl2.addAttribute("", "name", "name", "", this.getLabel(labelArray[i]));
            this.sa.addElement("label", attributesImpl2);
        }
        this.sa.addEnd(string2);
    }

    @Override
    public final void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "dflt", "dflt", "", this.getLabel(label));
        String string2 = Printer.OPCODES[171];
        this.sa.addStart(string2, attributesImpl);
        for (int i = 0; i < labelArray.length; ++i) {
            AttributesImpl attributesImpl2 = new AttributesImpl();
            attributesImpl2.addAttribute("", "name", "name", "", this.getLabel(labelArray[i]));
            attributesImpl2.addAttribute("", "key", "key", "", Integer.toString(nArray[i]));
            this.sa.addElement("label", attributesImpl2);
        }
        this.sa.addEnd(string2);
    }

    @Override
    public final void visitMultiANewArrayInsn(String string2, int n) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "desc", "desc", "", string2);
        attributesImpl.addAttribute("", "dims", "dims", "", Integer.toString(n));
        this.sa.addElement(Printer.OPCODES[197], attributesImpl);
    }

    @Override
    public final void visitTryCatchBlock(Label label, Label label2, Label label3, String string2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "start", "start", "", this.getLabel(label));
        attributesImpl.addAttribute("", "end", "end", "", this.getLabel(label2));
        attributesImpl.addAttribute("", "handler", "handler", "", this.getLabel(label3));
        if (string2 != null) {
            attributesImpl.addAttribute("", "type", "type", "", string2);
        }
        this.sa.addElement("TryCatch", attributesImpl);
    }

    @Override
    public final void visitMaxs(int n, int n2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "maxStack", "maxStack", "", Integer.toString(n));
        attributesImpl.addAttribute("", "maxLocals", "maxLocals", "", Integer.toString(n2));
        this.sa.addElement("Max", attributesImpl);
        this.sa.addEnd("code");
    }

    @Override
    public void visitLocalVariable(String string2, String string3, String string4, Label label, Label label2, int n) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "name", "name", "", string2);
        attributesImpl.addAttribute("", "desc", "desc", "", string3);
        if (string4 != null) {
            attributesImpl.addAttribute("", "signature", "signature", "", SAXClassAdapter.encode(string4));
        }
        attributesImpl.addAttribute("", "start", "start", "", this.getLabel(label));
        attributesImpl.addAttribute("", "end", "end", "", this.getLabel(label2));
        attributesImpl.addAttribute("", "var", "var", "", Integer.toString(n));
        this.sa.addElement("LocalVar", attributesImpl);
    }

    @Override
    public final void visitLineNumber(int n, Label label) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "line", "line", "", Integer.toString(n));
        attributesImpl.addAttribute("", "start", "start", "", this.getLabel(label));
        this.sa.addElement("LineNumber", attributesImpl);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return new SAXAnnotationAdapter(this.sa, "annotationDefault", 0, null, null);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        return new SAXAnnotationAdapter(this.sa, "annotation", bl ? 1 : -1, null, string2);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string2, boolean bl) {
        return new SAXAnnotationAdapter(this.sa, "typeAnnotation", bl ? 1 : -1, null, string2, n, typePath);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int n, String string2, boolean bl) {
        return new SAXAnnotationAdapter(this.sa, "parameterAnnotation", bl ? 1 : -1, n, string2);
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int n, TypePath typePath, String string2, boolean bl) {
        return new SAXAnnotationAdapter(this.sa, "insnAnnotation", bl ? 1 : -1, null, string2, n, typePath);
    }

    @Override
    public AnnotationVisitor visitTryCatchAnnotation(int n, TypePath typePath, String string2, boolean bl) {
        return new SAXAnnotationAdapter(this.sa, "tryCatchAnnotation", bl ? 1 : -1, null, string2, n, typePath);
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string2, boolean bl) {
        int n2;
        String[] stringArray = new String[labelArray.length];
        String[] stringArray2 = new String[labelArray2.length];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray[n2] = this.getLabel(labelArray[n2]);
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            stringArray2[n2] = this.getLabel(labelArray2[n2]);
        }
        return new SAXAnnotationAdapter(this.sa, "localVariableAnnotation", bl ? 1 : -1, null, string2, n, typePath, stringArray, stringArray2, nArray);
    }

    @Override
    public void visitEnd() {
        this.sa.addEnd("method");
    }

    private final String getLabel(Label label) {
        String string2 = this.labelNames.get(label);
        if (string2 == null) {
            string2 = Integer.toString(this.labelNames.size());
            this.labelNames.put(label, string2);
        }
        return string2;
    }
}

