/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.commons;

import org.eclipse.persistence.internal.libraries.asm.commons.Remapper;
import org.eclipse.persistence.internal.libraries.asm.signature.SignatureVisitor;

public class RemappingSignatureAdapter
extends SignatureVisitor {
    private final SignatureVisitor v;
    private final Remapper remapper;
    private String className;

    public RemappingSignatureAdapter(SignatureVisitor signatureVisitor, Remapper remapper) {
        this(327680, signatureVisitor, remapper);
    }

    protected RemappingSignatureAdapter(int n, SignatureVisitor signatureVisitor, Remapper remapper) {
        super(n);
        this.v = signatureVisitor;
        this.remapper = remapper;
    }

    @Override
    public void visitClassType(String string2) {
        this.className = string2;
        this.v.visitClassType(this.remapper.mapType(string2));
    }

    @Override
    public void visitInnerClassType(String string2) {
        String string3 = this.remapper.mapType(this.className) + '$';
        this.className = this.className + '$' + string2;
        String string4 = this.remapper.mapType(this.className);
        int n = string4.startsWith(string3) ? string3.length() : string4.lastIndexOf(36) + 1;
        this.v.visitInnerClassType(string4.substring(n));
    }

    @Override
    public void visitFormalTypeParameter(String string2) {
        this.v.visitFormalTypeParameter(string2);
    }

    @Override
    public void visitTypeVariable(String string2) {
        this.v.visitTypeVariable(string2);
    }

    @Override
    public SignatureVisitor visitArrayType() {
        this.v.visitArrayType();
        return this;
    }

    @Override
    public void visitBaseType(char c) {
        this.v.visitBaseType(c);
    }

    @Override
    public SignatureVisitor visitClassBound() {
        this.v.visitClassBound();
        return this;
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        this.v.visitExceptionType();
        return this;
    }

    @Override
    public SignatureVisitor visitInterface() {
        this.v.visitInterface();
        return this;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        this.v.visitInterfaceBound();
        return this;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        this.v.visitParameterType();
        return this;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        this.v.visitReturnType();
        return this;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        this.v.visitSuperclass();
        return this;
    }

    @Override
    public void visitTypeArgument() {
        this.v.visitTypeArgument();
    }

    @Override
    public SignatureVisitor visitTypeArgument(char c) {
        this.v.visitTypeArgument(c);
        return this;
    }

    @Override
    public void visitEnd() {
        this.v.visitEnd();
    }
}

