/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.parsing.FunctionalExpressionNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class DateFunctionNode
extends FunctionalExpressionNode {
    private Class type;

    @Override
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            reportQuery.addAttribute("date", this.generateExpression(context), this.type);
        }
    }

    @Override
    public void validate(ParseTreeContext context) {
        this.setType(this.type);
    }

    @Override
    public Expression generateExpression(GenerationContext context) {
        Expression expr = context.getBaseExpression();
        if (expr == null) {
            expr = new ExpressionBuilder();
        }
        Expression result2 = null;
        if (this.type == Date.class) {
            result2 = expr.currentDateDate();
        } else if (this.type == Time.class) {
            result2 = expr.currentTime();
        } else if (this.type == Timestamp.class) {
            result2 = expr.currentDate();
        }
        return result2;
    }

    public void useCurrentDate() {
        this.type = Date.class;
    }

    public void useCurrentTime() {
        this.type = Time.class;
    }

    public void useCurrentTimestamp() {
        this.type = Timestamp.class;
    }
}

