/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;

public class NonSynchronizedSubVector
extends NonSynchronizedVector {
    private Vector l;
    private int offset;
    private int size;

    public NonSynchronizedSubVector(Vector list2, int fromIndex, int toIndex) {
        super(0);
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > list2.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        this.l = list2;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public Object set(int index2, Object element) {
        return this.l.set(index2 + this.offset, element);
    }

    @Override
    public void setElementAt(Object obj, int index2) {
        this.set(index2, obj);
    }

    @Override
    public Object elementAt(int index2) {
        return this.get(index2);
    }

    @Override
    public Object firstElement() {
        return this.get(0);
    }

    @Override
    public Object lastElement() {
        return this.get(this.size() - 1);
    }

    @Override
    public int indexOf(Object elem2, int index2) {
        int size2 = this.size();
        if (elem2 == null) {
            int i = index2;
            while (i < size2) {
                if (this.get(i) == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = index2;
            while (i < size2) {
                if (elem2.equals(this.get(i))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem2, int index2) {
        int size2 = this.size();
        if (index2 >= size2) {
            throw new IndexOutOfBoundsException(String.valueOf(index2) + " >= " + size2);
        }
        if (elem2 == null) {
            int i = index2;
            while (i >= 0) {
                if (this.get(i) == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = index2;
            while (i >= 0) {
                if (elem2.equals(this.get(i))) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    @Override
    public Object get(int index2) {
        return this.l.get(index2 + this.offset);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int index2, Object element) {
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.l.add(index2 + this.offset, element);
        ++this.size;
        ++this.modCount;
    }

    @Override
    public Object remove(int index2) {
        Object result2 = this.l.remove(index2 + this.offset);
        --this.size;
        ++this.modCount;
        return result2;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index2, Collection c) {
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + this.size);
        }
        int cSize = c.size();
        if (cSize == 0) {
            return false;
        }
        this.l.addAll(this.offset + index2, c);
        this.size += cSize;
        ++this.modCount;
        return true;
    }

    @Override
    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < NonSynchronizedSubVector.this.size();
            }

            public Object nextElement() {
                if (this.count < NonSynchronizedSubVector.this.elementCount) {
                    return NonSynchronizedSubVector.this.get(this.count++);
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] result2 = new Object[this.size];
        System.arraycopy(this.l.toArray(), this.offset, result2, 0, this.size);
        return result2;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.l.toArray(), this.offset, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public Iterator iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator listIterator(int index2) {
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + this.size);
        }
        return new ListIterator(index2){
            private ListIterator i;
            {
                this.i = NonSynchronizedSubVector.this.l.listIterator(n + NonSynchronizedSubVector.this.offset);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < NonSynchronizedSubVector.this.size;
            }

            @Override
            public Object next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex() - NonSynchronizedSubVector.this.offset;
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex() - NonSynchronizedSubVector.this.offset;
            }

            @Override
            public void remove() {
                this.i.remove();
                NonSynchronizedSubVector nonSynchronizedSubVector = NonSynchronizedSubVector.this;
                nonSynchronizedSubVector.size = nonSynchronizedSubVector.size - 1;
                NonSynchronizedSubVector nonSynchronizedSubVector2 = NonSynchronizedSubVector.this;
                nonSynchronizedSubVector2.modCount = nonSynchronizedSubVector2.modCount + 1;
            }

            public void set(Object o) {
                this.i.set(o);
            }

            public void add(Object o) {
                this.i.add(o);
                NonSynchronizedSubVector nonSynchronizedSubVector = NonSynchronizedSubVector.this;
                nonSynchronizedSubVector.size = nonSynchronizedSubVector.size + 1;
                NonSynchronizedSubVector nonSynchronizedSubVector2 = NonSynchronizedSubVector.this;
                nonSynchronizedSubVector2.modCount = nonSynchronizedSubVector2.modCount + 1;
            }
        };
    }
}

