/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.persistence.logging.SessionLog;

public class DBPlatformHelper {
    private static final String DEFAULTPLATFORM = "org.eclipse.persistence.platform.database.DatabasePlatform";
    private static final String PROPERTY_PATH = "org/eclipse/persistence/internal/helper/";
    private static final String VENDOR_NAME_TO_PLATFORM_RESOURCE_NAME = "org/eclipse/persistence/internal/helper/VendorNameToPlatformMapping.properties";
    private static List<String[]> _nameToVendorPlatform = null;

    public static String getDBPlatform(String vendorName, SessionLog logger2) {
        DBPlatformHelper.initializeNameToVendorPlatform(logger2);
        String detectedDbPlatform = null;
        if (vendorName != null) {
            detectedDbPlatform = DBPlatformHelper.matchVendorNameInProperties(vendorName, _nameToVendorPlatform, logger2);
        }
        if (logger2.shouldLog(3)) {
            logger2.log(3, "connection", "dbPlatformHelper_detectedVendorPlatform", (Object)detectedDbPlatform);
        }
        if (detectedDbPlatform == null) {
            if (logger2.shouldLog(5)) {
                logger2.log(5, "connection", "dbPlatformHelper_defaultingPlatform", (Object)vendorName, (Object)DEFAULTPLATFORM);
            }
            detectedDbPlatform = DEFAULTPLATFORM;
        }
        return detectedDbPlatform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String[]> initializeNameToVendorPlatform(SessionLog logger2) {
        Class<DBPlatformHelper> clazz = DBPlatformHelper.class;
        synchronized (DBPlatformHelper.class) {
            if (_nameToVendorPlatform == null) {
                _nameToVendorPlatform = new ArrayList<String[]>();
                try {
                    DBPlatformHelper.loadFromResource(_nameToVendorPlatform, VENDOR_NAME_TO_PLATFORM_RESOURCE_NAME, DBPlatformHelper.class.getClassLoader());
                }
                catch (IOException iOException) {
                    logger2.log(6, "connection", "dbPlatformHelper_noMappingFound", (Object)VENDOR_NAME_TO_PLATFORM_RESOURCE_NAME);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _nameToVendorPlatform;
        }
    }

    private static String matchVendorNameInProperties(String vendorName, List<String[]> nameToVendorPlatform, SessionLog logger2) {
        String dbPlatform = null;
        Iterator<String[]> iterator2 = nameToVendorPlatform.iterator();
        while (dbPlatform == null && iterator2.hasNext()) {
            String[] entry2 = iterator2.next();
            String regExpr = entry2[0];
            String value2 = entry2[1];
            if (logger2.shouldLog(1)) {
                logger2.log(1, "connection", "dbPlatformHelper_regExprDbPlatform", (Object)regExpr, (Object)value2);
            }
            if (!DBPlatformHelper.matchPattern(regExpr, vendorName, logger2)) continue;
            dbPlatform = value2;
        }
        return dbPlatform;
    }

    private static boolean matchPattern(String regExp, String target, SessionLog logger2) {
        boolean matches;
        block2: {
            matches = false;
            try {
                matches = Pattern.matches(regExp, target);
            }
            catch (PatternSyntaxException e) {
                if (!logger2.shouldLog(3)) break block2;
                logger2.log(3, "connection", "dbPlatformHelper_patternSyntaxException", (Object)e);
            }
        }
        return matches;
    }

    private static void loadFromResource(List<String[]> properties, String resourceName, ClassLoader classLoader) throws IOException {
        DBPlatformHelper.load(properties, resourceName, classLoader);
    }

    private static void load(List<String[]> properties, String resourceName, ClassLoader classLoader) throws IOException {
        BufferedReader bin = new BufferedReader(new InputStreamReader(DBPlatformHelper.openResourceInputStream(resourceName, classLoader)));
        try {
            String line = bin.readLine();
            while (line != null) {
                String[] keyValue = DBPlatformHelper.validateLineForReturnAsKeyValueArray(line);
                if (keyValue != null) {
                    properties.add(keyValue);
                }
                line = bin.readLine();
            }
        }
        catch (Throwable throwable) {
            try {
                bin.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            bin.close();
        }
        catch (Exception exception) {}
    }

    private static InputStream openResourceInputStream(final String resourceName, final ClassLoader classLoader) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(resourceName);
                }
                return ClassLoader.getSystemResourceAsStream(resourceName);
            }
        });
    }

    private static String[] validateLineForReturnAsKeyValueArray(String line) {
        if (line == null || line.length() == 0) {
            return null;
        }
        if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
            return null;
        }
        int indexOfEquals = line.indexOf(61);
        if (indexOfEquals == -1) {
            return null;
        }
        String key = line.substring(0, indexOfEquals);
        String value2 = line.substring(indexOfEquals + 1, line.length());
        return new String[]{key, value2};
    }
}

